/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.connection;

import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.devmanage.IDeviceDiscoveryService;
import com.huawei.ism.tool.framework.pubservice.entity.DevServicePkg;
import com.huawei.ism.tool.obase.connection.DefaultSshJudge;
import com.huawei.ism.tool.obase.connection.SshConnection;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.util.List;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomDefaultSshJudge
extends DefaultSshJudge {
    private static final Logger log = LoggerFactory.getLogger(CustomDefaultSshJudge.class);
    private IDeviceDiscoveryService service = (IDeviceDiscoveryService)PublicServiceManage.getInstance().getService(IDeviceDiscoveryService.class);
    private Function<String, Boolean> isEndJudgeValid = ignored -> true;
    private Function<String, Boolean> isBlackEndJudge = ignored -> false;
    private Function<String, Boolean> isWhiteEndJudge = ignored -> false;

    @Override
    public boolean isSshFinish(String cmdResult, String userName) {
        if (this.isBlackEndJudge.apply(SshConnection.eliminatesResultColorCode(cmdResult.trim())).booleanValue()) {
            return false;
        }
        if (this.isWhiteEndJudge.apply(SshConnection.eliminatesResultColorCode(cmdResult.trim())).booleanValue()) {
            return true;
        }
        if (super.isSshFinish(cmdResult, userName)) {
            return true;
        }
        return this.checkEndingjudges(cmdResult);
    }

    private boolean checkEndingjudges(String ret) {
        if (StringUtils.isNULLStr(ret) || null == this.service) {
            return false;
        }
        String path = FileUtils.getProductSuprotPkgPath();
        List allEchos = this.service.loadAllDevServicePkgs(path);
        if (null == allEchos || allEchos.isEmpty()) {
            return false;
        }
        String trimmedRet = ret.trim();
        for (DevServicePkg desServicePkg : allEchos) {
            List endingJudges = desServicePkg.getEndingJudge();
            for (String string : endingJudges) {
                if (!trimmedRet.endsWith(string)) continue;
                if (!this.isEndJudgeValid.apply(string).booleanValue()) {
                    log.warn("should judge finished cmd result is skipped for {}, res: {}", (Object)string, (Object)trimmedRet);
                    continue;
                }
                log.info("ssh connect success, devType :{}", (Object)desServicePkg.getDevType());
                return true;
            }
        }
        return false;
    }

    public void setIsEndJudgeValid(Function<String, Boolean> isEndJudgeValid) {
        this.isEndJudgeValid = isEndJudgeValid;
    }

    public void setIsBlackEndJudge(Function<String, Boolean> isBlackEndJudge) {
        this.isBlackEndJudge = isBlackEndJudge;
    }

    public void setIsWhiteEndJudge(Function<String, Boolean> isWhiteEndJudge) {
        this.isWhiteEndJudge = isWhiteEndJudge;
    }
}

