/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.connection.mina;

import com.huawei.ism.tool.obase.entity.PriKeyInfo;
import com.huawei.ism.tool.obase.utils.SecurityConfigUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.tool.framwork.util.func.LocalHostUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PublicKey;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.sshd.client.ClientBuilder;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.auth.UserAuthFactory;
import org.apache.sshd.client.auth.keyboard.UserAuthKeyboardInteractiveFactory;
import org.apache.sshd.client.auth.password.UserAuthPasswordFactory;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.keyverifier.AcceptAllServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.BuiltinFactory;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.cipher.BuiltinCiphers;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntryDataResolver;
import org.apache.sshd.common.config.keys.PublicKeyEntryDecoder;
import org.apache.sshd.common.digest.BaseDigest;
import org.apache.sshd.common.digest.BuiltinDigests;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.future.CancelOption;
import org.apache.sshd.common.kex.BuiltinDHFactories;
import org.apache.sshd.common.mac.BuiltinMacs;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.apache.sshd.core.CoreModuleProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshUtils {
    private static final Logger log = LoggerFactory.getLogger(SshUtils.class);
    public static final int TIME_OUT;
    public static final int VERIFY_TIME = 300000;
    public static final List<BuiltinCiphers> ALL_CIPHER_FACTORY_ALGORITHM;
    public static final List<BuiltinMacs> ALL_MAC_FACTORY_ALGORITHM;
    public static final List<BuiltinSignatures> ALL_SIGNATURE_FACTORY_ALGORITHM;
    public static final List<BuiltinDHFactories> ALL_KEY_EXCHANGE_FACTORY_ALGORITHM;

    public static String getKnownHostsInfo(ClientSession session, String hostName) {
        PublicKey serverKey = session.getServerKey();
        String knownHostsInfo = "";
        PublicKeyEntryDecoder decoder = KeyUtils.getPublicKeyEntryDecoder((Key)serverKey);
        try (ByteArrayOutputStream content = new ByteArrayOutputStream(serverKey.getEncoded().length);){
            String keyType = decoder.encodePublicKey((OutputStream)content, serverKey);
            String hostKey = PublicKeyEntryDataResolver.DEFAULT.encodeEntryKeyData(content.toByteArray());
            knownHostsInfo = hostName + " " + keyType + " " + hostKey;
        }
        catch (IOException e) {
            log.error("get publicKey error.", e);
        }
        return knownHostsInfo;
    }

    public static String getFingerPrint(ClientSession session) {
        PublicKey serverKey = session.getServerKey();
        return KeyUtils.getFingerPrint((Digest)new BaseDigest(BuiltinDigests.md5.getAlgorithm(), serverKey.getEncoded().length), (PublicKey)serverKey).replaceFirst("MD5:", "");
    }

    public static ClientSession getDefaultSession(String username, String hostName, int hostPort, String pwd) throws IOException {
        SshClient client = SshUtils.getDefaultSshClient(SecurityConfigUtil.isOnlySecurityAlgorithm() && !LocalHostUtil.isRunInSvp());
        SshUtils.setClientAuthMethod(client);
        client.start();
        ClientSession session = (ClientSession)((ConnectFuture)client.connect(username, hostName, hostPort).verify(300000L, new CancelOption[0])).getSession();
        CoreModuleProperties.IDLE_TIMEOUT.set((PropertyResolver)session, (Object)Duration.ofMinutes(30L));
        session.addPasswordIdentity(pwd);
        return session;
    }

    public static ClientSession getSessionWithPublicKey(String username, String hostName, int hostPort, String pwd, PriKeyInfo priKeyInfo) throws IOException {
        SshClient client = SshUtils.getDefaultSshClient(SecurityConfigUtil.isOnlySecurityAlgorithm() && !LocalHostUtil.isRunInSvp());
        if (Objects.isNull(priKeyInfo)) {
            SshUtils.setClientAuthMethod(client);
        }
        client.start();
        ClientSession session = (ClientSession)((ConnectFuture)client.connect(username, hostName, hostPort).verify(300000L, new CancelOption[0])).getSession();
        session.addPasswordIdentity(pwd);
        if (!Objects.isNull(priKeyInfo)) {
            log.info("create public key success.");
            SshUtils.setPublicKey(session, priKeyInfo);
        }
        return session;
    }

    public static void setPublicKey(ClientSession session, PriKeyInfo priKeyInfo) throws IOException {
        Collection keyPairs = null;
        try {
            keyPairs = SecurityUtils.getKeyPairResourceParser().loadKeyPairs(null, Paths.get(priKeyInfo.getKeyPath(), new String[0]), FilePasswordProvider.of((String)priKeyInfo.getKeyPwd()), new OpenOption[0]);
        }
        catch (GeneralSecurityException e) {
            log.error("set public key error.", e);
            throw new IOException(e);
        }
        for (KeyPair keyPair : keyPairs) {
            session.addPublicKeyIdentity(keyPair);
        }
    }

    public static SshClient getDefaultSshClient(boolean isOnlySecurityAlgorithm) {
        SshClient client = SshClient.setUpDefaultClient();
        CoreModuleProperties.NIO_WORKERS.set((PropertyResolver)client, (Object)1);
        SshUtils.setDefaultClientFactories(client, isOnlySecurityAlgorithm);
        return client;
    }

    @Deprecated
    public static SshClient getDefaultSshClient() {
        return SshUtils.getDefaultSshClient(false);
    }

    @Deprecated
    public static void setDefaultClientFactories(SshClient client) {
        SshUtils.setDefaultClientFactories(client, false);
    }

    public static void setDefaultClientFactories(SshClient client, boolean isOnlySecurityAlgorithm) {
        if (isOnlySecurityAlgorithm) {
            SshUtils.removeNoSafeAlgorithm(client);
            return;
        }
        client.setCipherFactories(BuiltinFactory.setUpFactories((boolean)true, ALL_CIPHER_FACTORY_ALGORITHM));
        client.setMacFactories(BuiltinFactory.setUpFactories((boolean)true, ALL_MAC_FACTORY_ALGORITHM));
        client.setSignatureFactories(BuiltinFactory.setUpFactories((boolean)true, ALL_SIGNATURE_FACTORY_ALGORITHM));
        client.setKeyExchangeFactories(NamedFactory.setUpTransformedFactories((boolean)true, ALL_KEY_EXCHANGE_FACTORY_ALGORITHM, ClientBuilder.DH2KEX));
    }

    private static void removeNoSafeAlgorithm(SshClient client) {
        client.getCipherFactories().remove(BuiltinCiphers.aes128cbc);
        client.getCipherFactories().remove(BuiltinCiphers.aes192cbc);
        client.getCipherFactories().remove(BuiltinCiphers.aes256cbc);
        client.getSignatureFactories().remove(BuiltinSignatures.rsa);
    }

    private static void setClientAuthMethod(SshClient client) {
        client.setServerKeyVerifier(AcceptAllServerKeyVerifier.INSTANCE);
        ArrayList<UserAuthFactory> userAuthFactories = new ArrayList<UserAuthFactory>();
        userAuthFactories.add(UserAuthPasswordFactory.INSTANCE);
        userAuthFactories.add(UserAuthKeyboardInteractiveFactory.INSTANCE);
        client.setUserAuthFactories(userAuthFactories);
    }

    static {
        ALL_CIPHER_FACTORY_ALGORITHM = Collections.unmodifiableList(Arrays.asList(BuiltinCiphers.aes128ctr, BuiltinCiphers.aes128gcm, BuiltinCiphers.aes256gcm, BuiltinCiphers.aes192ctr, BuiltinCiphers.aes256ctr, BuiltinCiphers.cc20p1305_openssh, BuiltinCiphers.aes128cbc, BuiltinCiphers.aes192cbc, BuiltinCiphers.aes256cbc, BuiltinCiphers.arcfour128, BuiltinCiphers.arcfour256, BuiltinCiphers.blowfishcbc, BuiltinCiphers.tripledescbc, BuiltinCiphers.none));
        ALL_MAC_FACTORY_ALGORITHM = Collections.unmodifiableList(Arrays.asList(BuiltinMacs.hmacsha512, BuiltinMacs.hmacsha512etm, BuiltinMacs.hmacsha256, BuiltinMacs.hmacsha256etm, BuiltinMacs.hmacsha196, BuiltinMacs.hmacsha1etm, BuiltinMacs.hmacsha1, BuiltinMacs.hmacmd596, BuiltinMacs.hmacmd5));
        ALL_SIGNATURE_FACTORY_ALGORITHM = Collections.unmodifiableList(Arrays.asList(BuiltinSignatures.ed25519, BuiltinSignatures.ed25519_cert, BuiltinSignatures.sk_ssh_ed25519, BuiltinSignatures.nistp521_cert, BuiltinSignatures.nistp384_cert, BuiltinSignatures.nistp256_cert, BuiltinSignatures.sk_ecdsa_sha2_nistp256, BuiltinSignatures.nistp521, BuiltinSignatures.nistp384, BuiltinSignatures.nistp256, BuiltinSignatures.rsaSHA512_cert, BuiltinSignatures.rsaSHA512, BuiltinSignatures.rsaSHA256_cert, BuiltinSignatures.rsaSHA256, BuiltinSignatures.dsa, BuiltinSignatures.dsa_cert, BuiltinSignatures.rsa, BuiltinSignatures.rsa_cert));
        ALL_KEY_EXCHANGE_FACTORY_ALGORITHM = Collections.unmodifiableList(Arrays.asList(BuiltinDHFactories.curve25519, BuiltinDHFactories.curve25519_libssh, BuiltinDHFactories.dhg15_512, BuiltinDHFactories.dhg16_512, BuiltinDHFactories.dhg17_512, BuiltinDHFactories.dhg18_512, BuiltinDHFactories.dhgex256, BuiltinDHFactories.curve448, BuiltinDHFactories.ecdhp521, BuiltinDHFactories.ecdhp384, BuiltinDHFactories.ecdhp256, BuiltinDHFactories.dhg14_256, BuiltinDHFactories.dhg1, BuiltinDHFactories.dhg14, BuiltinDHFactories.dhgex));
        String timeoutValue = StringUtils.getToolConfig("app.ssh.timeout.default");
        TIME_OUT = StringUtils.isDigit(timeoutValue) ? Integer.parseInt(timeoutValue) * 1000 : 30000;
    }
}

