/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.connection.support;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.connection.support.CmdRequestBean;
import com.huawei.ism.tool.obase.connection.support.ConnUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.channel.ClientChannelEvent;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.future.CancelOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionMonitor
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionMonitor.class);
    protected static final int TIME_OUT = 50000;
    protected static final int QUERY_RATE = 10;
    protected CmdRequestBean cmdRequest = null;
    private ClientSession session = null;
    private final PipedOutputStream pos = new PipedOutputStream();
    private final ByteArrayOutputStream stdout = new ByteArrayOutputStream();
    private final ByteArrayOutputStream stderr = new ByteArrayOutputStream();
    private PipedInputStream pis = null;
    private OutputStream stdin = null;
    private ChannelShell shellChannel = null;
    protected volatile boolean active = true;

    protected SessionMonitor() {
    }

    public SessionMonitor(ClientSession session) {
        this.session = session;
    }

    public void startShell() throws IOException {
        this.cmdRequest = new CmdRequestBean();
        this.shellChannel = this.session.createShellChannel();
        this.shellChannel.setPtyType("bash");
        this.shellChannel.setPtyLines(Integer.MAX_VALUE);
        this.shellChannel.setPtyColumns(Integer.MAX_VALUE);
        this.shellChannel.setUsePty(true);
        this.shellChannel.setIn(this.pis);
        this.shellChannel.setOut(this.stdout);
        this.shellChannel.setErr(this.stderr);
        this.shellChannel.open().verify(50000L, TimeUnit.SECONDS, new CancelOption[0]);
        this.stdin = this.shellChannel.getInvertedIn();
    }

    public boolean isActive() {
        return this.active;
    }

    public void sendCmd(String cmd) throws IOException {
        this.stdin.write(cmd.getBytes(Charset.defaultCharset()));
        this.stdin.flush();
        this.shellChannel.waitFor(EnumSet.of(ClientChannelEvent.OPENED), Duration.ofSeconds(10L));
    }

    public void sendCmd(int cmd) throws IOException {
        this.stdin.write(cmd);
        this.stdin.flush();
        this.shellChannel.waitFor(EnumSet.of(ClientChannelEvent.OPENED), Duration.ofSeconds(10L));
    }

    public String getCurrentStdOut(boolean isFlush) {
        if (this.isOver()) {
            return this.cmdRequest.getStdoutResult(isFlush);
        }
        try {
            this.cmdRequest.appendStdout(this.getStdString(this.stdout));
        }
        catch (IOException e) {
            LOGGER.error("get standard out error.", e);
        }
        return this.cmdRequest.getStdoutResult(isFlush);
    }

    private boolean isOver() {
        if (this.shellChannel.isEofSent() || this.shellChannel.isEofSignalled() || this.shellChannel.isClosed()) {
            LOGGER.error("It seems EOF or EXIT_SIGNAL happened!!");
            return true;
        }
        return false;
    }

    public String getCurrentStdErr(boolean isFlush) {
        return this.cmdRequest.getStderrResult(isFlush);
    }

    public void close() {
        this.active = false;
        StreamUtils.closeStream((OutputStream)this.stdin, null);
        StreamUtils.closeStream((OutputStream)this.stdout, null);
        StreamUtils.closeStream((OutputStream)this.stderr, null);
        StreamUtils.closeStream(null, (InputStream)this.pis);
        StreamUtils.closeStream((OutputStream)this.pos, null);
        try {
            this.shellChannel.close();
        }
        catch (IOException e) {
            LOGGER.error("close shell channel error.", e);
        }
        try {
            this.session.close();
        }
        catch (IOException e) {
            LOGGER.error("close session error.", e);
        }
    }

    @Override
    public void run() {
        while (this.active) {
            if (this.shellChannel.isEofSent() || this.shellChannel.isEofSignalled() || this.shellChannel.isClosed()) {
                LOGGER.error("It seems EOF or EXIT_SIGNAL happened!!");
                this.active = false;
                SshConnectionManager.checkDeleteConnections();
                return;
            }
            try {
                this.consumeStdOutAndErr();
            }
            catch (IOException e) {
                LOGGER.error("<ssh>read stdout / stderr failed...", e);
            }
            ConnUtils.sleep(10);
        }
    }

    protected void consumeStdOutAndErr() throws IOException {
        this.cmdRequest.appendStdout(this.getStdString(this.stdout));
        this.cmdRequest.appendStderr(this.getStdString(this.stderr));
    }

    protected synchronized byte[] getStdString(ByteArrayOutputStream is) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        while (is.size() > 0) {
            is.writeTo(buffer);
            is.reset();
            ConnUtils.sleep(50);
        }
        byte[] content = buffer.toByteArray();
        buffer.reset();
        return content;
    }
}

