/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.db;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.File;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;

public class SqliteManager {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SqliteManager.class);
    private static final String JDBC_CLASS_NAME = "org.sqlite.JDBC";
    private static final String JDBC_URI = "jdbc:sqlite:";

    public Connection getConnection(String dbAbsolutePath) {
        if (StringUtils.isNULLStr(dbAbsolutePath) || !this.checkFileExist(dbAbsolutePath)) {
            return null;
        }
        try {
            Class.forName(JDBC_CLASS_NAME);
            return DriverManager.getConnection(JDBC_URI + dbAbsolutePath);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error(String.format(Locale.ENGLISH, "class load error %s", e));
        }
        catch (SQLException e) {
            LOGGER.error(String.format(Locale.ENGLISH, "get jdbc conn exception. ", new Object[0]));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateWithParams(Connection conn, String sql, Object ... params) {
        PreparedStatement pres;
        boolean res;
        block7: {
            res = false;
            pres = null;
            if (null != conn) break block7;
            LOGGER.error("excute SQL with param get connection error");
            boolean bl = false;
            this.close(null, null, pres);
            return bl;
        }
        try {
            pres = conn.prepareStatement(sql);
            if (null != params) {
                for (int i = 0; i < params.length; ++i) {
                    this.setParam(pres, params[i], i + 1);
                }
            }
            pres.executeUpdate();
            res = true;
            this.close(null, null, pres);
        }
        catch (SQLException e) {
            try {
                LOGGER.error(String.format(Locale.ENGLISH, "excute update with param error .", new Object[0]));
                this.close(null, null, pres);
            }
            catch (Throwable throwable) {
                this.close(null, null, pres);
                throw throwable;
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(Connection conn, String sql) {
        PreparedStatement pres;
        block5: {
            pres = null;
            if (null != conn) break block5;
            LOGGER.error("excute SQL get connection error.");
            boolean bl = false;
            this.close(null, null, pres);
            return bl;
        }
        try {
            pres = conn.prepareStatement(sql);
            pres.executeUpdate();
            this.close(null, null, pres);
        }
        catch (SQLException e) {
            try {
                LOGGER.error(String.format(Locale.ENGLISH, "excute update sql error .", new Object[0]));
                boolean bl = false;
                this.close(null, null, pres);
                return bl;
            }
            catch (Throwable throwable) {
                this.close(null, null, pres);
                throw throwable;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean updateBatch(Connection conn, String sql, List<List<Object>> params) {
        PreparedStatement preStatement;
        block13: {
            preStatement = null;
            if (conn == null) {
                LOGGER.error("sql connection error.");
                return false;
            }
            conn.setAutoCommit(false);
            for (List<Object> param : params) {
                preStatement = conn.prepareStatement(sql);
                for (int index = 0; index < param.size(); ++index) {
                    this.setParam(preStatement, param.get(index), index + 1);
                }
                preStatement.executeUpdate();
            }
            conn.commit();
            try {
                conn.setAutoCommit(true);
                break block13;
            }
            catch (SQLException ex) {
                LOGGER.error("set auto commit failed");
            }
            break block13;
            catch (SQLException e) {
                boolean bl;
                try {
                    LOGGER.error(String.format(Locale.ENGLISH, "execute update sql error .", new Object[0]));
                    bl = false;
                }
                catch (Throwable throwable) {
                    try {
                        conn.setAutoCommit(true);
                    }
                    catch (SQLException ex) {
                        LOGGER.error("set auto commit failed");
                    }
                    this.close(null, null, preStatement);
                    throw throwable;
                }
                try {
                    conn.setAutoCommit(true);
                }
                catch (SQLException ex) {
                    LOGGER.error("set auto commit failed");
                }
                this.close(null, null, preStatement);
                return bl;
            }
        }
        this.close(null, null, preStatement);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> query(Connection conn, String sql) {
        List<Map<String, Object>> list;
        ResultSet rs;
        PreparedStatement pres;
        block5: {
            pres = null;
            rs = null;
            list = new LinkedList<Map<String, Object>>();
            if (null != conn) break block5;
            LOGGER.error("excute SQL get connection error.");
            LinkedList<Map<String, Object>> linkedList = list;
            this.close(null, rs, pres);
            return linkedList;
        }
        try {
            pres = conn.prepareStatement(sql);
            rs = pres.executeQuery();
            list = this.getResult(rs);
            this.close(null, rs, pres);
        }
        catch (SQLException e) {
            try {
                LOGGER.error(String.format(Locale.ENGLISH, "excute statement error .", new Object[0]));
                this.close(null, rs, pres);
            }
            catch (Throwable throwable) {
                this.close(null, rs, pres);
                throw throwable;
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Long> updateAndGetIds(Connection conn, String sql) {
        LinkedList<Long> list;
        ResultSet rs;
        PreparedStatement pres;
        block6: {
            pres = null;
            rs = null;
            list = new LinkedList<Long>();
            if (null != conn) break block6;
            LOGGER.error("excute SQL get connection error.");
            LinkedList<Long> linkedList = list;
            this.close(null, rs, pres);
            return linkedList;
        }
        try {
            pres = conn.prepareStatement(sql, 1);
            pres.executeUpdate();
            rs = pres.getGeneratedKeys();
            while (rs != null && rs.next()) {
                list.add(rs.getLong(1));
            }
            this.close(null, rs, pres);
        }
        catch (SQLException e) {
            try {
                LOGGER.error(String.format(Locale.ENGLISH, "excute statement error .", new Object[0]));
                this.close(null, rs, pres);
            }
            catch (Throwable throwable) {
                this.close(null, rs, pres);
                throw throwable;
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> fetchOneForValues(Connection conn, String sql) {
        ResultSetMetaData md;
        LinkedList<Object> list;
        ResultSet rs;
        PreparedStatement pres;
        block9: {
            block8: {
                block7: {
                    pres = null;
                    rs = null;
                    list = new LinkedList<Object>();
                    if (null != conn) break block7;
                    LOGGER.error("excute SQL get connection error.");
                    LinkedList<Object> linkedList = list;
                    this.close(null, rs, pres);
                    return linkedList;
                }
                pres = conn.prepareStatement(sql);
                rs = pres.executeQuery();
                if (null != rs) break block8;
                LinkedList<Object> linkedList = list;
                this.close(null, rs, pres);
                return linkedList;
            }
            md = rs.getMetaData();
            if (md != null) break block9;
            LinkedList<Object> linkedList = list;
            this.close(null, rs, pres);
            return linkedList;
        }
        try {
            int columnCount = md.getColumnCount();
            List<Object> list2 = this.parsesObjects(rs, list, md, columnCount);
            this.close(null, rs, pres);
            return list2;
        }
        catch (SQLException e) {
            try {
                LOGGER.error(String.format(Locale.ENGLISH, "excute statement error .", new Object[0]));
                this.close(null, rs, pres);
            }
            catch (Throwable throwable) {
                this.close(null, rs, pres);
                throw throwable;
            }
        }
        return list;
    }

    private List<Object> parsesObjects(ResultSet rs, List<Object> list, ResultSetMetaData md, int columnCount) throws SQLException {
        if (rs.next()) {
            LinkedList<Object> rowData = new LinkedList<Object>();
            for (int i = 1; i <= columnCount; ++i) {
                if ("BLOB".equals(String.valueOf(md.getColumnType(i)))) {
                    rowData.add(rs.getByte(i));
                    continue;
                }
                rowData.add(rs.getObject(i));
            }
            list.add(rowData);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public List<Map<String, Object>> queryWithParams(Connection conn, String sql, Object ... params) {
        List<Map<String, Object>> list;
        ResultSet rs;
        PreparedStatement pres;
        block9: {
            pres = null;
            rs = null;
            list = new ArrayList<Map<String, Object>>();
            if (null != conn) break block9;
            LOGGER.error("excute querySQL with param get connection error.");
            ArrayList<Map<String, Object>> arrayList = list;
            this.close(null, rs, pres);
            return arrayList;
        }
        try {
            pres = conn.prepareStatement(sql);
            if (null != params) {
                for (int i = 0; i < params.length; ++i) {
                    this.setParam(pres, params[i], i + 1);
                }
            }
            rs = pres.executeQuery();
            list = this.getResult(rs);
            this.close(null, rs, pres);
        }
        catch (SQLException e1) {
            LOGGER.error(String.format(Locale.ENGLISH, "excute query with param error .", new Object[0]));
            this.close(null, rs, pres);
        }
        catch (Exception e) {
            LOGGER.error(String.format(Locale.ENGLISH, "query unknow error: %s", e));
            this.close(null, rs, pres);
            {
                catch (Throwable throwable) {
                    this.close(null, rs, pres);
                    throw throwable;
                }
            }
        }
        return list;
    }

    public void close(Connection conn, ResultSet resultSet, PreparedStatement pres) {
        if (null != resultSet) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                LOGGER.error(String.format(Locale.ENGLISH, "close ResultSet error ", new Object[0]));
            }
        }
        if (null != pres) {
            try {
                pres.close();
            }
            catch (SQLException e) {
                LOGGER.error(String.format(Locale.ENGLISH, "close prepareStatement error ", new Object[0]));
            }
        }
        if (null != conn) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                LOGGER.error(String.format(Locale.ENGLISH, "close connection error", new Object[0]));
            }
        }
    }

    private PreparedStatement setParam(PreparedStatement pres, Object param, int index) {
        if (null == param) {
            return pres;
        }
        try {
            if (param instanceof String) {
                pres.setString(index, String.valueOf(param));
            } else if (param instanceof Integer) {
                pres.setInt(index, Integer.valueOf(param.toString()));
            } else if (param instanceof Double) {
                pres.setDouble(index, Double.valueOf(param.toString()));
            } else if (param instanceof Long) {
                pres.setLong(index, Long.valueOf(param.toString()));
            } else if (param instanceof java.util.Date) {
                pres.setDate(index, (Date)param);
            } else if (param instanceof byte[]) {
                pres.setBytes(index, (byte[])param);
            } else if (param instanceof Boolean) {
                pres.setBoolean(index, Boolean.valueOf(param.toString()));
            } else if (param instanceof Array) {
                pres.setArray(index, (java.sql.Array)param);
            } else {
                LOGGER.error(String.format(Locale.ENGLISH, "can't find type,set String %s", param));
                pres.setString(index, param.toString());
            }
        }
        catch (SQLException e) {
            LOGGER.error(String.format(Locale.ENGLISH, "set SQL param errror.index :%s ", index));
        }
        return pres;
    }

    private List<Map<String, Object>> getResult(ResultSet rs) {
        LinkedList<Map<String, Object>> list = new LinkedList<Map<String, Object>>();
        ResultSetMetaData md = null;
        try {
            if (null == rs) {
                return list;
            }
            md = rs.getMetaData();
            if (md == null) {
                return list;
            }
            int columnCount = md.getColumnCount();
            HashMap<String, Object> rowData = null;
            while (rs.next()) {
                rowData = new HashMap<String, Object>(columnCount);
                for (int i = 1; i <= columnCount; ++i) {
                    if ("BLOB".equals(String.valueOf(md.getColumnType(i)))) {
                        rowData.put(md.getColumnName(i), rs.getByte(i));
                        continue;
                    }
                    rowData.put(md.getColumnName(i), rs.getObject(i));
                }
                list.add(rowData);
            }
        }
        catch (Exception e) {
            LOGGER.error(String.format(Locale.ENGLISH, "get result error %s", e));
        }
        return list;
    }

    public void closeConnectionSafely(Connection conn) {
        if (null != conn) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                LOGGER.error("close connection error!");
            }
        }
    }

    public boolean checkFileExist(String filePath) {
        try {
            File file = new File(filePath);
            return file.exists();
        }
        catch (Exception e) {
            LOGGER.error(String.format(Locale.ENGLISH, "check file exist error %s", e));
            return false;
        }
    }
}

