/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.entity;

import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.obase.utils.Base64EncodeUtils;
import java.io.Serializable;

public class User
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 2702015259295285879L;
    public static final int USERNAME_MAX_LENGTH = 16;
    private String userName = null;
    private String password = null;
    private int port;
    private boolean domain = false;
    private String domainName = null;

    public boolean isDomain() {
        return this.domain;
    }

    public void setDomain(boolean domain) {
        this.domain = domain;
    }

    public User() {
    }

    public User(String userName, String password) {
        this.userName = userName;
        this.setPassword(password);
        this.domain = userName == null ? false : userName.startsWith("domain/");
    }

    public User(String userName, String password, int port) {
        this.userName = userName;
        this.setPassword(password);
        this.port = port;
        this.domain = userName == null ? false : userName.startsWith("domain/");
    }

    public User(User user) {
        this.userName = user.getUserName();
        this.setPassword(user.getPassword());
        this.port = user.getPort();
        this.domain = this.userName == null ? false : this.userName.startsWith("domain/");
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return AESEncrypt.decrypt((String)this.password);
    }

    public String getEcptPassword() {
        return this.password;
    }

    public void setEcptPassword(String pwd) {
        this.password = pwd;
    }

    public void setPassword(String pwd) {
        this.password = AESEncrypt.encrypt((String)pwd);
    }

    public String getRootDecrpPassword() {
        return Base64EncodeUtils.decode(AESEncrypt.decrypt((String)this.password));
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String toString() {
        return "User [password=******, userName=" + this.userName + "]";
    }

    public Object clone() throws CloneNotSupportedException {
        return (User)super.clone();
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domainName) {
        this.domainName = domainName;
    }
}

