/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.filechooser;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.file.FileTypeUtils;
import com.huawei.ism.tool.file.SecurityUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.entity.DictionaryPara;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.filechooser.HibernateContainer;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.FileChooserWrapper;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.IsmFileChooser;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.JFileChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ToolFileChooser {
    private static final Logger log = LoggerFactory.getLogger(ToolFileChooser.class);
    public static final String SELECTED_FILE = "SelectedFile";
    public static final String KEY_TITLE = "title";
    public static final String KEY_PATH_ID = "PathId";
    public static final String KEY_DESC = "description";
    private static final int MAX_PATH_LENGTH = 200;
    private static final int RECURSION_DEPTH = 5;
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ToolFileChooser.class);
    private static final String NETWORKPATH = "network shortcuts";
    private static final long SIZE_20GB = 0x500000000L;
    private static final String LINESEPARATOR = System.lineSeparator();

    private ToolFileChooser() {
    }

    public static IsmFileChooser createIsmFileChooser(String title, String defaultPath, String description, String[] exts, boolean multiSel) {
        IsmFileChooser fileChooser = new IsmFileChooser(title);
        fileChooser.setMultiSelectionEnabled(multiSel);
        fileChooser.setAcceptAllFileFilterUsed(false);
        ToolFileChooser.sleep50ms();
        if (!StringUtils.isNULLStr(defaultPath)) {
            File defaultPackagePath = new File(defaultPath);
            fileChooser.setCurrentDirectory(defaultPackagePath.isDirectory() ? defaultPackagePath : defaultPackagePath.getParentFile());
        } else {
            fileChooser.setCurrentDirectory(null);
        }
        fileChooser.addFileFilter(exts, description);
        return fileChooser;
    }

    public static IsmFileChooser createIsmFileChooser(String title, String defaultPath, LinkedHashMap<String, String[]> fileFilterTypeMap, boolean multiSel) {
        String[] keys = new String[fileFilterTypeMap.size()];
        fileFilterTypeMap.keySet().toArray(keys);
        String description = keys[0];
        String[] exts = fileFilterTypeMap.get(description);
        IsmFileChooser chooser = ToolFileChooser.createIsmFileChooser(title, defaultPath, description, exts, multiSel);
        for (int i = 1; i < keys.length; ++i) {
            description = keys[i];
            exts = fileFilterTypeMap.get(description);
            chooser.addFileFilter(exts, description);
        }
        return chooser;
    }

    public static File selectFile(Window parent, String title, String[] exts, String defaultPathId, String description, int fileSelectionMode) {
        HashMap<String, String> extParams = new HashMap<String, String>();
        extParams.put(KEY_TITLE, title);
        extParams.put(KEY_PATH_ID, defaultPathId);
        extParams.put(KEY_DESC, description);
        return ToolFileChooser.selectFile(parent, exts, fileSelectionMode, false, extParams);
    }

    public static File selectSaveFile(Window parent, String[] exts, int fileSelectionMode, String title, String filterDesc, String selectedFile) {
        HashMap<String, String> extPrams = new HashMap<String, String>();
        boolean isOpenDialog = false;
        String uniqueId = ToolFileChooser.getSaveUniqueId();
        extPrams.put(KEY_PATH_ID, uniqueId);
        extPrams.put(KEY_DESC, filterDesc);
        extPrams.put(KEY_TITLE, title);
        extPrams.put(SELECTED_FILE, selectedFile);
        return ToolFileChooser.selectFile(parent, exts, fileSelectionMode, isOpenDialog, extPrams);
    }

    public static File selectFile(Window parent, String[] exts, int fileSelectionMode, String title, String filterDesc) {
        HashMap<String, String> extPrams = new HashMap<String, String>();
        boolean isOpenDialog = true;
        String uniqueId = ToolFileChooser.getSaveUniqueId();
        extPrams.put(KEY_PATH_ID, uniqueId);
        extPrams.put(KEY_DESC, filterDesc);
        extPrams.put(KEY_TITLE, title);
        return ToolFileChooser.selectFile(parent, exts, fileSelectionMode, isOpenDialog, extPrams);
    }

    public static List<File> selectFileMultiSel(Window parent, String[] exts, int fileSelectionMode, String title, String filterDesc) {
        HashMap<String, String> extPrams = new HashMap<String, String>();
        boolean isOpenDialog = true;
        String uniqueId = ToolFileChooser.getSaveUniqueId();
        extPrams.put(KEY_PATH_ID, uniqueId);
        extPrams.put(KEY_DESC, filterDesc);
        extPrams.put(KEY_TITLE, title);
        return ToolFileChooser.getSelectFiles(parent, exts, fileSelectionMode, isOpenDialog, extPrams, true, null);
    }

    private static String getSaveUniqueId() {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        String classname = elements[3].getClassName();
        String methodName = elements[3].getMethodName();
        int lineNum = elements[3].getLineNumber();
        return classname + methodName + lineNum;
    }

    public static File selectFile(Window parent, String[] exts, int fileSelectionMode, Map<String, String> extPrams) {
        extPrams = extPrams == null ? new HashMap<String, String>() : extPrams;
        boolean isOpenDialog = !"true".equals(extPrams.get("isOpenDialog"));
        return ToolFileChooser.selectFile(parent, exts, fileSelectionMode, isOpenDialog, extPrams);
    }

    public static File selectFile(Window parent, String[] exts, int fileSelectionMode, boolean isOpenDialog, Map<String, String> extPrams) {
        List<File> files = ToolFileChooser.getSelectFiles(parent, exts, fileSelectionMode, isOpenDialog, extPrams, false);
        if (files != null && !files.isEmpty()) {
            File file = files.get(0);
            return file;
        }
        return null;
    }

    public static String getFileSize(File file) {
        String size = "";
        if (file.exists() && file.isFile()) {
            long fileSize = file.length();
            DecimalFormat df = new DecimalFormat("#.00");
            DecimalFormatSymbols symbols = new DecimalFormatSymbols();
            symbols.setDecimalSeparator('.');
            df.setDecimalFormatSymbols(symbols);
            size = df.format((double)fileSize / 1048576.0);
        } else {
            size = "0";
        }
        return size;
    }

    public static List<File> selectFiles(Window parent, String title, String[] exts, String defaultPathId, String description, int fileSelectionMode) {
        HashMap<String, String> extParams = new HashMap<String, String>();
        extParams.put(KEY_TITLE, title);
        extParams.put(KEY_PATH_ID, defaultPathId);
        extParams.put(KEY_DESC, description);
        return ToolFileChooser.getSelectFiles(parent, exts, fileSelectionMode, true, extParams, true);
    }

    public static List<File> selectFiles(Window parent, String title, String defaultPathId, int fileSelectionMode, boolean multiSel, LinkedHashMap<String, String[]> multFileFilterTypeMap) {
        HashMap<String, String> extParams = new HashMap<String, String>();
        extParams.put(KEY_TITLE, title);
        extParams.put(KEY_PATH_ID, defaultPathId);
        boolean isOpenDialog = true;
        String[] exts = new String[]{""};
        return ToolFileChooser.getSelectFiles(parent, exts, fileSelectionMode, isOpenDialog, extParams, multiSel, multFileFilterTypeMap);
    }

    private static List<File> getSelectFiles(Window parent, String[] exts, int fileSelectionMode, boolean isOpenDialog, Map<String, String> extPrams, boolean multiSel) {
        return ToolFileChooser.getSelectFiles(parent, exts, fileSelectionMode, isOpenDialog, extPrams, multiSel, null);
    }

    private static List<File> getSelectFiles(Window parent, String[] exts, int fileSelectionMode, boolean isOpenDialog, Map<String, String> extPrams, boolean multiSel, LinkedHashMap<String, String[]> fileTypeMap) {
        Object defaultPathObj = HibernateContainer.getInstance().get(extPrams.get(KEY_PATH_ID));
        String defaultPath = defaultPathObj != null ? defaultPathObj.toString() : null;
        log.info(String.format("read filechooser default path: %s --> %s", defaultPathObj, defaultPath));
        IsmFileChooser chooser = ToolFileChooser.getIsmFileChooser(exts, extPrams, multiSel, fileTypeMap, defaultPath);
        ToolFileChooser.setIsmFileChooser(fileSelectionMode, extPrams, chooser);
        FileChooserWrapper.wrapper((JFileChooser)chooser);
        FileChooserWrapper.setDefaultFileName("", (JFileChooser)chooser, true);
        chooser.setFileSelectionMode(fileSelectionMode);
        chooser.setMultiSelectionEnabled(multiSel);
        ArrayList<File> filelist = new ArrayList<File>();
        StringBuilder failFileNames = new StringBuilder();
        StringBuilder exceededFileNames = new StringBuilder();
        int showResult = ToolFileChooser.getShowResult(parent, isOpenDialog, chooser);
        if (showResult == 0) {
            File[] aFiles = null;
            aFiles = multiSel ? chooser.getSelectedFiles() : new File[]{chooser.getSelectedFile()};
            if (aFiles.length == 0) {
                return Collections.emptyList();
            }
            String path = "";
            for (File aFile : aFiles) {
                path = ToolFileChooser.getAFilePath(parent, aFile);
                if (path == null) {
                    return Collections.emptyList();
                }
                if (ToolFileChooser.checkPath(parent, fileSelectionMode, path)) {
                    return Collections.emptyList();
                }
                ToolFileChooser.printLog(extPrams, path);
                HibernateContainer.getInstance().put(extPrams.get(KEY_PATH_ID), (Object)path);
                boolean isMismatchRes = ToolFileChooser.isMismatch(failFileNames, path, aFile);
                boolean isExceedSizeRes = ToolFileChooser.isExceedSize(exceededFileNames, aFile);
                if (isMismatchRes || isExceedSizeRes) continue;
                filelist.add(aFile);
            }
        }
        ToolFileChooser.showTips(parent, failFileNames, exceededFileNames);
        if (!filelist.isEmpty()) {
            return filelist;
        }
        return Collections.emptyList();
    }

    public static List<File> selectDictionary(DictionaryPara dictionaryPara) throws IOException {
        HashMap<String, String> extParams = new HashMap<String, String>();
        extParams.put(KEY_TITLE, dictionaryPara.getTitle());
        extParams.put(KEY_PATH_ID, dictionaryPara.getDefaultPathId());
        extParams.put(KEY_DESC, dictionaryPara.getDescription());
        return ToolFileChooser.getSelectDictionaryFiles(dictionaryPara.getParent(), dictionaryPara.getExts(), dictionaryPara.getFileSelectionMode(), extParams);
    }

    static List<File> getSelectDictionaryFiles(Window parent, String[] exts, int fileSelectionMode, Map<String, String> extPrams) throws IOException {
        DictionaryPara dictionaryPara;
        String defaultPath = ToolFileChooser.getSelectDictionaryPath(extPrams);
        IsmFileChooser chooser = ToolFileChooser.getDictionaryChooser(exts, extPrams, defaultPath, fileSelectionMode);
        List<File> filteredFiles = ToolFileChooser.getFilteredFiles(parent, chooser, extPrams, exts, dictionaryPara = new DictionaryPara());
        if (!CollectionUtil.isEmpty(filteredFiles)) {
            ToolFileChooser.showTips(parent, dictionaryPara.getFailFileNames(), dictionaryPara.getExceededFileNames());
        }
        return filteredFiles;
    }

    static String getSelectDictionaryPath(Map<String, String> extPrams) {
        Object defaultPathObj = HibernateContainer.getInstance().get(extPrams.get(KEY_PATH_ID));
        String defaultPath = defaultPathObj != null ? defaultPathObj.toString() : null;
        log.info(String.format("read filechooser default path: %s --> %s", extPrams.get(KEY_PATH_ID), defaultPath));
        return defaultPath;
    }

    private static IsmFileChooser getDictionaryChooser(String[] exts, Map<String, String> extPrams, String defaultPath, int fileSelectionMode) {
        boolean isMultiSel = false;
        LinkedHashMap<String, String[]> fileTypeMap = null;
        IsmFileChooser chooser = ToolFileChooser.getIsmFileChooser(exts, extPrams, isMultiSel, fileTypeMap, defaultPath);
        ToolFileChooser.setIsmFileChooser(fileSelectionMode, extPrams, chooser);
        FileChooserWrapper.wrapper((JFileChooser)chooser);
        FileChooserWrapper.setDefaultFileName("", (JFileChooser)chooser, true);
        chooser.setFileSelectionMode(fileSelectionMode);
        chooser.setMultiSelectionEnabled(isMultiSel);
        return chooser;
    }

    static List<File> getFilteredFiles(Window parent, IsmFileChooser chooser, Map<String, String> extPrams, String[] exts, DictionaryPara dictionaryPara) throws IOException {
        StringBuilder failFileNames = new StringBuilder();
        StringBuilder exceededFileNames = new StringBuilder();
        ArrayList<File> filelist = new ArrayList<File>();
        boolean isOpenDialog = true;
        if (ToolFileChooser.getShowResult(parent, isOpenDialog, chooser) == 0) {
            String selectedDirectory = FilePathUtils.getCanonicalPath((File)chooser.getSelectedFile());
            HibernateContainer.getInstance().put(extPrams.get(KEY_PATH_ID), (Object)selectedDirectory);
            dictionaryPara.setParent(parent);
            dictionaryPara.setExtslist(Arrays.asList(exts));
            dictionaryPara.setExtParams(extPrams);
            dictionaryPara.setFailFileNames(failFileNames);
            dictionaryPara.setExceededFileNames(exceededFileNames);
            dictionaryPara.setDirectoryPath(selectedDirectory);
            dictionaryPara.setFilelist(filelist);
            dictionaryPara.setDepth(0);
            ToolFileChooser.scanDictionary(dictionaryPara);
            if (dictionaryPara.isPathLengthError()) {
                DialogUtils.showInfoDialog((Window)parent, (String)ResourceUtil.getStringWithParams("dictionarychooser.prompt.path.max.length.diy", dictionaryPara.getErrorPathStr(), 200));
                return Collections.emptyList();
            }
            if (CollectionUtil.isEmpty(filelist)) {
                DialogUtils.showInfoDialog((Window)parent, (String)ResourceUtil.getString("file.upload.scan.dictionary.get.empty.list"));
            }
        }
        return filelist;
    }

    static List<File> scanDictionary(DictionaryPara dictionaryPara) throws IOException {
        int depth = dictionaryPara.getDepth();
        if (depth >= 5) {
            return Collections.emptyList();
        }
        File directory = new File(dictionaryPara.getDirectoryPath());
        if (!directory.exists() || !directory.isDirectory()) {
            return Collections.emptyList();
        }
        Window parent = dictionaryPara.getParent();
        if (ToolFileChooser.isNotFilteredDictionary(parent, directory.getCanonicalPath(), dictionaryPara)) {
            return Collections.emptyList();
        }
        File[] files = directory.listFiles();
        if (files == null || files.length == 0) {
            return Collections.emptyList();
        }
        String path = "";
        List<String> extslist = dictionaryPara.getExtslist();
        StringBuilder failFileNames = dictionaryPara.getFailFileNames();
        StringBuilder exceededFileNames = dictionaryPara.getExceededFileNames();
        List<File> filelist = dictionaryPara.getFilelist();
        for (File file : files) {
            path = ToolFileChooser.getAFilePath(parent, file);
            if (path == null) {
                return Collections.emptyList();
            }
            if (file.isDirectory()) {
                dictionaryPara.setDirectoryPath(file.getCanonicalPath());
                dictionaryPara.setDepth(depth + 1);
                ToolFileChooser.scanDictionary(dictionaryPara);
                continue;
            }
            if (!ToolFileChooser.isSatisfactoryExt(file, extslist)) continue;
            boolean isMismatchRes = ToolFileChooser.isMismatch(failFileNames, path, file);
            boolean isExceedSizeRes = ToolFileChooser.isExceedSize(exceededFileNames, file);
            if (isMismatchRes || isExceedSizeRes) continue;
            filelist.add(file);
        }
        return filelist;
    }

    static boolean isNotFilteredDictionary(Window parent, String path, DictionaryPara dictionaryPara) {
        if (ToolFileChooser.isNwPath(parent, path) || ToolFileChooser.isNlPath(parent, path)) {
            return true;
        }
        if (path.length() > 200) {
            dictionaryPara.setPathLengthError(true);
            dictionaryPara.setErrorPathStr(path);
            return true;
        }
        return false;
    }

    static boolean isSatisfactoryExt(File file, List<String> extslist) {
        if (!file.exists()) {
            return false;
        }
        String fileName = file.getName();
        int dotIndex = fileName.lastIndexOf(".");
        if (dotIndex <= 0) {
            return false;
        }
        return extslist.contains(fileName.substring(dotIndex));
    }

    static boolean isMismatch(StringBuilder failFileNames, String path, File aFile) {
        if (aFile.isDirectory()) {
            return false;
        }
        if (FileTypeUtils.getInstance().matchFileType(path)) {
            return false;
        }
        failFileNames.append(aFile.getName() + LINESEPARATOR);
        return true;
    }

    static boolean isExceedSize(StringBuilder exceededFileNames, File file) {
        if (file.length() > 0x500000000L) {
            exceededFileNames.append(file.getName() + LINESEPARATOR);
            return true;
        }
        return false;
    }

    private static void printLog(Map<String, String> extPrams, String path) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("Save filechooser default path:%s ---> %s", extPrams.get(KEY_PATH_ID), path));
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("Selected file is >> %s][Success]", path));
        }
    }

    private static String getAFilePath(Window parent, File aFile) {
        String path;
        try {
            path = aFile.getCanonicalPath();
        }
        catch (IOException e) {
            DialogUtils.showInfoDialog((Window)parent, (String)ResourceUtil.getString("filechooser.prompt.file.path.format.error"));
            return null;
        }
        return path;
    }

    private static boolean checkPath(Window parent, int fileSelectionMode, String path) {
        if (ToolFileChooser.isNwPath(parent, path)) {
            return true;
        }
        if (ToolFileChooser.isNlPath(parent, path)) {
            return true;
        }
        if (path.length() > 200 && ApplicationContext.getInstance().isFileChooserPathLenLimit()) {
            DialogUtils.showInfoDialog((Window)parent, (String)ResourceUtil.getStringWithParams("filechooser.prompt.file.max.length.diy", 200));
            return true;
        }
        if (!ToolFileChooser.checkSelectFile(path, fileSelectionMode)) {
            DialogUtils.showInfoDialog((Window)parent, (String)ResourceUtil.getString("filechooser.prompt.file.error.path"));
            return true;
        }
        return false;
    }

    public static void checkDirThrowError(int maxLength, String path) throws ToolException {
        ToolFileChooser.isNwPathThrowError(path);
        ToolFileChooser.isNlPathThrowError(path);
        if (path.length() > maxLength) {
            throw new ToolException(ResourceUtil.getStringWithParams("filechooser.prompt.file.max.length.diy", maxLength));
        }
        File checkFile = new File(path + File.separator + "CheckFile");
        boolean canWrite = checkFile.mkdirs();
        if (!canWrite) {
            throw new ToolException(ResourceUtil.getString("filechooser.prompt.file.error.path"));
        }
        checkFile.delete();
    }

    private static int getShowResult(Window parent, boolean isOpenDialog, IsmFileChooser chooser) {
        int showResult = 0;
        showResult = isOpenDialog ? chooser.showOpenDialog((Component)parent) : chooser.showSaveDialog((Component)parent);
        return showResult;
    }

    private static void setIsmFileChooser(int fileSelectionMode, Map<String, String> extPrams, IsmFileChooser chooser) {
        String selectedFile = extPrams.get(SELECTED_FILE);
        chooser.setSelectedFile(selectedFile != null ? new File(selectedFile) : null);
        chooser.setName("toolfilechooser.obase");
        chooser.addDirChangeListener(fileSelectionMode);
    }

    private static IsmFileChooser getIsmFileChooser(String[] exts, Map<String, String> extPrams, boolean multiSel, LinkedHashMap<String, String[]> fileTypeMap, String defaultPath) {
        IsmFileChooser chooser = null;
        chooser = fileTypeMap != null && !fileTypeMap.isEmpty() ? ToolFileChooser.createIsmFileChooser(extPrams.get(KEY_TITLE), defaultPath, fileTypeMap, multiSel) : ToolFileChooser.createIsmFileChooser(extPrams.get(KEY_TITLE), defaultPath, extPrams.get(KEY_DESC), exts, multiSel);
        return chooser;
    }

    static void showTips(Window parent, StringBuilder failFileNames, StringBuilder exceededFileNames) {
        String[] rowHeaders = new String[]{ResourceUtil.getStringWithParams("filechooser.prompt.file.path.table.filename", new Object[0]), ResourceUtil.getStringWithParams("filechooser.prompt.file.path.table.error.reason", new Object[0])};
        ArrayList<ArrayList<Object>> rowList = new ArrayList<ArrayList<Object>>();
        String errorMsg = ResourceUtil.getStringWithParams("filechooser.prompt.file.path.add.fail", new Object[0]);
        String sizeError = ResourceUtil.getStringWithParams("filechooser.prompt.file.path.size.error", new Object[0]);
        String extInconsistentError = ResourceUtil.getStringWithParams("filechooser.prompt.file.path.extension.inconsistent.error", new Object[0]);
        ToolFileChooser.addRowList(rowList, failFileNames, extInconsistentError);
        ToolFileChooser.addRowList(rowList, exceededFileNames, sizeError);
        if (rowList.isEmpty()) {
            return;
        }
        DialogUtils.showMultiErrorDialog((Window)parent, (String)errorMsg, (String[])rowHeaders, rowList);
    }

    private static void addRowList(List<ArrayList<Object>> rowList, StringBuilder fileNames, String errorReason) {
        if (fileNames == null || fileNames.length() == 0) {
            return;
        }
        Arrays.stream(fileNames.toString().split(LINESEPARATOR)).forEach(fileName -> rowList.add(new ArrayList<String>(Arrays.asList(fileName, errorReason))));
    }

    private static boolean checkSelectFile(String path, int fileSelectionMode) {
        if (fileSelectionMode != 1) {
            return true;
        }
        File checkFile = new File(path + File.separator + "CheckFile");
        boolean checkSucc = checkFile.mkdirs();
        if (!checkSucc) {
            return false;
        }
        if (!checkFile.delete()) {
            LOGGER.error("Delete checkFile failed.");
        }
        return true;
    }

    public static String getSaveFilePath(String title, String suffix, Window pDialog, String defaultFileName, String defaultPathId) {
        return ToolFileChooser.getSaveFilePath(title, suffix, pDialog, defaultFileName, defaultPathId, true);
    }

    public static String getSaveFilePath(String title, String suffix, Window pDialog, String defaultFileName, String defaultPathId, int fileSelectionMode) {
        return ToolFileChooser.getSaveFilePath(title, suffix, pDialog, defaultFileName, defaultPathId, true, fileSelectionMode);
    }

    private static String getSaveFilePath(String title, String suffix, Window pDialog, String defaultFileName, String defaultPathId, boolean fileNameEditable, int fileSelectionMode) {
        String endFix = "." + suffix;
        IsmFileChooser ismFileChooser = ToolFileChooser.createIsmFileChooser(title, suffix, defaultFileName, defaultPathId, fileNameEditable, endFix);
        ismFileChooser.setFileSelectionMode(fileSelectionMode);
        return ToolFileChooser.getSaveFilePath(pDialog, defaultPathId, endFix, ismFileChooser);
    }

    public static String getSaveFilePath(String title, String suffix, Window pDialog, String defaultFileName, String defaultPathId, boolean fileNameEditable) {
        String endFix = "." + suffix;
        IsmFileChooser ismFileChooser = ToolFileChooser.createIsmFileChooser(title, suffix, defaultFileName, defaultPathId, fileNameEditable, endFix);
        return ToolFileChooser.getSaveFilePath(pDialog, defaultPathId, endFix, ismFileChooser);
    }

    private static String getSaveFilePath(Window pDialog, String defaultPathId, String endFix, IsmFileChooser ismFileChooser) {
        String filePath;
        int resultCode = ismFileChooser.showSaveDialog((Component)pDialog);
        if (resultCode != 0) {
            return null;
        }
        File selectedFile = ismFileChooser.getSelectedFile();
        if (selectedFile == null) {
            return null;
        }
        try {
            filePath = selectedFile.getCanonicalPath();
        }
        catch (IOException e) {
            filePath = "";
        }
        if (ToolFileChooser.isNwPath(pDialog, filePath)) {
            return null;
        }
        if (ToolFileChooser.isNlPath(pDialog, filePath)) {
            return null;
        }
        if (filePath.endsWith(".")) {
            int index = filePath.lastIndexOf(".");
            filePath = filePath.substring(0, index);
        }
        if (!filePath.endsWith(endFix)) {
            filePath = filePath + endFix;
        }
        if (filePath.length() > 128) {
            DialogUtils.showInfoDialog((Window)pDialog, (String)ResourceUtil.getString("filechooser.prompt.file.max.length"));
            return null;
        }
        if (SecurityUtils.isCmdInject(filePath)) {
            DialogUtils.showInfoDialog((Window)pDialog, (String)ResourceUtil.getString("filechooser.prompt.file.path.cmd.inject"));
            return null;
        }
        HibernateContainer.getInstance().put(defaultPathId, (Object)filePath);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("[Save file path >> %s][Success]", FileUtils.filterLogIfComputerName((String)filePath)));
        }
        return filePath;
    }

    private static IsmFileChooser createIsmFileChooser(String title, String suffix, String defaultFileName, String defaultPathId, boolean fileNameEditable, String endFix) {
        Object defaultPathObj = HibernateContainer.getInstance().get(defaultPathId);
        String defaultPath = defaultPathObj != null ? defaultPathObj.toString() : null;
        IsmFileChooser ismFileChooser = new IsmFileChooser(title);
        ismFileChooser.setAcceptAllFileFilterUsed(false);
        ismFileChooser.addFileFilter(new String[]{suffix}, endFix);
        ToolFileChooser.sleep50ms();
        if (!StringUtils.isNULLStr(defaultPath)) {
            File defaultPackagePath = new File(defaultPath);
            ismFileChooser.setCurrentDirectory(defaultPackagePath.isDirectory() ? defaultPackagePath : defaultPackagePath.getParentFile());
        } else {
            ismFileChooser.setCurrentDirectory(null);
        }
        FileChooserWrapper.wrapper((JFileChooser)ismFileChooser);
        FileChooserWrapper.setDefaultFileName(defaultFileName, (JFileChooser)ismFileChooser, fileNameEditable);
        return ismFileChooser;
    }

    private static boolean isNwPath(Window parent, String path) {
        if (path.startsWith("\\")) {
            DialogUtils.showInfoDialog((Window)parent, (String)ResourceUtil.getString("filechooser.prompt.file.network.path"));
            return true;
        }
        if (path.contains("  ")) {
            DialogUtils.showInfoDialog((Window)parent, (String)ResourceUtil.getString("filechooser.prompt.file.path.black"));
            return true;
        }
        return false;
    }

    private static void isNwPathThrowError(String path) throws ToolException {
        if (path.startsWith("\\")) {
            throw new ToolException(ResourceUtil.getString("filechooser.prompt.file.network.path"));
        }
        if (path.contains("  ")) {
            throw new ToolException(ResourceUtil.getString("filechooser.prompt.file.path.black"));
        }
    }

    private static boolean isNlPath(Window parent, String path) {
        if (path.toLowerCase(Locale.ENGLISH).contains(NETWORKPATH)) {
            DialogUtils.showInfoDialog((Window)parent, (String)ResourceUtil.getString("filechooser.prompt.file.network.path"));
            return true;
        }
        return false;
    }

    private static void isNlPathThrowError(String path) throws ToolException {
        if (path.toLowerCase(Locale.ENGLISH).contains(NETWORKPATH)) {
            throw new ToolException(ResourceUtil.getString("filechooser.prompt.file.network.path"));
        }
    }

    private static void sleep50ms() {
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            LOGGER.error("Interrupt for sleep 50 ms error on: {}", e);
            Thread.currentThread().interrupt();
        }
    }
}

