/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.mails;

import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class MailInfo {
    public static final String MAIL_ADDRESS_SPLIT = ";";
    public static final int DEFAULT_MAIL_PORT = 25;
    private List<String> receiveAddresses = new ArrayList<String>();
    private String sendAddress = "";
    private String smtpIP = "";
    private int smtpPort = 25;
    private boolean needValidate = false;
    private User user = new User("", "");
    private boolean enableMaintainMail = false;
    private String maintainMailAddress = "";
    private boolean tls = true;
    private boolean securedTls = false;
    private boolean enableCert = false;
    private boolean nonRadio = false;
    private String certParh = "";

    public boolean isValid() {
        return this.isSendValid();
    }

    public final boolean isSendValid() {
        if (!StringUtils.isEmailAddress(this.sendAddress)) {
            return false;
        }
        if (StringUtils.isNULLStr(this.smtpIP)) {
            return false;
        }
        if (this.needValidate) {
            if (null == this.user) {
                return false;
            }
            return !StringUtils.hasNULLStr(this.user.getUserName(), this.user.getPassword());
        }
        return true;
    }

    public boolean isMaintainMailValid() {
        return this.enableMaintainMail && !StringUtils.isNULLStr(this.maintainMailAddress);
    }

    public MailInfo copy() {
        MailInfo mailInfo = new MailInfo();
        ArrayList<String> addresses = new ArrayList<String>();
        for (String receiveAddress : this.receiveAddresses) {
            addresses.add(receiveAddress);
        }
        mailInfo.setReceiveAddresses(addresses);
        mailInfo.setSendAddress(this.sendAddress);
        mailInfo.setSmtpIP(this.smtpIP);
        mailInfo.setSmtpPort(this.smtpPort);
        mailInfo.setNeedValidate(this.needValidate);
        mailInfo.setCertParh(this.certParh);
        mailInfo.setEnableCert(this.enableCert);
        String pwd = this.user.getPassword();
        User mailInfoUser = new User(this.user.getUserName(), pwd);
        mailInfo.setUser(mailInfoUser);
        mailInfo.setEnableMaintainMail(this.isEnableMaintainMail());
        mailInfo.setMaintainMailAddress(this.maintainMailAddress);
        mailInfo.setTls(this.tls);
        mailInfo.setSecuredTls(this.securedTls);
        mailInfo.setNonRadio(this.nonRadio);
        return mailInfo;
    }

    public boolean isMaintainMailChange(boolean eMaintainMail, String mMailAddress) {
        return this.enableMaintainMail != eMaintainMail || !this.maintainMailAddress.equals(mMailAddress);
    }

    public String getReceiveAddressesString() {
        StringBuffer result = new StringBuffer();
        if (this.receiveAddresses == null || this.receiveAddresses.isEmpty()) {
            return "";
        }
        for (String address : this.receiveAddresses) {
            result.append(address).append(MAIL_ADDRESS_SPLIT);
        }
        return result.substring(0, result.length() - 1);
    }

    public String getAllReceiveAddressesString() {
        String result = this.getReceiveAddressesString();
        if (this.isMaintainMailValid() && !this.receiveAddresses.contains(this.maintainMailAddress)) {
            result = result + MAIL_ADDRESS_SPLIT + this.maintainMailAddress;
        }
        return result;
    }

    public void setReceiveAddresses(List<String> receiveAddresses) {
        this.receiveAddresses = receiveAddresses;
    }

    public List<String> getReceiveAddresses() {
        return this.receiveAddresses;
    }

    public List<String> getAllReceiveAddresses() {
        ArrayList<String> allReceiveAddresses = new ArrayList<String>(this.receiveAddresses);
        if (this.isMaintainMailValid() && !allReceiveAddresses.contains(this.maintainMailAddress)) {
            allReceiveAddresses.add(this.maintainMailAddress);
        }
        return allReceiveAddresses;
    }

    public void setSendAddress(String sendAddress) {
        this.sendAddress = sendAddress;
    }

    public String getSendAddress() {
        return this.sendAddress;
    }

    public void setSmtpIP(String smtpIP) {
        this.smtpIP = smtpIP;
    }

    public String getSmtpIP() {
        return this.smtpIP;
    }

    public void setSmtpPort(int smtpPort) {
        this.smtpPort = smtpPort;
    }

    public int getSmtpPort() {
        return this.smtpPort;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public User getUser() {
        return this.user;
    }

    public void setNeedValidate(boolean needValidate) {
        this.needValidate = needValidate;
    }

    public boolean isNeedValidate() {
        return this.needValidate;
    }

    public void setEnableMaintainMail(boolean heartMailEnable) {
        this.enableMaintainMail = heartMailEnable;
    }

    public boolean isEnableMaintainMail() {
        return this.enableMaintainMail;
    }

    public void setMaintainMailAddress(String maintainMailAddress) {
        this.maintainMailAddress = maintainMailAddress;
    }

    public String getMaintainMailAddress() {
        return this.maintainMailAddress;
    }

    public boolean isNonRadio() {
        return this.nonRadio;
    }

    public void setNonRadio(boolean nonRadio) {
        this.nonRadio = nonRadio;
    }

    public boolean isTls() {
        return this.tls;
    }

    public void setTls(boolean tls) {
        this.tls = tls;
    }

    public String getCertParh() {
        return this.certParh;
    }

    public void setCertParh(String certParh) {
        this.certParh = certParh;
    }

    public boolean isEnableCert() {
        return this.enableCert;
    }

    public void setEnableCert(boolean enableCert) {
        this.enableCert = enableCert;
    }

    public boolean isSecuredTls() {
        return this.securedTls;
    }

    public void setSecuredTls(boolean securedTls) {
        this.securedTls = securedTls;
    }
}

