/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.net.dhcp;

import com.huawei.ism.tool.obase.listener.IDhcpObserver;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.net.dhcp.DHCPAddressPool;
import com.huawei.ism.tool.obase.net.dhcp.IIpAddressDispatchStratage;
import com.huawei.ism.tool.obase.net.dhcp.utils.ToolNetUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;

public class DefaultIpaddressStratage
implements IIpAddressDispatchStratage {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(DefaultIpaddressStratage.class);
    private String currentIp;
    private DHCPAddressPool discoveredIpaddressPool = new DHCPAddressPool();
    private String endIp;
    private DHCPAddressPool offeredIpaddressPool = new DHCPAddressPool();
    private String startIpaddr;
    private String subNetmask;
    private List<IDhcpObserver> observerList = new ArrayList<IDhcpObserver>();
    private boolean ipOver = false;
    private ReadWriteLock lock = new ReentrantReadWriteLock();

    public DefaultIpaddressStratage(String startIp, String endIp, String netmask) {
        this.startIpaddr = startIp;
        this.endIp = endIp;
        this.subNetmask = netmask;
    }

    @Override
    public void addDiscoveredIp(String mac, String ipAddress) {
        this.discoveredIpaddressPool.addIpaddr(mac, ipAddress);
    }

    @Override
    public void addOfferedIp(String mac, String ipAddress) {
        if (!this.offeredIpaddressPool.isMacContain(mac)) {
            for (IDhcpObserver obser : this.observerList) {
                obser.fireQueryDeviceMac(ipAddress);
            }
        }
        this.offeredIpaddressPool.addIpaddr(mac, ipAddress);
    }

    private String calcNextIp(String curIp) {
        try {
            int ipInt = ToolNetUtil.inetAddress2Int(InetAddress.getByName(curIp.replaceAll("/", "")));
            curIp = ToolNetUtil.int2InetAddress(ipInt + 1).toString();
            if (!this.isIpValid(curIp)) {
                return null;
            }
        }
        catch (UnknownHostException e) {
            LOGGER.error("Ip address format error.", e);
        }
        curIp = curIp.replaceAll("/", "");
        return curIp;
    }

    @Override
    public String getDisocoververIp(String mac) {
        if (this.discoveredIpaddressPool.isMacContain(mac)) {
            return this.discoveredIpaddressPool.getIpaddrByMac(mac);
        }
        return null;
    }

    @Override
    public Map<String, String> getIpaddressPool() {
        return this.offeredIpaddressPool.getIpaddressMap();
    }

    @Override
    public String getNetMask() {
        return this.subNetmask;
    }

    @Override
    public String getNextIp(String mac) {
        if (this.offeredIpaddressPool.isMacContain(mac)) {
            this.currentIp = this.offeredIpaddressPool.getIpaddrByMac(mac);
            return this.currentIp;
        }
        if (this.isIpAddressOver()) {
            return null;
        }
        if (null == this.currentIp) {
            this.currentIp = this.startIpaddr;
        } else {
            if (this.graterThanEndIP(this.currentIp)) {
                this.lock.writeLock().lock();
                try {
                    this.ipOver = true;
                }
                finally {
                    this.lock.writeLock().unlock();
                }
                return null;
            }
            this.currentIp = this.calcNextIp(this.currentIp);
        }
        return this.currentIp;
    }

    private boolean graterThanEndIP(String ip) {
        try {
            int intIP = ToolNetUtil.inetAddress2Int(InetAddress.getByName(ip.replaceAll("/", "")));
            int intEndIP = ToolNetUtil.inetAddress2Int(InetAddress.getByName(this.endIp));
            if (intIP + 1 >= intEndIP) {
                return true;
            }
        }
        catch (UnknownHostException e) {
            LOGGER.error("", e);
        }
        return false;
    }

    @Override
    public String getOfferIp(String mac) {
        if (this.offeredIpaddressPool.isMacContain(mac)) {
            return this.offeredIpaddressPool.getIpaddrByMac(mac);
        }
        return null;
    }

    @Override
    public boolean isIpAddressOver() {
        this.lock.readLock().lock();
        try {
            boolean bl = this.ipOver;
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean isIpValid(String ipAddress) {
        try {
            int startIP = ToolNetUtil.inetAddress2Int(InetAddress.getByName(this.startIpaddr));
            int endIP = ToolNetUtil.inetAddress2Int(InetAddress.getByName(this.endIp));
            int currenetIp = ToolNetUtil.inetAddress2Int(InetAddress.getByName(ipAddress.replaceAll("/", "")));
            return currenetIp < endIP && currenetIp > startIP;
        }
        catch (UnknownHostException e) {
            LOGGER.error("Ip address unformat", e);
            return true;
        }
    }

    @Override
    public void clearAddressPool() {
        this.offeredIpaddressPool.clearIpaddressPool();
        this.discoveredIpaddressPool.clearIpaddressPool();
    }

    @Override
    public void addDhcpListener(IDhcpObserver observer) {
        this.observerList.add(observer);
    }

    @Override
    public boolean isClientMacInDiscoverPool(String clientMac) {
        return this.discoveredIpaddressPool.isMacContain(clientMac);
    }
}

