/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.net.dhcp.utils;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.net.dhcp.utils.DHCPConstants;
import com.huawei.ism.tool.obase.net.dhcp.utils.DHCPPacket;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class DHCPOption
implements Serializable {
    static final Map<Byte, OptionFormat> DHO_FORMATS = new LinkedHashMap<Byte, OptionFormat>();
    private static final Object[] OPTION_FORMATS = new Object[]{(byte)1, OptionFormat.INET, (byte)2, OptionFormat.INT, (byte)3, OptionFormat.INETS, (byte)4, OptionFormat.INETS, (byte)5, OptionFormat.INETS, (byte)6, OptionFormat.INETS, (byte)7, OptionFormat.INETS, (byte)8, OptionFormat.INETS, (byte)9, OptionFormat.INETS, (byte)10, OptionFormat.INETS, (byte)11, OptionFormat.INETS, (byte)12, OptionFormat.STRING, (byte)13, OptionFormat.SHORT, (byte)14, OptionFormat.STRING, (byte)15, OptionFormat.STRING, (byte)16, OptionFormat.INET, (byte)17, OptionFormat.STRING, (byte)18, OptionFormat.STRING, (byte)19, OptionFormat.BYTE, (byte)20, OptionFormat.BYTE, (byte)21, OptionFormat.INETS, (byte)22, OptionFormat.SHORT, (byte)23, OptionFormat.BYTE, (byte)24, OptionFormat.INT, (byte)25, OptionFormat.SHORTS, (byte)26, OptionFormat.SHORT, (byte)27, OptionFormat.BYTE, (byte)28, OptionFormat.INET, (byte)29, OptionFormat.BYTE, (byte)30, OptionFormat.BYTE, (byte)31, OptionFormat.BYTE, (byte)32, OptionFormat.INET, (byte)33, OptionFormat.INETS, (byte)34, OptionFormat.BYTE, (byte)35, OptionFormat.INT, (byte)36, OptionFormat.BYTE, (byte)37, OptionFormat.BYTE, (byte)38, OptionFormat.INT, (byte)39, OptionFormat.BYTE, (byte)41, OptionFormat.INETS, (byte)42, OptionFormat.INETS, (byte)44, OptionFormat.INETS, (byte)45, OptionFormat.INETS, (byte)46, OptionFormat.BYTE, (byte)47, OptionFormat.STRING, (byte)48, OptionFormat.INETS, (byte)49, OptionFormat.INETS, (byte)50, OptionFormat.INET, (byte)51, OptionFormat.INT, (byte)52, OptionFormat.BYTE, (byte)53, OptionFormat.BYTE, (byte)54, OptionFormat.INET, (byte)55, OptionFormat.BYTES, (byte)56, OptionFormat.STRING, (byte)57, OptionFormat.SHORT, (byte)58, OptionFormat.INT, (byte)59, OptionFormat.INT, (byte)60, OptionFormat.STRING, (byte)62, OptionFormat.STRING, (byte)64, OptionFormat.STRING, (byte)65, OptionFormat.STRING, (byte)66, OptionFormat.STRING, (byte)67, OptionFormat.STRING, (byte)68, OptionFormat.INETS, (byte)69, OptionFormat.INETS, (byte)70, OptionFormat.INETS, (byte)71, OptionFormat.INETS, (byte)72, OptionFormat.INETS, (byte)73, OptionFormat.INETS, (byte)74, OptionFormat.INETS, (byte)75, OptionFormat.INETS, (byte)76, OptionFormat.INETS, (byte)85, OptionFormat.INETS, (byte)86, OptionFormat.STRING, (byte)87, OptionFormat.STRING, (byte)91, OptionFormat.INT, (byte)92, OptionFormat.INETS, (byte)98, OptionFormat.STRING, (byte)116, OptionFormat.BYTE, (byte)117, OptionFormat.SHORTS, (byte)118, OptionFormat.INET, (byte)119, OptionFormat.STRING};
    private static final Logger DHCPOPTIONLOGGER = ToolLoggerFactory.getLogger(DHCPOption.class);
    private static final long serialVersionUID = 2L;
    private final byte code;
    private final boolean mirror;
    private final byte[] value;

    public DHCPOption(byte code, byte[] value) {
        this(code, value, false);
    }

    public DHCPOption(byte code, byte[] value, boolean mirror) {
        if (code == 0) {
            throw new IllegalArgumentException("code=0 is not allowed (reserved for padding");
        }
        if (code == -1) {
            throw new IllegalArgumentException("code=-1 is not allowed (reserved for End Of Options)");
        }
        this.code = code;
        this.value = value != null ? (byte[])value.clone() : null;
        this.mirror = mirror;
    }

    public static final Map<Byte, String> agentOptionsToMap(byte[] buf) {
        int size;
        if (buf == null) {
            return null;
        }
        LinkedHashMap<Byte, String> map = new LinkedHashMap<Byte, String>();
        for (int i = 0; i < buf.length && buf.length - i >= 2; i += size) {
            int instock;
            Byte key = buf[i++];
            if ((size = DHCPOption.unsignedByte(buf[i++])) > (instock = buf.length - i)) {
                size = instock;
            }
            map.put(key, DHCPPacket.bytesToString(buf, i, size));
        }
        return map;
    }

    public static String agentOptionsToString(byte[] buf) {
        if (buf == null) {
            return null;
        }
        Map<Byte, String> map = DHCPOption.agentOptionsToMap(buf);
        StringBuffer s = new StringBuffer();
        for (Map.Entry<Byte, String> entry : map.entrySet()) {
            s.append('{').append(DHCPOption.unsignedByte(entry.getKey())).append("}\"");
            s.append(entry.getValue()).append('\"');
            s.append(',');
        }
        if (s.length() > 0) {
            s.setLength(s.length() - 1);
        }
        return s.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] agentOptionToRaw(Map<Byte, String> map) {
        if (map == null) {
            return new byte[0];
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream(64);
        DataOutputStream out = new DataOutputStream(buf);
        try {
            for (Map.Entry<Byte, String> entry : map.entrySet()) {
                byte[] bufTemp = DHCPPacket.stringToBytes(entry.getValue());
                int size = bufTemp.length;
                if (size > 255) {
                    throw new IllegalArgumentException("Value size is greater then 255 bytes");
                }
                out.writeByte(entry.getKey().byteValue());
                out.writeByte(size);
                out.write(bufTemp, 0, size);
            }
            Object object = buf.toByteArray();
            return object;
        }
        catch (IOException e) {
            DHCPOPTIONLOGGER.error("Unexpected IOException", e);
            byte[] byArray = buf.toByteArray();
            return byArray;
        }
        finally {
            StreamUtils.closeResource(null, (Closeable)out);
            StreamUtils.closeResource(null, (Closeable)buf);
        }
    }

    public static byte[] byte2Bytes(byte val) {
        byte[] raw = new byte[]{val};
        return raw;
    }

    public static Class getOptionFormat(byte code) {
        OptionFormat format = DHO_FORMATS.get(code);
        if (format == null) {
            return null;
        }
        switch (format) {
            case INET: {
                return InetAddress.class;
            }
            case INETS: {
                return InetAddress[].class;
            }
            case INT: {
                return Integer.TYPE;
            }
            case SHORT: {
                return Short.TYPE;
            }
            case SHORTS: {
                return short[].class;
            }
            case BYTE: {
                return Byte.TYPE;
            }
            case BYTES: {
                return byte[].class;
            }
            case STRING: {
                return String.class;
            }
        }
        return null;
    }

    public static byte[] inetAddress2Bytes(InetAddress val) {
        if (val == null) {
            return new byte[0];
        }
        if (!(val instanceof Inet4Address)) {
            throw new IllegalArgumentException("Adress must be of subclass Inet4Address");
        }
        return val.getAddress();
    }

    public static byte[] inetAddresses2Bytes(InetAddress[] val) {
        if (val == null) {
            return new byte[0];
        }
        byte[] buf = new byte[val.length * 4];
        for (int i = 0; i < val.length; ++i) {
            InetAddress addr = val[i];
            if (!(addr instanceof Inet4Address)) {
                throw new IllegalArgumentException("Adress must be of subclass Inet4Address");
            }
            System.arraycopy(addr.getAddress(), 0, buf, i * 4, 4);
        }
        return buf;
    }

    public static byte[] int2Bytes(int val) {
        byte[] raw = new byte[]{(byte)((val & 0xFF000000) >>> 24), (byte)((val & 0xFF0000) >>> 16), (byte)((val & 0xFF00) >>> 8), (byte)(val & 0xFF)};
        return raw;
    }

    public static final boolean isOptionAsByte(byte code) {
        return OptionFormat.BYTE.equals((Object)DHO_FORMATS.get(code));
    }

    public static final boolean isOptionAsBytes(byte code) {
        return OptionFormat.BYTES.equals((Object)DHO_FORMATS.get(code));
    }

    public static final boolean isOptionAsInetAddr(byte code) {
        return OptionFormat.INET.equals((Object)DHO_FORMATS.get(code));
    }

    public static final boolean isOptionAsInetAddrs(byte code) {
        return OptionFormat.INETS.equals((Object)DHO_FORMATS.get(code));
    }

    public static final boolean isOptionAsInt(byte code) {
        return OptionFormat.INT.equals((Object)DHO_FORMATS.get(code));
    }

    public static final boolean isOptionAsShort(byte code) {
        return OptionFormat.SHORT.equals((Object)DHO_FORMATS.get(code));
    }

    public static final boolean isOptionAsShorts(byte code) {
        return OptionFormat.SHORTS.equals((Object)DHO_FORMATS.get(code));
    }

    public static final boolean isOptionAsString(byte code) {
        return OptionFormat.STRING.equals((Object)DHO_FORMATS.get(code));
    }

    public static DHCPOption newOptionAsByte(byte code, byte val) {
        if (!DHCPOption.isOptionAsByte(code)) {
            throw new IllegalArgumentException("DHCP option type (" + code + ") is not byte");
        }
        return new DHCPOption(code, DHCPOption.byte2Bytes(val));
    }

    public static DHCPOption newOptionAsInetAddress(byte code, InetAddress val) {
        if (!DHCPOption.isOptionAsInetAddr(code) && !DHCPOption.isOptionAsInetAddrs(code)) {
            throw new IllegalArgumentException("DHCP option type (" + code + ") is not InetAddress");
        }
        return new DHCPOption(code, DHCPOption.inetAddress2Bytes(val));
    }

    public static DHCPOption newOptionAsInetAddresses(byte code, InetAddress[] val) {
        if (!DHCPOption.isOptionAsInetAddrs(code)) {
            throw new IllegalArgumentException("DHCP option type (" + code + ") is not InetAddresses");
        }
        return new DHCPOption(code, DHCPOption.inetAddresses2Bytes(val));
    }

    public static DHCPOption newOptionAsInt(byte code, int val) {
        if (!DHCPOption.isOptionAsInt(code)) {
            throw new IllegalArgumentException("DHCP option type (" + code + ") is not int");
        }
        return new DHCPOption(code, DHCPOption.int2Bytes(val));
    }

    public static DHCPOption newOptionAsShort(byte code, short val) {
        if (!DHCPOption.isOptionAsShort(code)) {
            throw new IllegalArgumentException("DHCP option type (" + code + ") is not short");
        }
        return new DHCPOption(code, DHCPOption.short2Bytes(val));
    }

    public static DHCPOption newOptionAsShorts(byte code, short[] arr) {
        if (!DHCPOption.isOptionAsShorts(code)) {
            throw new IllegalArgumentException("DHCP option type (" + code + ") is not shorts");
        }
        byte[] buf = null;
        if (arr != null) {
            buf = new byte[arr.length * 2];
            for (int i = 0; i < arr.length; ++i) {
                short val = arr[i];
                buf[i * 2] = (byte)((val & 0xFF00) >>> 8);
                buf[i * 2 + 1] = (byte)(val & 0xFF);
            }
        }
        return new DHCPOption(code, buf);
    }

    public static DHCPOption newOptionAsString(byte code, String val) {
        if (!DHCPOption.isOptionAsString(code)) {
            throw new IllegalArgumentException("DHCP option type (" + code + ") is not string");
        }
        return new DHCPOption(code, DHCPPacket.stringToBytes(val));
    }

    public static DHCPOption parseNewOption(byte code, Class format, String value) {
        DHCPOption.checkParse(code, format, value);
        if (InetAddress.class.equals((Object)format)) {
            try {
                return DHCPOption.newOptionAsInetAddress(code, InetAddress.getByName(value));
            }
            catch (UnknownHostException e) {
                DHCPOPTIONLOGGER.error("Invalid address:" + value, e);
                return null;
            }
        }
        if (InetAddress[].class.equals((Object)format)) {
            String[] listVal = value.split(" ");
            InetAddress[] listInet = new InetAddress[listVal.length];
            try {
                for (int i = 0; i < listVal.length; ++i) {
                    listInet[i] = InetAddress.getByName(listVal[i]);
                }
            }
            catch (UnknownHostException e) {
                DHCPOPTIONLOGGER.error("Invalid address", e);
                return null;
            }
            return DHCPOption.newOptionAsInetAddresses(code, listInet);
        }
        return null;
    }

    private static DHCPOption checkParse(byte code, Class format, String value) {
        DHCPOption.checkNullCondition(format, value);
        if (Short.TYPE.equals(format) || short[].class.equals((Object)format) || Integer.TYPE.equals(format)) {
            return DHCPOption.checkShortIntStyle(code, format, value);
        }
        return DHCPOption.checkStringByteStyle(code, format, value);
    }

    private static DHCPOption checkShortIntStyle(byte code, Class format, String value) {
        if (Short.TYPE.equals(format)) {
            return DHCPOption.newOptionAsShort(code, (short)Integer.parseInt(value));
        }
        if (short[].class.equals((Object)format)) {
            return DHCPOption.fixShotArrayCondition(code, value);
        }
        if (Integer.TYPE.equals(format)) {
            return DHCPOption.newOptionAsInt(code, Integer.parseInt(value));
        }
        return null;
    }

    private static DHCPOption checkStringByteStyle(byte code, Class format, String value) {
        if (String.class.equals((Object)format)) {
            return DHCPOption.newOptionAsString(code, value);
        }
        if (Byte.TYPE.equals(format)) {
            return DHCPOption.newOptionAsByte(code, (byte)Integer.parseInt(value));
        }
        if (byte[].class.equals((Object)format)) {
            return DHCPOption.fixByteArrayCondition(code, value);
        }
        return null;
    }

    private static DHCPOption fixByteArrayCondition(byte code, String value) {
        value = value.replace(".", " ");
        String[] listVal = value.split(" ");
        byte[] listBytes = new byte[listVal.length];
        for (int i = 0; i < listVal.length; ++i) {
            listBytes[i] = (byte)Integer.parseInt(listVal[i]);
        }
        return new DHCPOption(code, listBytes);
    }

    private static DHCPOption fixShotArrayCondition(byte code, String value) {
        String[] listVal = value.split(" ");
        short[] listShort = new short[listVal.length];
        for (int i = 0; i < listVal.length; ++i) {
            listShort[i] = (short)Integer.parseInt(listVal[i]);
        }
        return DHCPOption.newOptionAsShorts(code, listShort);
    }

    private static void checkNullCondition(Class format, String value) {
        if (format == null || value == null) {
            throw new NullPointerException();
        }
    }

    public static byte[] short2Bytes(short val) {
        byte[] raw = new byte[]{(byte)((val & 0xFF00) >>> 8), (byte)(val & 0xFF)};
        return raw;
    }

    public static Class<?> string2Class(String className) {
        if ("InetAddress".equals(className)) {
            return InetAddress.class;
        }
        if ("inet".equals(className)) {
            return InetAddress.class;
        }
        if ("InetAddress[]".equals(className)) {
            return InetAddress[].class;
        }
        if ("inets".equals(className)) {
            return InetAddress[].class;
        }
        if ("int".equals(className)) {
            return Integer.TYPE;
        }
        if ("short".equals(className)) {
            return Short.TYPE;
        }
        return DHCPOption.anotherCls(className);
    }

    private static Class<?> anotherCls(String className) {
        if ("short[]".equals(className)) {
            return short[].class;
        }
        if ("shorts".equals(className)) {
            return short[].class;
        }
        if ("byte".equals(className)) {
            return Byte.TYPE;
        }
        if ("byte[]".equals(className)) {
            return byte[].class;
        }
        if ("bytes".equals(className)) {
            return byte[].class;
        }
        if ("String".equalsIgnoreCase(className)) {
            return String.class;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] stringListToUserClass(List<String> list) {
        if (list == null) {
            return new byte[0];
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream(32);
        DataOutputStream out = new DataOutputStream(buf);
        try {
            for (String s : list) {
                byte[] bytes = DHCPPacket.stringToBytes(s);
                int size = bytes.length;
                if (size > 255) {
                    size = 255;
                }
                out.writeByte(size);
                out.write(bytes, 0, size);
            }
            Object object = buf.toByteArray();
            return object;
        }
        catch (IOException e) {
            DHCPOPTIONLOGGER.error("Unexpected IOException");
            byte[] byArray = buf.toByteArray();
            return byArray;
        }
        finally {
            StreamUtils.closeResource(null, (Closeable)out);
            StreamUtils.closeResource(null, (Closeable)buf);
        }
    }

    private static int unsignedByte(byte byteValue) {
        return byteValue & 0xFF;
    }

    public static List<String> userClassToList(byte[] buf) {
        int size;
        if (buf == null) {
            return null;
        }
        LinkedList<String> list = new LinkedList<String>();
        for (int i = 0; i < buf.length; i += size) {
            int instock;
            if ((size = DHCPOption.unsignedByte(buf[i++])) > (instock = buf.length - i)) {
                size = instock;
            }
            list.add(DHCPPacket.bytesToString(buf, i, size));
        }
        return list;
    }

    public static String userClassToString(byte[] buf) {
        if (buf == null) {
            return null;
        }
        List<String> list = DHCPOption.userClassToList(buf);
        Iterator<String> it = list.iterator();
        StringBuffer s = new StringBuffer();
        while (it.hasNext()) {
            s.append('\"').append(it.next()).append('\"');
            if (!it.hasNext()) continue;
            s.append(',');
        }
        return s.toString();
    }

    public void append(StringBuilder buffer) {
        if (DHCPConstants.DHO_NAMES.containsKey(this.code)) {
            buffer.append(DHCPConstants.DHO_NAMES.get(this.code));
        }
        buffer.append('(').append(DHCPOption.unsignedByte(this.code)).append(")=");
        if (this.mirror) {
            buffer.append("<mirror>");
        }
        if (this.value == null) {
            buffer.append("<null>");
        } else if (this.code == 53) {
            Byte cmd = this.getValueAsByte();
            if (DHCPConstants.DHCP_CODES.containsKey(cmd)) {
                buffer.append(DHCPConstants.DHCP_CODES.get(cmd));
            } else {
                buffer.append(cmd);
            }
        } else if (this.code == 77) {
            buffer.append(DHCPOption.userClassToString(this.value));
        } else if (this.code == 82) {
            buffer.append(DHCPOption.agentOptionsToString(this.value));
        } else if (DHO_FORMATS.containsKey(this.code)) {
            this.formatOutput(buffer);
        } else {
            buffer.append("0x");
            DHCPPacket.appendHex(buffer, this.value);
        }
    }

    private void formatOutput(StringBuilder buffer) {
        if (null == buffer) {
            return;
        }
        try {
            switch (DHO_FORMATS.get(this.code)) {
                case INET: {
                    DHCPPacket.appendHostAddress(buffer, this.getValueAsInetAddr());
                    break;
                }
                case INETS: {
                    InetAddress[] addrs = this.getValueAsInetAddrs();
                    this.buildAddTxt(buffer, addrs);
                    break;
                }
                case INT: {
                    buffer.append(this.getValueAsInt());
                    break;
                }
                case SHORT: {
                    buffer.append(this.getValueAsShort());
                    break;
                }
                case SHORTS: {
                    this.appendShortStr(buffer);
                    break;
                }
                case BYTE: {
                    buffer.append(this.getValueAsByte());
                    break;
                }
                case STRING: {
                    buffer.append('\"').append(this.getValueAsString()).append('\"');
                    break;
                }
                case BYTES: {
                    this.appendVals(buffer);
                    break;
                }
                default: {
                    buffer.append("0x");
                    DHCPPacket.appendHex(buffer, this.value);
                    break;
                }
            }
        }
        catch (IllegalArgumentException e) {
            buffer.append("0x");
            DHCPPacket.appendHex(buffer, this.value);
        }
    }

    private void appendVals(StringBuilder buffer) {
        if (this.value != null) {
            for (byte aValue : this.value) {
                buffer.append(DHCPOption.unsignedByte(aValue)).append(' ');
            }
        }
    }

    private void appendShortStr(StringBuilder buffer) {
        for (short aShort : this.getValueAsShorts()) {
            buffer.append(aShort).append(' ');
        }
    }

    private void buildAddTxt(StringBuilder buffer, InetAddress[] addrs) {
        if (null == addrs) {
            return;
        }
        for (InetAddress addr : addrs) {
            if (null == addr) continue;
            DHCPPacket.appendHostAddress(buffer, addr);
            buffer.append(' ');
        }
    }

    public DHCPOption applyOption(DHCPPacket request) {
        if (request == null) {
            throw new NullPointerException("request is null");
        }
        if (this.mirror) {
            DHCPOption res = request.getOption(this.getCode());
            return res != null ? res : this;
        }
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DHCPOption)) {
            return false;
        }
        DHCPOption opt = (DHCPOption)obj;
        return opt.code == this.code && opt.mirror == this.mirror && Arrays.equals(opt.value, this.value);
    }

    public byte getCode() {
        return this.code;
    }

    public byte[] getValue() {
        return this.value == null ? null : (byte[])this.value.clone();
    }

    public byte getValueAsByte() {
        if (!DHCPOption.isOptionAsByte(this.code)) {
            throw new IllegalArgumentException("DHCP option type (" + this.code + ") is not byte");
        }
        if (this.value == null) {
            throw new IllegalStateException("value is null");
        }
        if (this.value.length != 1) {
            throw new IllegalArgumentException("option " + this.code + " is wrong size:" + this.value.length + " should be 1");
        }
        return this.value[0];
    }

    public byte[] getValueAsBytes() {
        if (!DHCPOption.isOptionAsBytes(this.code)) {
            throw new IllegalArgumentException("DHCP option type (" + this.code + ") is not bytes");
        }
        if (this.value == null) {
            throw new IllegalStateException("value is null");
        }
        return this.getValue();
    }

    public InetAddress getValueAsInetAddr() {
        if (!DHCPOption.isOptionAsInetAddr(this.code)) {
            throw new IllegalArgumentException("DHCP option type (" + this.code + ") is not InetAddr");
        }
        if (this.value == null) {
            throw new IllegalStateException("value is null");
        }
        if (this.value.length != 4) {
            throw new IllegalArgumentException("option " + this.code + " is wrong size:" + this.value.length + " should be 4");
        }
        try {
            return InetAddress.getByAddress(this.value);
        }
        catch (UnknownHostException e) {
            DHCPOPTIONLOGGER.error("Unexpected UnknownHostException", e);
            return null;
        }
    }

    public InetAddress[] getValueAsInetAddrs() {
        if (!DHCPOption.isOptionAsInetAddrs(this.code)) {
            throw new IllegalArgumentException("DHCP option type (" + this.code + ") is not InetAddr[]");
        }
        if (this.value == null) {
            throw new IllegalStateException("value is null");
        }
        if (this.value.length % 4 != 0) {
            throw new IllegalArgumentException("option " + this.code + " is wrong size:" + this.value.length + " should be 4*X");
        }
        return new InetAddress[0];
    }

    public int getValueAsInt() {
        if (!DHCPOption.isOptionAsInt(this.code)) {
            throw new IllegalArgumentException("DHCP option type (" + this.code + ") is not int");
        }
        if (this.value == null) {
            throw new IllegalStateException("value is null");
        }
        if (this.value.length != 4) {
            throw new IllegalArgumentException("option " + this.code + " is wrong size:" + this.value.length + " should be 4");
        }
        int part1 = (this.value[0] & 0xFF) << 24;
        int part2 = (this.value[1] & 0xFF) << 16;
        int part3 = (this.value[2] & 0xFF) << 8;
        int part4 = this.value[3] & 0xFF;
        return part1 | part2 | part3 | part4;
    }

    public Integer getValueAsNum() {
        if (this.value == null) {
            return null;
        }
        if (this.value.length == 1) {
            return this.value[0] & 0xFF;
        }
        if (this.value.length == 2) {
            return (this.value[0] & 0xFF) << 8 | this.value[1] & 0xFF;
        }
        if (this.value.length == 4) {
            int part1 = (this.value[0] & 0xFF) << 24;
            int part2 = (this.value[1] & 0xFF) << 16;
            int part3 = (this.value[2] & 0xFF) << 8;
            int part4 = this.value[3] & 0xFF;
            return part1 | part2 | part3 | part4;
        }
        return null;
    }

    public short getValueAsShort() {
        if (!DHCPOption.isOptionAsShort(this.code)) {
            throw new IllegalArgumentException("DHCP option type (" + this.code + ") is not short");
        }
        if (this.value == null) {
            throw new IllegalStateException("value is null");
        }
        if (this.value.length != 2) {
            throw new IllegalArgumentException("option " + this.code + " is wrong size:" + this.value.length + " should be 2");
        }
        return (short)((this.value[0] & 0xFF) << 8 | this.value[1] & 0xFF);
    }

    public short[] getValueAsShorts() {
        if (!DHCPOption.isOptionAsShorts(this.code)) {
            throw new IllegalArgumentException("DHCP option type (" + this.code + ") is not short[]");
        }
        if (this.value == null) {
            throw new IllegalStateException("value is null");
        }
        if (this.value.length % 2 != 0) {
            throw new IllegalArgumentException("option " + this.code + " is wrong size:" + this.value.length + " should be 2*X");
        }
        short[] shorts = new short[this.value.length / 2];
        int i = 0;
        for (int a = 0; a < this.value.length; a += 2) {
            shorts[i] = (short)((this.value[a] & 0xFF) << 8 | this.value[a + 1] & 0xFF);
            ++i;
        }
        return shorts;
    }

    public String getValueAsString() {
        if (!DHCPOption.isOptionAsString(this.code)) {
            throw new IllegalArgumentException("DHCP option type (" + this.code + ") is not String");
        }
        if (this.value == null) {
            throw new IllegalStateException("value is null");
        }
        return DHCPPacket.bytesToString(this.value);
    }

    protected byte[] getValueFast() {
        return this.value;
    }

    public int hashCode() {
        return this.code ^ Arrays.hashCode(this.value) ^ (this.mirror ? Integer.MIN_VALUE : 0);
    }

    public boolean isMirror() {
        return this.mirror;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        this.append(s);
        return s.toString();
    }

    static {
        for (int i = 0; i < OPTION_FORMATS.length / 2; ++i) {
            DHO_FORMATS.put((Byte)OPTION_FORMATS[i * 2], (OptionFormat)((Object)OPTION_FORMATS[i * 2 + 1]));
        }
    }

    static enum OptionFormat {
        BYTE,
        BYTES,
        INET,
        INETS,
        INT,
        SHORT,
        SHORTS,
        STRING;

    }
}

