/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.ui.component;

import com.huawei.ism.tool.obase.ui.base.ToolAction;
import com.huawei.ism.tool.obase.utils.ToolUCD;
import com.huawei.ism.ui.swing.plaf.IsmBorders;
import com.huawei.ism.util.UCD;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class RolloverButton
extends JButton {
    private static final long serialVersionUID = 1L;
    private static final String UICLASSID = "RolloverButtonUI";
    private Border arrawVisibleBorder = IsmBorders.getRolloverButtonButton((boolean)true);
    private Border arrawInvisibleBorder = IsmBorders.getRolloverButtonButton((boolean)false);
    private boolean isArrowVisiable;

    public RolloverButton(String groupName, Icon icon, final List<ToolAction> actions) {
        super(groupName, icon);
        this.setToolTipText(groupName);
        this.setFocusable(false);
        this.updatePreferSize();
        this.isArrowVisiable = true;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent me) {
                JPopupMenu popmenu = new JPopupMenu();
                for (ToolAction action : actions) {
                    popmenu.add(action);
                    popmenu.setEnabled(action.isAvailable());
                }
                popmenu.show(me.getComponent(), 0, RolloverButton.this.getY() + RolloverButton.this.getHeight() - 3);
            }
        });
        ToolUCD.setStandardFont(this);
    }

    public RolloverButton(String groupName, List<ToolAction> actions) {
        this(groupName, null, actions);
    }

    public RolloverButton(ToolAction action) {
        super(action);
        ToolUCD.setStandardFont(this);
        this.setFocusable(false);
        this.setEnabled(action.isAvailable());
        this.setToolTips(action);
        this.updatePreferSize();
    }

    public RolloverButton(String text) {
        super(text);
        ToolUCD.setStandardFont(this);
        this.setFocusable(false);
        this.setEnabled(true);
        this.setToolTipText(text);
        this.updatePreferSize();
    }

    public RolloverButton(ToolAction toolAction, boolean isArrowVisiable) {
        super(toolAction);
        ToolUCD.setStandardFont(this);
        this.isArrowVisiable = isArrowVisiable;
        this.setFocusable(false);
        this.setEnabled(toolAction.isAvailable());
        this.setToolTips(toolAction);
        this.updatePreferSize();
    }

    private void setToolTips(ToolAction toolAction) {
        if (null != toolAction.getValue("Name")) {
            this.setToolTipText(toolAction.getValue("Name").toString());
        }
    }

    public void updateStatus() {
    }

    private void updatePreferSize() {
        Dimension dimen = UCD.computeButtonPreferredSize((AbstractButton)this);
        dimen.height = 25;
        this.setMinimumSize(dimen);
        this.setPreferredSize(dimen);
        this.setMaximumSize(dimen);
    }

    @Override
    public String getUIClassID() {
        return UICLASSID;
    }

    @Override
    public void paintComponent(Graphics grap) {
        if (this.isArrowVisiable) {
            Icon arrow = UIManager.getIcon("Table.descendingSortIcon");
            int xValue = this.getWidth() - arrow.getIconWidth() - 4;
            int yValue = (this.getHeight() - arrow.getIconHeight()) / 2;
            arrow.paintIcon(this, grap, xValue, yValue);
        }
        this.setBorder(this.isArrowVisiable ? this.arrawVisibleBorder : this.arrawInvisibleBorder);
        super.paintComponent(grap);
    }
}

