/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.ui.component.treetable;

import com.huawei.ism.tool.obase.ui.component.treetable.ITreeTableRow;
import java.util.ArrayList;
import java.util.List;

public class DefaultTreeTableRow<U, K>
implements ITreeTableRow<U, K> {
    private ITreeTableRow<U, K> parent;
    private Object[] rowValues;
    private List<ITreeTableRow<U, K>> subRows = new ArrayList<ITreeTableRow<U, K>>();
    private U userObject;
    private K identifier;

    public DefaultTreeTableRow(int columnCount, U userObject, K identifier) {
        this.rowValues = new Object[columnCount];
        this.userObject = userObject;
        this.identifier = identifier;
    }

    public int hashCode() {
        if (null == this.identifier) {
            return super.hashCode();
        }
        return this.identifier.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DefaultTreeTableRow)) {
            return false;
        }
        DefaultTreeTableRow that = (DefaultTreeTableRow)obj;
        K thisID = this.getIdentifier();
        K thatID = that.getIdentifier();
        if (null == thisID || null == thatID) {
            return super.equals(obj);
        }
        return thisID.equals(thatID);
    }

    @Override
    public ITreeTableRow<U, K> getParentRow() {
        return this.parent;
    }

    public void setParentRow(ITreeTableRow<U, K> row) {
        this.parent = row;
    }

    @Override
    public void clearSubRows() {
        for (ITreeTableRow<U, K> subProp : this.subRows) {
            if (!(subProp instanceof DefaultTreeTableRow)) continue;
            ((DefaultTreeTableRow)subProp).setParentRow(null);
        }
        this.subRows.clear();
    }

    public void setValueAt(int index, Object value) {
        this.setValue(index, value);
    }

    @Override
    public void setValue(int idx, Object value) {
        Object parentValue;
        if (this.parent != null && (parentValue = this.parent.getValue(idx)) != null) {
            this.parent.setValue(idx, parentValue);
        }
        this.rowValues[idx] = value;
    }

    @Override
    public Object getValue(int idx) {
        return this.rowValues[idx];
    }

    public Object getValueAt(int index) {
        return this.getValue(index);
    }

    @Override
    public int getColumnCount() {
        return 0;
    }

    @Override
    public K getIdentifier() {
        return this.identifier;
    }

    @Override
    public U getUserObject() {
        return this.userObject;
    }

    @Override
    public List<ITreeTableRow<U, K>> getSubRowList() {
        return this.subRows;
    }

    @Override
    public void addSubRow(ITreeTableRow<U, K> subRow) {
        this.subRows.add(subRow);
        if (subRow instanceof DefaultTreeTableRow) {
            ((DefaultTreeTableRow)subRow).setParentRow(this);
        }
    }
}

