/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.ui.component.wizard;

import com.huawei.ism.tool.obase.constant.UiConstants;
import com.huawei.ism.tool.obase.ui.component.wizard.WizardConstants;
import com.huawei.ism.tool.obase.ui.component.wizard.WizardStepItem;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPanelUI;

public class WizardStepItemUI
extends BasicPanelUI {
    private static final Color LINE_COLOR = new Color(4144962);
    private static final int LINE_UNDER_TEXT = 4;
    private static final WizardStepItemUI INSTANCE = new WizardStepItemUI();

    public static ComponentUI createUI(JComponent x) {
        return INSTANCE;
    }

    @Override
    public void paint(Graphics graphics, JComponent jc) {
        if (!(jc instanceof WizardStepItem)) {
            return;
        }
        WizardStepItem wStepItem = (WizardStepItem)jc;
        boolean isCurrent = wStepItem.isCurrent();
        if (null != wStepItem.getDescriptionTextArea()) {
            wStepItem.getDescriptionTextArea().setVisible(isCurrent);
            wStepItem.getDescriptionTextArea().setForeground(isCurrent ? WizardConstants.WIZARD_CURRENT_STEP_DESCRIPTION_FONT_COLOR : WizardConstants.WIZARD_STEP_FONT_WHITE_COLOR);
        }
        if (isCurrent) {
            this.wizardStepItemSetValues(wStepItem);
            Color oldColor = graphics.getColor();
            Graphics2D g2d = (Graphics2D)graphics;
            g2d.setColor(new Color(4144962));
            g2d.fillRect(0, wStepItem.getHeight() - 2, wStepItem.getWidth(), wStepItem.getHeight());
            ImageIcon shadowIcon = ResourceUtil.getImage("wizard_current_step_shadow.png");
            int shadowHeight = shadowIcon.getIconHeight();
            g2d.drawImage(shadowIcon.getImage(), 0, wStepItem.getHeight() - shadowHeight, wStepItem.getWidth(), shadowHeight, wStepItem);
            float[] dash = new float[]{2.0f};
            BasicStroke basicStroke = new BasicStroke(1.0f, 0, 0, 1.0f, dash, 0.0f);
            g2d.setStroke(basicStroke);
            if (null != wStepItem.getDescriptionTextArea()) {
                this.drawWizardStepItemCurrentLine(wStepItem, g2d);
            }
            g2d.setColor(oldColor);
        } else {
            wStepItem.setBackground(WizardConstants.WIZARD_BACKGROUND);
            if (graphics instanceof Graphics2D) {
                this.drawWizardStepItemNotCurLine((Graphics2D)graphics, jc, wStepItem);
            }
        }
    }

    private void drawWizardStepItemNotCurLine(Graphics2D graphics, JComponent jc, WizardStepItem wStepItem) {
        Graphics2D g2d = graphics;
        ImageIcon icon = ResourceUtil.getImage("wizard_leftpane_bg.png");
        g2d.drawImage(icon.getImage(), 0, 0, jc.getWidth(), jc.getHeight(), jc);
        wStepItem.getStepPpanel().setBackground(WizardConstants.WIZARD_BACKGROUND);
        wStepItem.setLabelTextColor(WizardConstants.WIZARD_STEP_FONT_WHITE_COLOR);
        g2d.setColor(LINE_COLOR);
        g2d.drawLine(0, wStepItem.getHeight() - 1, wStepItem.getWidth(), wStepItem.getHeight() - 1);
    }

    private void drawWizardStepItemCurrentLine(WizardStepItem wStepItem, Graphics2D g2d) {
        g2d.setColor(UIManager.getColor("oem.color"));
        Point location = wStepItem.getStepPpanel().getLocation();
        int locationX = (int)location.getX();
        int locationY = (int)location.getY();
        Dimension size = wStepItem.getStepPpanel().getPreferredSize();
        int height = (int)size.getHeight();
        int lineWidth = (int)wStepItem.getPreferredSize().getWidth() - 10 - 15;
        g2d.drawLine(locationX, locationY + height + 4, locationX + lineWidth, locationY + height + 4);
    }

    private void wizardStepItemSetValues(WizardStepItem wStepItem) {
        wStepItem.setBackground(UiConstants.PANEL_COLOR);
        wStepItem.getStepPpanel().setBackground(UiConstants.PANEL_COLOR);
        wStepItem.setLabelTextColor(UIManager.getColor("oem.color"));
    }

    @Override
    public Dimension getPreferredSize(JComponent jc) {
        return this.calcSize(jc);
    }

    @Override
    public Dimension getMinimumSize(JComponent jc) {
        return new Dimension(214, 55);
    }

    private Dimension calcSize(JComponent jc) {
        Dimension defeaultSize = new Dimension(214, 55);
        if (!(jc instanceof WizardStepItem)) {
            return defeaultSize;
        }
        WizardStepItem stepItem = (WizardStepItem)jc;
        if (stepItem.isCurrent()) {
            double height = 55.0;
            JTextArea textArea = stepItem.getDescriptionTextArea();
            if (null != textArea) {
                height += textArea.getPreferredSize().getHeight();
            }
            defeaultSize.setSize(defeaultSize.getWidth(), height);
            return defeaultSize;
        }
        return defeaultSize;
    }
}

