/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.ui.dialogs;

import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.ImagePanel;
import com.huawei.ism.ui.swing.plaf.IsmFontFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class ProgressNumDialog
extends JDialog {
    private static final long serialVersionUID = 3669037530394882059L;
    private static final int PANEL_HIGHT = 20;
    private static final int MIDD_PANEL_HIGHT = 220;
    private static final int PANEL_WIDTH = 120;
    private static final int PROGRESS = 100;
    private JLabel progressLabel = this.createIconPanel("task_loading.gif");
    private String defaultText = "";

    public ProgressNumDialog(Window parent) {
        this(parent, ResourceUtil.getStringWithParams("progress.dialog.tips", 0));
    }

    public ProgressNumDialog(Window parent, String text) {
        super(parent);
        this.defaultText = text;
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.setName("ISMV1R2_framework_uiComponent_ProgressNumDialog");
        this.layoutUI();
        this.setUndecorated(true);
        this.pack();
        this.setLocationRelativeTo(parent);
        this.toFront();
        this.setFocusableWindowState(true);
    }

    private void layoutUI() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JComponent iconLabel = null;
        iconLabel = this.createArmorContentPane();
        iconLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
        jPanel.add((Component)iconLabel, "North");
        JButton jButton = new JButton("");
        jButton.setSize(0, 0);
        jButton.setPreferredSize(new Dimension(0, 0));
        jPanel.add((Component)jButton, "South");
        this.add(jPanel);
    }

    private JLabel createIconPanel(String imgName) {
        ImageIcon process = ResourceUtil.getImage(imgName);
        JLabel iconLabel = new JLabel();
        iconLabel.setIcon(process);
        process.setImageObserver(iconLabel);
        return iconLabel;
    }

    private JComponent createArmorContentPane() {
        ImagePanel leftImagePanel = new ImagePanel(ResourceUtil.getImage("loading-left.png"));
        ImagePanel rightImagePanel = new ImagePanel(ResourceUtil.getImage("loading-right.png"));
        ImagePanel middleImagePanel = new ImagePanel(ResourceUtil.getImage("loading-middle.png"), ImagePanel.ExtendOrient.HORIZONAL);
        leftImagePanel.setPreferredSize(new Dimension(20, 120));
        middleImagePanel.setPreferredSize(new Dimension(220, 120));
        rightImagePanel.setPreferredSize(new Dimension(20, 120));
        leftImagePanel.setOpaque(false);
        middleImagePanel.setOpaque(false);
        rightImagePanel.setOpaque(false);
        middleImagePanel.setLayout((LayoutManager)new BorderLayout());
        this.progressLabel.setFont(IsmFontFactory.getPlaint12Font());
        this.progressLabel.setForeground(Color.WHITE);
        this.progressLabel.setText(this.defaultText);
        Box lableHoriBox = Box.createHorizontalBox();
        lableHoriBox.add(Box.createHorizontalGlue());
        lableHoriBox.add(this.progressLabel);
        lableHoriBox.add(Box.createHorizontalGlue());
        middleImagePanel.add((Component)lableHoriBox);
        Box horiBox = Box.createHorizontalBox();
        horiBox.add((Component)leftImagePanel);
        horiBox.add((Component)middleImagePanel);
        horiBox.add((Component)rightImagePanel);
        return horiBox;
    }

    public void updateProgress(int progress) {
        if (progress < 0 || progress > 100) {
            progress = 100;
        }
        this.progressLabel.setText(ResourceUtil.getStringWithParams("progress.dialog.tips", progress));
        this.progressLabel.setToolTipText(ResourceUtil.getStringWithParams("progress.dialog.tips", progress));
    }

    @Override
    protected void dialogInit() {
        super.dialogInit();
        if (JDialog.isDefaultLookAndFeelDecorated()) {
            JRootPane rootPane = this.getRootPane();
            boolean supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations();
            if (supportsWindowDecorations) {
                this.setUndecorated(true);
                rootPane.setWindowDecorationStyle(0);
            }
        }
    }

    public synchronized void updateProgressText(String text) {
        this.progressLabel.setText(text);
        this.progressLabel.setToolTipText(text);
    }
}

