/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import com.huawei.ism.common.resourcemanager.ResourceManager;
import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.base.utils.ProperUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.base.utils.SystemEnvUtil;
import com.huawei.ism.tool.framework.platform.PlatformAppContext;
import com.huawei.ism.tool.framework.platform.context.ILanguageListener;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.service.timingtask.ITimingTaskService;
import com.huawei.ism.tool.framework.pubservice.exception.EncapsulatedRuntimeException;
import com.huawei.ism.tool.obase.constant.UiConstants;
import com.huawei.ism.tool.obase.entity.LanguageChangeLock;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.ui.component.IToolUIManager;
import com.huawei.ism.tool.obase.ui.surface.ArmorListCellRender;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.IniReader;
import com.huawei.ism.tool.obase.utils.OemUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.SystemConfigReader;
import com.huawei.ism.tool.obase.utils.ToolBorderUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.plaf.IsmPlafUtils;
import com.huawei.ism.util.ToolRunningCheckUtil;
import com.huawei.tool.framwork.util.func.LocalHostUtil;
import java.awt.Color;
import java.awt.Frame;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApplicationContext {
    private static final Logger log = LoggerFactory.getLogger(ApplicationContext.class);
    private static final String RELEASE_TIME_MARK = "20220610";
    private static final String TOOLKIT_APP_ZH_OR_EN_VERSION = "toolkit.app.zh_or_en.version";
    public static final Charset APP_CHARSET = Charset.forName("UTF-8");
    public static final String KEY_LOGFILEPATH = "TOOLLOGPATH";
    public static final String IS_CALLHOME_BACKEND = "IS_CALLHOME_BACKEND";
    public static final String RUNNING_FLAG = "runningFlag";
    public static final String BACK_FLAG = "backFlag";
    public static final Object INSPECT_RUNNING_LOCK = new Object();
    public static final int PID = ApplicationContext.getCurrentProcessId();
    private static final String PID_FILE_NAME = "pid";
    private static final ApplicationContext INSTANCE = new ApplicationContext();
    private boolean gloabIsBackInspectRunning = false;
    private static final String JRE_VERSION_REGEX = "^.*?([1-2]).([6-9]).([0-9])_([1-9]\\d+).*?$";
    private static final String TOOL_PACKAGE_DIR_NAME = "package";
    private SystemConfigReader systemConfigReader = new SystemConfigReader();
    private IToolUIManager toolUiManager = null;
    private final LanguageChangeLock languageChangeLock = new LanguageChangeLock();
    private boolean isTest = false;
    private boolean upgradeEvaluTool = false;
    private boolean sshForHost = false;

    private ApplicationContext() {
    }

    public static synchronized ApplicationContext getInstance() {
        return INSTANCE;
    }

    public String getWorkPath() {
        if ("yinglong".equalsIgnoreCase(System.getProperty("framework.scene"))) {
            return PlatformAppContext.getInstance().getRuntime().getWorkPath();
        }
        return SystemEnvUtil.getDefaultUserDir();
    }

    public String getPackagesPath() {
        return this.getWorkPath() + File.separator + "packages";
    }

    public String getConfigurationPath() {
        return this.getWorkPath() + File.separator + "configuration" + File.separator;
    }

    public String getConfigPath() {
        return this.getWorkPath() + File.separator + "config" + File.separator;
    }

    public String getHelpPath() {
        return "help";
    }

    public String getTmpPath() {
        String path = this.getRuntimePath() + File.separator + "tmp" + File.separator;
        FileUtils.createDir(path);
        return FilePathUtils.checkFile((String)path);
    }

    public String getLibPath() {
        return this.getWorkPath() + File.separator + "lib" + File.separator;
    }

    public String getUserDataPath() {
        String path = this.getRuntimePath() + File.separator + "data" + File.separator;
        FileUtils.createDir(path);
        return path;
    }

    public String getPidFilePath() {
        return this.getUserDataPath() + File.separator + PID_FILE_NAME;
    }

    public boolean isSupportForUpdateInstall() {
        return this.systemConfigReader.isSupportForUpdateInstall();
    }

    public boolean isWatchDogEnable() {
        return this.systemConfigReader.isWatchDogEnable();
    }

    public String getWatchDogPath() {
        return this.systemConfigReader.getWatchDogPath();
    }

    public String getRuntimePath() {
        String runtimePath = this.systemConfigReader.getRuntimePath();
        if (StringUtils.isNULLStr((String)runtimePath)) {
            return this.getWorkPath();
        }
        return runtimePath;
    }

    public String getRunnigLogPath() {
        String runtimePath = this.systemConfigReader.getRunningLogPath();
        if (StringUtils.isNULLStr((String)runtimePath)) {
            return this.getWorkPath();
        }
        return runtimePath;
    }

    public String getThirdPartyRuntimePath() {
        String runtimePath = this.systemConfigReader.getRuntimePath();
        if (StringUtils.isNULLStr((String)runtimePath)) {
            return new File(this.getWorkPath()).getParentFile().getParent();
        }
        return runtimePath;
    }

    public String getCfgPath() {
        return this.getWorkPath() + File.separator + "cfg" + File.separator;
    }

    public String getExtToolsPath() {
        return this.getWorkPath() + File.separator + "tools" + File.separator;
    }

    public String getDownloadPath() {
        return this.getWorkPath() + File.separator + "download" + File.separator;
    }

    public String getPluginPath() {
        return this.getWorkPath() + File.separator + "plugins";
    }

    public Locale getCurrentLanguage() {
        return LanguageManager.getInstance().getCurrentLanguage();
    }

    public String getVersion() {
        return com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().getVersion();
    }

    public String getReleaseDate() {
        return com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().getReleaseDate();
    }

    public String getReleaseTimeMark() {
        return com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().getReleaseTimeMark();
    }

    public String getSupportEncryptionAlgorithm() {
        return com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().getSupportEncryptionAlgorithm();
    }

    public String getToolPackagePath() {
        String path = this.getWorkPath() + File.separator + TOOL_PACKAGE_DIR_NAME + File.separator;
        FileUtils.createDir(path);
        return path;
    }

    public boolean isEnglishEnv() {
        String lan = ApplicationContext.getInstance().getCurrentLanguage().getLanguage();
        return lan.equals("en");
    }

    public String getCurrentJreVersion() {
        return System.getProperty("java.version");
    }

    public boolean currentJreIsSupport() {
        String currentJreVersion = this.getCurrentJreVersion();
        if (null == currentJreVersion) {
            throw new EncapsulatedRuntimeException("cannot get the System Property of [java.version].");
        }
        return currentJreVersion.matches(JRE_VERSION_REGEX);
    }

    public boolean isSpecificDeviceMode() {
        return com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().isSpecificDeviceMode();
    }

    public void setCurrentLanguage(Locale currentLanguage) {
        Locale.setDefault(currentLanguage);
        ResourceManager.setLocale((Locale)currentLanguage);
        JComponent.setDefaultLocale(currentLanguage);
        LanguageManager.getInstance().setCurrentLanguage(currentLanguage);
    }

    public void setDefaultLanguage() {
        Locale defaultLocale = LanguageManager.getInstance().getCurrentLanguage();
        if (!Locale.SIMPLIFIED_CHINESE.equals(defaultLocale)) {
            this.setCurrentLanguage(Locale.ENGLISH);
        }
    }

    public void init() {
        this.setDefaultLanguage();
        ApplicationContext appContext = ApplicationContext.getInstance();
        try {
            System.setProperty("VENDER", OemUtils.getVender());
            JFrame.setDefaultLookAndFeelDecorated(true);
            JDialog.setDefaultLookAndFeelDecorated(true);
            IsmPlafUtils.setLocale((Locale)Locale.getDefault());
            ResourceManager.init();
            LanguageManager.getInstance().addListener((ILanguageListener)new LanguageListener());
            appContext.installToolCustomUI();
            ToolTipManager.sharedInstance().setInitialDelay(0);
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(Thread.currentThread().getClass()).error("Start main frame failed.", e);
        }
    }

    public String getCurrentProcessPid() {
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        String name = runtimeMxBean.getName();
        String pid = name.split("@")[0];
        log.info("pid name is:{};pid is :{}", (Object)name, (Object)pid);
        return pid;
    }

    public void installToolCustomUI() {
        UIDefaults uiDefault = UIManager.getDefaults();
        uiDefault.put("oem.color", new Color(0x990000));
        uiDefault.put("SplitPaneDivider.border", ToolBorderUtils.getSplitPaneDividerBorder());
        uiDefault.put("IsmButton.height", (Object)25);
        uiDefault.put("Panel.background", UiConstants.PANEL_COLOR);
        uiDefault.put("ToolButton.disabledFillBackground", new Color(0xF3F3F3));
        if (!"true".equalsIgnoreCase((String)uiDefault.get("buttonUiInited"))) {
            uiDefault.put("ButtonUI", "com.huawei.ism.tool.obase.ui.surface.ToolButtonUI");
        }
        UIManager.getDefaults().getUIClass("ButtonUI");
        uiDefault.put("HeaderLogoPanelUI", "com.huawei.ism.tool.toolbox.ui.surface.HeaderLogoPanelUI");
        uiDefault.put("WizardHeadPanelUI", "com.huawei.ism.tool.obase.ui.surface.WizardHeadPanelUI");
        uiDefault.put("FuncItemUI", "com.huawei.ism.tool.obase.ui.surface.FuncItemUI");
        uiDefault.put("HilightUI", "com.huawei.ism.tool.taskmanager.ui.component.HilightUI");
        uiDefault.put("ToolTabbedPaneUI", "com.huawei.ism.tool.toolbox.ui.surface.ToolTabbedPaneUI");
        uiDefault.put("ToolStatusBarUI", "com.huawei.ism.tool.toolbox.ui.surface.ToolStatusBarUI");
        uiDefault.put("TaskBarUI", "com.huawei.ism.tool.toolbox.ui.surface.TaskBarUI");
        uiDefault.put("HeadRightPanelUI", "com.huawei.ism.tool.toolbox.ui.surface.HeadRightPanelUI");
        uiDefault.put("ToolRightPanelUI", "com.huawei.ism.tool.obase.ui.surface.ToolRightPanelUI");
        uiDefault.put("HomepageBackgroundUI", "com.huawei.ism.tool.obase.ui.surface.HomepageBackgroundUI");
        uiDefault.put("SceneBackgroundPanelUI", "com.huawei.ism.tool.obase.ui.surface.SceneBackgroundPanelUI");
        uiDefault.put("WizardImagePanelUI", "com.huawei.ism.tool.obase.ui.surface.WizardImagePanelUI");
        uiDefault.put("ToolTipUI", "com.huawei.ism.ui.swing.plaf.IsmToolTipUI");
        uiDefault.put("WizardStepGroupUI", "com.huawei.ism.tool.obase.ui.component.wizard.WizardStepGroupUI");
        uiDefault.put("WizardStepItemUI", "com.huawei.ism.tool.obase.ui.component.wizard.WizardStepItemUI");
        uiDefault.put("WizardNumberPanelUI", "com.huawei.ism.tool.obase.ui.component.wizard.WizardNumberPanelUI");
        this.setWizardUi(uiDefault);
        UIManager.getDefaults().getUI(new JToolTip());
    }

    private void setWizardUi(UIDefaults uiDefault) {
        uiDefault.put("NewWizardStepGroupUI", "com.huawei.ism.tool.base.ui.component.wizard.WizardStepGroupUI");
        uiDefault.put("NewWizardStepItemUI", "com.huawei.ism.tool.base.ui.component.wizard.WizardStepItemUI");
        uiDefault.put("NewWizardNumberPanelUI", "com.huawei.ism.tool.base.ui.component.wizard.WizardNumberPanelUI");
        uiDefault.put("TitleBar.dialog_help_normal", ResourceUtil.getImage("help_normal.png"));
        uiDefault.put("TitleBar.dialog_help_rollover", ResourceUtil.getOEMImage("help_hover.png"));
        uiDefault.put("TitleBar.dialog_help_selected", ResourceUtil.getImage("help_select.png"));
        uiDefault.put("TitleBar.titleBar_maxsize_normal", ResourceUtil.getImage("titleBar_maxsize_normal.png"));
        uiDefault.put("TitleBar.titleBar_maxsize_rollover", ResourceUtil.getImage("titleBar_maxsize_rollover.png"));
        uiDefault.put("TitleBar.titleBar_maxsize_selected", ResourceUtil.getImage("titleBar_maxsize_selected.png"));
        uiDefault.put("TitleBar.titleBar_maxsizeback_normal", ResourceUtil.getImage("titleBar_maxsizeback_normal.png"));
        uiDefault.put("TitleBar.titleBar_maxsizeback_rollover", ResourceUtil.getImage("titleBar_maxsizeback_rollover.png"));
        uiDefault.put("TitleBar.titleBar_maxsizeback_selected", ResourceUtil.getImage("titleBar_maxsizeback_selected.png"));
        uiDefault.put("TitleBar.titleBar_minimize_normal", ResourceUtil.getImage("titleBar_minimize_normal.png"));
        uiDefault.put("TitleBar.titleBar_minimize_rollover", ResourceUtil.getImage("titleBar_minimize_rollover.png"));
        uiDefault.put("TitleBar.titleBar_minimize_selected", ResourceUtil.getImage("titleBar_minimize_selected.png"));
        uiDefault.put("TitleBar.dialog_about_taskbar_normal", ResourceUtil.getImage("about_taskbar_normal.png"));
        uiDefault.put("TitleBar.dialog_about_taskbar_rollover", ResourceUtil.getImage("about_taskbar_rollover.png"));
        uiDefault.put("TitleBar.dialog_about_taskbar_selected", ResourceUtil.getImage("about_taskbar_selected.png"));
        uiDefault.put("List.cellRenderer", new ArmorListCellRender());
        uiDefault.put("ToolImagePanelUI", "com.huawei.ism.tool.obase.ui.surface.IsmImagePanelUI");
        uiDefault.put("TitleBar.dialog_setting_taskbar_normal", com.huawei.ism.tool.base.utils.ResourceUtil.getImage((String)"setting_taskbar_normal.png"));
        uiDefault.put("TitleBar.dialog_setting_taskbar_rollover", com.huawei.ism.tool.base.utils.ResourceUtil.getImage((String)"setting_taskbar_rollover.png"));
        uiDefault.put("TitleBar.dialog_setting_taskbar_selected", com.huawei.ism.tool.base.utils.ResourceUtil.getImage((String)"setting_taskbar_selected.png"));
    }

    public void setJunitIsOpen() {
        this.isTest = true;
    }

    public boolean isJunit() {
        return this.isTest;
    }

    public boolean isWindowsOS() {
        String osName = System.getProperty("os.name");
        if (null == osName) {
            throw new EncapsulatedRuntimeException("cannot get the System Property of [os.name].");
        }
        String osSystem = osName.toLowerCase(Locale.ENGLISH);
        if (osSystem.contains("windows")) {
            return true;
        }
        if (osSystem.contains("linux")) {
            return false;
        }
        return false;
    }

    public boolean isLinuxOS() {
        String osName = System.getProperty("os.name");
        if (null == osName) {
            throw new EncapsulatedRuntimeException("cannot get the System Property of [os.name].");
        }
        String osSystem = osName.toLowerCase(Locale.ENGLISH);
        return osSystem.contains("linux");
    }

    public void setDefaultFeelAndLook() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockLanguageChange(String reason) {
        LanguageChangeLock languageChangeLock = this.languageChangeLock;
        synchronized (languageChangeLock) {
            this.languageChangeLock.setLock(true);
            this.languageChangeLock.setLockReason(reason);
        }
    }

    public boolean isLanguageChangeLock() {
        return this.languageChangeLock.isLock();
    }

    public String getLanguageChangeLockReason() {
        if (this.languageChangeLock.isLock()) {
            return this.languageChangeLock.getLockReason();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unLockLanguageChange() {
        LanguageChangeLock languageChangeLock = this.languageChangeLock;
        synchronized (languageChangeLock) {
            this.languageChangeLock.setLock(false);
        }
    }

    public boolean isCallHomeEnv() {
        ResourceBundle resource = ResourceBundle.getBundle("config.system_base");
        String strVal = ResourceUtil.getString(resource, "tool.iscallhome");
        return Boolean.valueOf(strVal);
    }

    public boolean isCallHomeBackend() {
        return Boolean.parseBoolean(System.getProperty(IS_CALLHOME_BACKEND));
    }

    public IToolUIManager getToolUiManager() {
        return this.toolUiManager;
    }

    public void setToolUiManager(IToolUIManager toolUiManager) {
        this.toolUiManager = toolUiManager;
    }

    public static IniReader getSystemCfg() {
        File systemIni = new File(ApplicationContext.getInstance().getWorkPath(), "cfg" + File.separator + "system.ini");
        if (!systemIni.exists()) {
            return new IniReader("");
        }
        return new IniReader(systemIni);
    }

    public boolean checkOtherToolRunning() {
        if (null == this.toolUiManager) {
            return false;
        }
        for (Map.Entry<String, String> tool : this.toolUiManager.getAllTools().entrySet()) {
            if (this.checkToolIsRunningByBackend(tool)) continue;
            if (this.checkToolRunningById(tool, RUNNING_FLAG, false, true)) {
                return true;
            }
            if (!this.checkToolRunningById(tool, BACK_FLAG, false, true)) continue;
            return true;
        }
        return false;
    }

    public boolean checkForeToolRunning(boolean isShowTip) {
        String toolsName = this.getToolsName().toString();
        String curSceneStepName = com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().getCurSceneStepName();
        if (!toolsName.isEmpty()) {
            if (!curSceneStepName.isEmpty()) {
                toolsName = curSceneStepName + " ";
            }
            if (isShowTip) {
                toolsName = toolsName.substring(0, toolsName.length() - 1);
                String msg = ResourceUtil.getStringWithParams("tool.already.running", toolsName);
                DialogUtils.showInfoDialog((Frame)this.toolUiManager.getMainframe(), (String)msg);
            }
            return true;
        }
        return false;
    }

    public boolean checkForeToolRunning() {
        return this.checkForeToolRunning(true);
    }

    public boolean checkOtherToolRunning(boolean isQuit) {
        return this.checkOtherToolRunning(isQuit, true);
    }

    public boolean checkOtherToolRunning(boolean isQuit, boolean isShowTip) {
        if (null == this.toolUiManager) {
            return false;
        }
        for (Map.Entry<String, String> tool : this.toolUiManager.getAllTools().entrySet()) {
            if (this.checkToolIsRunningByBackend(tool)) continue;
            if (this.checkToolRunningById(tool, RUNNING_FLAG, isQuit, isShowTip)) {
                return true;
            }
            if (!this.checkToolRunningById(tool, BACK_FLAG, isQuit, isShowTip)) continue;
            ITimingTaskService taskService = (ITimingTaskService)PublicServiceManage.getInstance().getService(ITimingTaskService.class);
            taskService.openTaskManageDialog();
            return true;
        }
        return false;
    }

    public boolean isNewToolboxAndOldTool(String toolId) {
        String tolBoxSysProp = Paths.get(UserOpDataSaveUtil.getToolBoxPath(), "configuration", "system.properties").toString();
        String tolToolIni = Paths.get(com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().getWorkPath(), "tools", toolId, "tool.ini").toString();
        log.info("tolToolIni path = {}", (Object)tolToolIni);
        String tolBoxReleaseDate = ProperUtils.getInstance().getValue(new File(tolBoxSysProp), "app.release.date").substring(0, 8);
        String tolReleaseDate = ProperUtils.getInstance().getValue(new File(tolToolIni), "date").replaceAll("-", "");
        log.info("the current toolBox release date is: {}, the current tool release date is: {}", (Object)tolBoxReleaseDate, (Object)tolReleaseDate);
        return tolBoxReleaseDate.compareTo(RELEASE_TIME_MARK) >= 0 && tolReleaseDate.compareTo(RELEASE_TIME_MARK) < 0;
    }

    private boolean checkToolIsRunningByBackend(Map.Entry<String, String> tool) {
        String toolIniPath = Paths.get(com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().getWorkPath(), "tools", tool.getKey(), "tool.ini").toString();
        File toolIni = new File(toolIniPath);
        if (!toolIni.exists()) {
            return false;
        }
        IniReader iniFile = new IniReader(toolIni);
        return iniFile.getBoolean("tool.run.isRunningByBackend");
    }

    private boolean checkToolRunningById(Map.Entry<String, String> tool, String flag, boolean isQuit, boolean isShowTip) {
        boolean exsit = this.isToolRunning(tool.getKey(), flag);
        if (exsit) {
            String logMsg = "the tool is running ";
            logMsg = logMsg + (flag.equals(RUNNING_FLAG) ? "foreground:" : "background:");
            if (log.isInfoEnabled()) {
                log.info(logMsg + tool.getKey() + " " + exsit);
            }
            if (isShowTip) {
                String mulToolMsg = this.getMulToolMsg(isQuit);
                if (StringUtils.isNULLStr((String)mulToolMsg)) {
                    return false;
                }
                if (log.isInfoEnabled()) {
                    log.info("the mulToolMsg is :" + mulToolMsg);
                }
                DialogUtils.showInfoDialog((Frame)this.toolUiManager.getMainframe(), (String)mulToolMsg);
            }
            return true;
        }
        return false;
    }

    public boolean isToolRunning(String toolId, String flag) {
        return ToolRunningCheckUtil.isToolRunning((String)toolId, (String)flag);
    }

    public String getMulToolMsg(boolean isQuit) {
        String toolsName = this.getToolsName().toString();
        String curSceneStepName = com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().getCurSceneStepName();
        String backToolsName = this.getBackToolsName().toString();
        StringBuilder msg = new StringBuilder();
        if (!toolsName.isEmpty()) {
            if (!curSceneStepName.isEmpty()) {
                toolsName = curSceneStepName + " ";
            }
            toolsName = toolsName.substring(0, toolsName.length() - 1);
            msg.append(ResourceUtil.getStringWithParams("tool.already.running", toolsName));
            this.addMsgByAction(isQuit, msg);
        }
        if (!backToolsName.isEmpty()) {
            backToolsName = backToolsName.substring(0, backToolsName.length() - 1);
            msg.append(ResourceUtil.getStringWithParams("backtool.already.running", backToolsName));
            this.addMsgByAction(isQuit, msg);
        }
        return msg.toString();
    }

    public String getMulToolMsg() {
        String toolsName = this.getToolsName().toString();
        String curSceneStepName = com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().getCurSceneStepName();
        StringBuilder msg = new StringBuilder();
        if (!toolsName.isEmpty()) {
            if (!curSceneStepName.isEmpty()) {
                toolsName = curSceneStepName + " ";
            }
            toolsName = toolsName.substring(0, toolsName.length() - 1);
            msg.append(ResourceUtil.getStringWithParams("tool.already.running", toolsName));
        }
        return msg.toString();
    }

    private void addMsgByAction(boolean isQuit, StringBuilder msg) {
        if (isQuit) {
            msg.append(ResourceUtil.getString("backtool.already.running.shutdown"));
        } else {
            msg.append(ResourceUtil.getString("backtool.already.running.open"));
        }
    }

    public StringBuilder getToolsName() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> tool : this.toolUiManager.getAllTools().entrySet()) {
            if (!this.isToolRunning(tool.getKey(), RUNNING_FLAG)) continue;
            Locale loc = LanguageManager.getInstance().getCurrentLanguage();
            if (loc.equals(Locale.CHINESE) || loc.equals(Locale.CHINA)) {
                sb.append(tool.getValue()).append("\u3001");
                continue;
            }
            sb.append(tool.getValue()).append(',');
        }
        return sb;
    }

    private StringBuilder getBackToolsName() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> tool : this.toolUiManager.getAllTools().entrySet()) {
            if (!this.isToolRunning(tool.getKey(), BACK_FLAG)) continue;
            ToolLoggerFactory.getLogger(ApplicationContext.class).info("backtool name is : " + tool.getValue());
            Locale loc = LanguageManager.getInstance().getCurrentLanguage();
            if (loc.equals(Locale.CHINESE) || loc.equals(Locale.CHINA)) {
                sb.append(tool.getValue()).append("\u3001");
                continue;
            }
            sb.append(tool.getValue()).append(',');
        }
        return sb;
    }

    public boolean isUpgradeEvaluTool() {
        return this.upgradeEvaluTool;
    }

    public void setUpgradeEvaluTool(boolean upgradeEvaluTool) {
        this.upgradeEvaluTool = upgradeEvaluTool;
    }

    public boolean isHost() {
        return this.sshForHost;
    }

    public void setHost(boolean isHost) {
        this.sshForHost = isHost;
    }

    public static boolean isRunInSvp() {
        return LocalHostUtil.isRunInV3LaterSvp();
    }

    public void setBackInspectRunning(boolean backInspectRunning) {
        this.gloabIsBackInspectRunning = backInspectRunning;
    }

    public boolean isBackInspectRunning() {
        return this.gloabIsBackInspectRunning;
    }

    public boolean isCommonVersion() {
        return PlatformAppContext.getInstance().getFunctionBooleanByKey(TOOLKIT_APP_ZH_OR_EN_VERSION);
    }

    public int getMaxImportThreadSize() {
        int size = 10;
        File systemIni = new File(this.getWorkPath(), "cfg" + File.separator + "system.ini");
        if (systemIni.exists()) {
            IniReader iniReader = new IniReader(systemIni);
            return StringUtils.str2Int((String)iniReader.getString("adddevice.threadnum"), (int)size);
        }
        return size;
    }

    public final long getMaxUnzipFileSize() {
        return com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().getMaxUnzipFileSize();
    }

    public final long getMaxUnzipFileNum() {
        return com.huawei.ism.tool.framework.platform.util.ApplicationContext.getInstance().getMaxUnzipFileNum();
    }

    private static int getCurrentProcessId() {
        try {
            Class<?> managementFactoryClass = Class.forName("java.lang.management.ManagementFactory");
            Method getRuntimeMXBean = managementFactoryClass.getDeclaredMethod("getRuntimeMXBean", new Class[0]);
            Class<?> runtimeMXBeanClass = Class.forName("java.lang.management.RuntimeMXBean");
            Method getName = runtimeMXBeanClass.getDeclaredMethod("getName", new Class[0]);
            Object runtimeMXBean = getRuntimeMXBean.invoke(null, new Object[0]);
            String name = (String)getName.invoke(runtimeMXBean, new Object[0]);
            return Integer.parseInt(name.split("@")[0]);
        }
        catch (Exception ex) {
            log.warn("get process id by JMX failed", ex);
            try {
                return Integer.parseInt(new File("/proc/self").getCanonicalFile().getName());
            }
            catch (Exception exception) {
                log.warn("try to get process id by proc file failed", exception);
                return -1;
            }
        }
    }

    private static class LanguageListener
    implements ILanguageListener {
        private LanguageListener() {
        }

        public void fireLanguageChanged(Locale language) {
            ResourceManager.setLocale((Locale)language);
            IsmPlafUtils.setLocale((Locale)language);
        }
    }
}

