/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.reflection.PrimitiveParser;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;

public final class ClassUtils {
    public static final Map<String, Class<?>> PRIM_CLASS_MAP = new HashMap(8, 1.0f);
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ClassUtils.class);
    private static final Map<Class<?>, PrimitiveParser> PRIMPARSERS = new HashMap(8, 1.0f);

    private ClassUtils() {
    }

    public static Method toSetMethod(Class<?> cls, String field, Class<?>[] paramTypes) {
        String set = "set" + field.substring(0, 1).toUpperCase(Locale.ENGLISH) + field.substring(1);
        return ClassUtils.getClassMethod(cls, set, paramTypes);
    }

    public static Method toGetMethod(Class<?> cls, String field) {
        String get = "get" + field.substring(0, 1).toUpperCase(Locale.ENGLISH) + field.substring(1);
        return ClassUtils.getClassMethod(cls, get, new Class[0]);
    }

    public static Method toIsMethod(Class<?> cls, String field) {
        String get = "is" + field.substring(0, 1).toUpperCase(Locale.ENGLISH) + field.substring(1);
        return ClassUtils.getClassMethod(cls, get, new Class[0]);
    }

    public static Method toAddMethod(Class<?> cls, String field, Class<?>[] paramTypes) {
        String add = "add" + field.substring(0, 1).toUpperCase(Locale.ENGLISH) + field.substring(1);
        return ClassUtils.getClassMethod(cls, add, paramTypes);
    }

    public static Constructor<?> getConstructor(Class<?> cls, Class<?>[] paramTypes) {
        Constructor<?> cons = null;
        try {
            cons = cls.getConstructor(paramTypes);
        }
        catch (Exception e) {
            StringBuffer params = new StringBuffer();
            for (Class<?> p : paramTypes) {
                params.append(p.getName() + ",");
            }
            LOGGER.error("Get constructor error for class: " + cls.getName() + ", parameters: " + params, e);
        }
        return cons;
    }

    public static Class<?> getClazz(String className) {
        Class<?> cls = PRIM_CLASS_MAP.get(className);
        if (null == cls && null != className) {
            try {
                cls = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                LOGGER.error("Cannot load class for type: " + className, e);
            }
        }
        return cls;
    }

    public static Object parsePrimitive(Class<?> type, String str) {
        Object obj = null;
        PrimitiveParser parser = PRIMPARSERS.get(type);
        if (null != parser) {
            obj = parser.parseValue(str);
        }
        return obj;
    }

    public static String objectToString(Object obj) {
        String str = null;
        str = null == obj ? "" : (obj.getClass().isPrimitive() ? String.valueOf(obj) : obj.toString());
        return str;
    }

    public static Object stringToObject(Class<?> cls, String str) {
        Constructor<?> constr;
        Object obj = null;
        if (cls.isPrimitive()) {
            obj = ClassUtils.parsePrimitive(cls, str);
        } else if (!cls.equals(String.class) && null != (constr = ClassUtils.getConstructor(cls, new Class[]{String.class}))) {
            try {
                obj = constr.newInstance(str);
            }
            catch (Exception e) {
                LOGGER.error("Invoke constructor error:" + cls.getName() + ", parameter: " + str, e);
            }
        }
        return obj;
    }

    public static Object[] objectToArray(Object value) {
        Object[] arr = null;
        if (null == value) {
            return arr;
        }
        if (value.getClass().isArray()) {
            arr = (Object[])value;
        } else {
            try {
                Method toArray = value.getClass().getMethod("toArray", new Class[0]);
                arr = (Object[])toArray.invoke(value, new Object[0]);
            }
            catch (RuntimeException e) {
                arr = new Object[]{};
            }
            catch (Exception e1) {
                arr = new Object[]{};
            }
        }
        return arr;
    }

    private static Method getClassMethod(Class<?> cls, String mtdName, Class<?>[] paramTypes) {
        Method method = null;
        try {
            method = cls.getMethod(mtdName, paramTypes);
        }
        catch (Exception e) {
            StringBuffer params = new StringBuffer();
            for (Class<?> cl : paramTypes) {
                params.append(cl.getName() + ",");
            }
            LOGGER.error("Get Class method error. Class: " + cls.getName() + ", method: " + mtdName + ", parameters: " + params.toString(), e);
        }
        return method;
    }

    static {
        PRIMPARSERS.put(Boolean.TYPE, new PrimitiveParser.BooleanParser());
        PRIMPARSERS.put(Byte.TYPE, new PrimitiveParser.ByteParser());
        PRIMPARSERS.put(Character.TYPE, new PrimitiveParser.CharParser());
        PRIMPARSERS.put(Short.TYPE, new PrimitiveParser.ShortParser());
        PRIMPARSERS.put(Integer.TYPE, new PrimitiveParser.IntegerParser());
        PRIMPARSERS.put(Long.TYPE, new PrimitiveParser.LongParser());
        PRIMPARSERS.put(Float.TYPE, new PrimitiveParser.FloatParser());
        PRIMPARSERS.put(Double.TYPE, new PrimitiveParser.DoubleParser());
        PRIM_CLASS_MAP.put("boolean", Boolean.TYPE);
        PRIM_CLASS_MAP.put("byte", Byte.TYPE);
        PRIM_CLASS_MAP.put("char", Character.TYPE);
        PRIM_CLASS_MAP.put("short", Short.TYPE);
        PRIM_CLASS_MAP.put("int", Integer.TYPE);
        PRIM_CLASS_MAP.put("long", Long.TYPE);
        PRIM_CLASS_MAP.put("float", Float.TYPE);
        PRIM_CLASS_MAP.put("double", Double.TYPE);
        PRIM_CLASS_MAP.put("void", Void.TYPE);
    }
}

