/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.IniReader;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IniResourceUtil {
    private static final Map<String, IniReader> INI_READ_CACHE = new ConcurrentHashMap<String, IniReader>();
    private static final Logger LOGGER = LoggerFactory.getLogger(IniResourceUtil.class);

    private IniResourceUtil() {
    }

    public static void loadPyRes(String resourceDir, String name) {
        String cacheKey = IniResourceUtil.getCacheKey(resourceDir, name);
        LOGGER.info("cacheKey={}", (Object)cacheKey);
        try (InputStream fis = IniResourceUtil.class.getClassLoader().getResourceAsStream(cacheKey);){
            if (!INI_READ_CACHE.containsKey(cacheKey)) {
                IniReader reader = new IniReader(fis);
                INI_READ_CACHE.put(cacheKey, reader);
            }
        }
        catch (IOException e) {
            LOGGER.error("the file is not exist.");
        }
    }

    private static String getCacheKey(String resourceDir, String name) {
        String lang = ApplicationContext.getInstance().isEnglishEnv() ? "en" : "zh";
        String fileName = name + "_" + lang + ".ini";
        return resourceDir + "/" + fileName;
    }

    public static synchronized String getString(String key) {
        for (IniReader reader : INI_READ_CACHE.values()) {
            String val = reader.getString(key);
            if (StringUtils.isNULLStr(val) || val.equals("--")) continue;
            val = val.replaceAll("\\\\n", "\n");
            return val;
        }
        return "--";
    }

    public static synchronized String getString(String resourceDir, String name, String key) {
        String val;
        String cacheKey = IniResourceUtil.getCacheKey(resourceDir, name);
        if (INI_READ_CACHE.containsKey(cacheKey) && !StringUtils.isNULLStr(val = INI_READ_CACHE.get(cacheKey).getString(key)) && !val.equals("--")) {
            val = val.replaceAll("\\\\n", "\n");
            return val;
        }
        return "--";
    }
}

