/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.obase.entity.ConfigItem;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class ManualConfigItemMgr {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(ManualConfigItemMgr.class);
    private Map<String, List<ConfigItem>> configItems = new HashMap<String, List<ConfigItem>>();
    private static File outfile = null;
    private static ManualConfigItemMgr instance = new ManualConfigItemMgr();
    private static final String DEFAULT = "default";

    public static final ManualConfigItemMgr getInstance() {
        if (null == instance) {
            instance = new ManualConfigItemMgr();
        }
        return instance;
    }

    private ManualConfigItemMgr() {
    }

    public void init(File file, boolean reservedGlobel) {
        outfile = file;
        this.read();
        ArrayList<ConfigItem> items = new ArrayList<ConfigItem>();
        for (List<ConfigItem> value : this.configItems.values()) {
            items.addAll(value);
        }
        if (items.isEmpty()) {
            this.initWithClearAllItems(file);
            LOGGER.error("Get globla item null");
            return;
        }
        ArrayList<ConfigItem> gloabelTemp = new ArrayList<ConfigItem>();
        for (ConfigItem item : items) {
            LOGGER.error("Get global item name:" + item.getName());
            if (reservedGlobel && item.getName().startsWith("global")) {
                gloabelTemp.add(item);
                continue;
            }
            if (!item.getName().startsWith("permanent")) continue;
            gloabelTemp.add(item);
        }
        this.initWithClearAllItems(file);
        this.configItems.put(DEFAULT, gloabelTemp);
        this.write();
    }

    public void init(File file) {
        this.init(file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void initWithClearAllItems(File file) {
        this.configItems.clear();
        outfile = file;
        if (!outfile.exists() || !outfile.isFile()) {
            try {
                boolean rt = outfile.createNewFile();
                if (rt) return;
                LOGGER.error("Create file ignoreitem.txt failed");
                return;
            }
            catch (Exception e) {
                LOGGER.error("Create file ignoreitem.txt exception:", e);
                return;
            }
        }
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(outfile), "UTF-8");
            writer.write("");
        }
        catch (Exception e) {
            try {
                LOGGER.error("Delete file ignoreitem.txt exception:", e);
            }
            catch (Throwable throwable) {
                StreamUtils.closeResource(null, writer);
                throw throwable;
            }
            StreamUtils.closeResource(null, (Closeable)writer);
            return;
        }
        StreamUtils.closeResource(null, (Closeable)writer);
        return;
    }

    public synchronized void addItem(String module, String name, String value, String desc) {
        ConfigItem item = new ConfigItem(name, value, desc);
        if (null == this.getItem(module, item.getName())) {
            this.add(module, item);
            this.write();
        }
    }

    public synchronized void addItem(String name, String value, String desc) {
        ConfigItem item = new ConfigItem(name, value, desc);
        if (null == this.getItem(DEFAULT, item.getName())) {
            this.add(DEFAULT, item);
            this.write();
        }
    }

    public boolean expected(String module, String name, String expectedValue) {
        ConfigItem item = this.getItem(module, name);
        return null != item && null != item.getValue() && expectedValue.equals(item.getValue().trim());
    }

    public boolean expected(String name, String expectedValue) {
        ConfigItem item = this.getItem(DEFAULT, name);
        return null != item && null != item.getValue() && expectedValue.equals(item.getValue().trim());
    }

    public synchronized ConfigItem getItem(String module, String name) {
        this.read();
        return this.find(module, name);
    }

    private ConfigItem find(String module, String name) {
        List<ConfigItem> items = this.configItems.get(module);
        if (null == items) {
            return null;
        }
        for (ConfigItem item : items) {
            if (!item.getName().equals(name)) continue;
            return item;
        }
        return null;
    }

    private void add(String module, ConfigItem item) {
        List<ConfigItem> items = this.configItems.get(module);
        if (null == items) {
            items = new ArrayList<ConfigItem>();
            this.configItems.put(module, items);
        }
        items.add(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write() {
        block7: {
            OutputStreamWriter writer = null;
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(outfile);
                writer = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
                for (Map.Entry<String, List<ConfigItem>> entry : this.configItems.entrySet()) {
                    for (ConfigItem item : entry.getValue()) {
                        writer.write(this.writeItem(entry.getKey(), item));
                    }
                    writer.write("\r\n");
                }
                StreamUtils.closeResource(null, (Closeable)writer);
            }
            catch (Exception e) {
                LOGGER.error("Delete file ignoreitem.txt exception:", e);
                break block7;
            }
            finally {
                StreamUtils.closeResource(null, writer);
                StreamUtils.closeStream((OutputStream)fileOutputStream, null);
            }
            StreamUtils.closeStream((OutputStream)fileOutputStream, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read() {
        block8: {
            InputStreamReader isr = null;
            BufferedReader br = null;
            try {
                if (outfile == null || !outfile.exists() || !outfile.isFile()) {
                    return;
                }
                isr = new InputStreamReader((InputStream)new FileInputStream(outfile), "utf-8");
                br = new BufferedReader(isr);
                String line = null;
                while ((line = br.readLine()) != null) {
                    line = line.trim();
                    this.readContext(line);
                }
                StreamUtils.closeResource(null, (Closeable)isr);
            }
            catch (Exception e) {
                LOGGER.error("Read file ignoreitem.txt failed.", e);
                break block8;
            }
            finally {
                StreamUtils.closeResource(null, isr);
                StreamUtils.closeResource(null, br);
            }
            StreamUtils.closeResource(null, (Closeable)br);
        }
    }

    private void readContext(String line) {
        if (!line.startsWith("#") && line.contains("=")) {
            ConfigItem item;
            String[] sectors = line.split("=");
            String name = sectors[0];
            String value = sectors[1];
            String module = DEFAULT;
            String key = name;
            if (name.indexOf("_") != -1) {
                String[] tempSecs = name.split("_");
                module = tempSecs[0];
                key = tempSecs[1];
            }
            if (null != (item = this.find(module, key))) {
                if (!item.getValue().equals(value) && LOGGER.isInfoEnabled()) {
                    LOGGER.info("the config item:###" + name + "### is changed to " + value);
                }
                item.setValue(value);
            } else {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("the config item:###" + name + "### is created with " + value);
                }
                this.add(module, new ConfigItem(key, value, ""));
            }
        }
    }

    private String writeItem(String module, ConfigItem item) {
        StringBuffer sb = new StringBuffer();
        if (!StringUtils.isNULLStr(item.getDesc())) {
            sb.append("#").append(item.getDesc()).append(System.lineSeparator());
        }
        String key = item.getName();
        if (!DEFAULT.equals(module)) {
            key = module + "_" + key;
        }
        sb.append(key).append("=").append(item.getValue());
        sb.append(System.lineSeparator());
        return sb.toString();
    }
}

