/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.ClassUtils;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import org.slf4j.Logger;

public final class SerializableUtils {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SerializableUtils.class);

    private SerializableUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeObject(Object obj, String fileName) throws IOException {
        File reFile;
        FileOutputStream fileOutputStream;
        ObjectOutputStream objectOutputStream;
        block7: {
            block8: {
                boolean state;
                if (!(obj instanceof Serializable)) {
                    return;
                }
                File path = new File(ApplicationContext.getInstance().getTmpPath());
                if (!path.exists() && !(state = path.mkdir())) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("create TMP_OBJECT_PATH path state" + state);
                    }
                    return;
                }
                objectOutputStream = null;
                fileOutputStream = null;
                try {
                    reFile = FilePathUtils.checkFile((File)new File(ApplicationContext.getInstance().getTmpPath() + fileName));
                    if (reFile.exists() || reFile.createNewFile()) break block7;
                    if (!LOGGER.isInfoEnabled()) break block8;
                    LOGGER.info("Create reFile file error.File name is {}", (Object)reFile);
                }
                catch (Throwable throwable) {
                    StreamUtils.closeStream(fileOutputStream, null);
                    StreamUtils.closeStream(objectOutputStream, null);
                    throw throwable;
                }
            }
            StreamUtils.closeStream(fileOutputStream, null);
            StreamUtils.closeStream(objectOutputStream, null);
            return;
        }
        fileOutputStream = new FileOutputStream(reFile.getCanonicalFile());
        objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(obj);
        objectOutputStream.flush();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Save tmp device file success. {}", (Object)reFile);
        }
        StreamUtils.closeStream(fileOutputStream, null);
        StreamUtils.closeStream(objectOutputStream, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object readObject(String fileName) {
        Object object;
        File reFile = FilePathUtils.checkFile((File)new File(ApplicationContext.getInstance().getTmpPath() + fileName));
        if (!reFile.exists()) {
            return null;
        }
        ObjectInputStream inputStream = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(reFile.getCanonicalFile());
            inputStream = new ObjectInputStream(fileInputStream);
            object = inputStream.readObject();
        }
        catch (Exception e) {
            try {
                LOGGER.error("Read info from tmp file error.", e);
            }
            catch (Throwable throwable) {
                StreamUtils.closeStream(null, fileInputStream);
                StreamUtils.closeStream(null, inputStream);
                throw throwable;
            }
            StreamUtils.closeStream(null, fileInputStream);
            StreamUtils.closeStream(null, inputStream);
            return null;
        }
        StreamUtils.closeStream(null, fileInputStream);
        StreamUtils.closeStream(null, inputStream);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Object readObject(String fileName, Class<?> clazz) {
        Object object;
        File reFile = FilePathUtils.checkFile((File)new File(ApplicationContext.getInstance().getTmpPath() + fileName));
        if (!reFile.exists()) {
            return null;
        }
        OsgiObjectInputStream stream = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(reFile.getCanonicalFile());
            stream = new OsgiObjectInputStream(fileInputStream, clazz.getClassLoader());
            object = stream.readObject();
        }
        catch (RuntimeException e) {
            LOGGER.error("Read info from tmp file error.", e);
            Object var6_8 = null;
            StreamUtils.closeStream(null, fileInputStream);
            StreamUtils.closeStream(null, stream);
            return var6_8;
        }
        catch (Exception e2) {
            LOGGER.error("Read info from tmp file error.", e2);
            Object var6_9 = null;
            {
                catch (Throwable throwable) {
                    StreamUtils.closeStream(null, fileInputStream);
                    StreamUtils.closeStream(null, stream);
                    throw throwable;
                }
            }
            StreamUtils.closeStream(null, fileInputStream);
            StreamUtils.closeStream(null, stream);
            return var6_9;
        }
        StreamUtils.closeStream(null, fileInputStream);
        StreamUtils.closeStream(null, stream);
        return object;
    }

    private static class OsgiObjectInputStream
    extends ObjectInputStream {
        private ClassLoader cl = Thread.currentThread().getContextClassLoader();

        public OsgiObjectInputStream(FileInputStream fis, ClassLoader cl) throws IOException {
            super(fis);
            this.cl = cl;
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            String name = desc.getName();
            try {
                return Class.forName(name, false, this.cl);
            }
            catch (ClassNotFoundException ex) {
                Class<?> clazz = ClassUtils.PRIM_CLASS_MAP.get(name);
                if (clazz != null) {
                    return clazz;
                }
                throw ex;
            }
        }
    }
}

