/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import com.alibaba.fastjson.JSONObject;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.obase.entity.IpAddress;
import com.huawei.ism.tool.obase.entity.KeyValue;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.NetUtil;
import com.huawei.ism.tool.obase.utils.RegexConfigUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.text.Normalizer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.LoggerFactory;

public final class StringUtils {
    public static final String EMPTY = "";
    public static final String BLANK = " ";
    public static final String UNDER_LINE = "_";
    public static final String TIME_STYLE_YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String TIME_STYLE_YYYY_MM_DDHHMMSS = "yyyy-MM-dd HH:mm:ss";
    public static final String TIME_STYLE_YYYY_MM_DDHHMMSSZ = "yyyy-MM-dd HH:mm:ss z";
    public static final String TIME_STYLE_HHMMSS = "HH:mm:ss";
    public static final String LINE_SEP = "\r\n";
    public static final String TIME_STYLE_YYYY_MM_DD = "yyyy-MM-dd";
    private static final int MAX_PORT = 65535;
    public static final String LINE_SEP_N = "\n";
    private static final String TOOLS_FOLDER = "tools";

    private StringUtils() {
    }

    public static String getIndexLineString(String str, int lineNum) {
        if (StringUtils.isNULLStr(str) || lineNum < 1) {
            return EMPTY;
        }
        int off = 0;
        int next = 0;
        int count = 0;
        while ((next = str.indexOf(LINE_SEP_N, off)) != -1) {
            if (++count == lineNum) {
                return str.substring(off, next);
            }
            off = next + 1;
        }
        if (next == -1 && lineNum == 1) {
            return str;
        }
        if (next == -1 && count == lineNum - 1) {
            return str.substring(off);
        }
        return EMPTY;
    }

    public static String getLastLineString(String str) {
        if (StringUtils.isNULLStr(str)) {
            return EMPTY;
        }
        int off = str.lastIndexOf(LINE_SEP_N);
        if (-1 == off) {
            return str;
        }
        if (off != str.length() - 1) {
            return str.substring(off + 1);
        }
        int pre = str.lastIndexOf(LINE_SEP_N, off - 1);
        while (pre != -1 && pre == off - 1) {
            off = pre;
            pre = str.lastIndexOf(LINE_SEP_N, off - 1);
        }
        if (pre != -1) {
            return str.substring(pre + 1, off);
        }
        return str.substring(0, off + 1);
    }

    public static String convertMacToString(byte[] macArray) {
        if (null == macArray) {
            return null;
        }
        char[] src = new char[17];
        for (int i = 0; i < 5; ++i) {
            src[i * 3] = StringUtils.hexUpperChar(macArray[i]);
            src[i * 3 + 1] = StringUtils.hexLowerChar(macArray[i]);
            src[i * 3 + 2] = 58;
        }
        src[15] = StringUtils.hexUpperChar(macArray[5]);
        src[16] = StringUtils.hexLowerChar(macArray[5]);
        return new String(src);
    }

    private static char hexUpperChar(byte byteValue) {
        if ((byteValue = (byte)(byteValue >> 4 & 0xF)) == 0) {
            return '0';
        }
        if (byteValue < 10) {
            return (char)(48 + byteValue);
        }
        return (char)(97 + byteValue - 10);
    }

    private static char hexLowerChar(byte byteNum) {
        if ((byteNum = (byte)(byteNum & 0xF)) == 0) {
            return '0';
        }
        if (byteNum < 10) {
            return (char)(48 + byteNum);
        }
        return (char)(97 + byteNum - 10);
    }

    public static boolean ipTxtEmpty(String txtIp) {
        return null == txtIp || txtIp.isEmpty() || txtIp.equals(" . . . ");
    }

    public static boolean isSameSubnetIpv4(IpAddress addr1, IpAddress addr2) {
        long mask2;
        long ip2;
        long result2;
        long mask1;
        long ip1 = StringUtils.ip2long(addr1.getIp());
        long result1 = ip1 & (mask1 = StringUtils.ip2long(addr1.getMask()));
        return result1 == (result2 = (ip2 = StringUtils.ip2long(addr2.getIp())) & (mask2 = StringUtils.ip2long(addr2.getMask())));
    }

    public static boolean isNULLStr(String str) {
        return null == str || EMPTY.equals(str.trim());
    }

    public static boolean isCorrectMac(String mac) {
        String regex = "[A-Fa-f0-9]{12}";
        return mac.matches(regex);
    }

    public static String getDefaultValueIfNull(String value, String defaultValue) {
        String result = defaultValue;
        if (null != value) {
            result = value;
        }
        return result;
    }

    public static boolean hasNULLStr(String ... strs) {
        for (String s : strs) {
            if (!StringUtils.isNULLStr(s)) continue;
            return true;
        }
        return false;
    }

    public static String upperFirst(String str) {
        if (StringUtils.isNULLStr(str) || StringUtils.isChinese(str)) {
            return str;
        }
        char[] cs = str.toCharArray();
        cs[0] = (char)(cs[0] - 32);
        return String.valueOf(cs);
    }

    public static boolean isChinese(String str) {
        Pattern pattern = Pattern.compile("[\u4e00-\u9fa5]");
        Matcher matcher = pattern.matcher(str);
        return matcher.find();
    }

    public static boolean isZero(String str) {
        return !StringUtils.isNULLStr(str) && "0".equals(str);
    }

    public static boolean isHundred(String str) {
        return !StringUtils.isNULLStr(str) && "100".equals(str);
    }

    public static int object2Int(Object obj) {
        if (obj instanceof Byte) {
            return ((Byte)obj).byteValue();
        }
        if (obj instanceof Short) {
            return ((Short)obj).shortValue();
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        return -1;
    }

    public static int str2Int(String str) {
        if (StringUtils.isNULLStr(str)) {
            return -1;
        }
        try {
            int indexofDot = str.indexOf(".");
            if (-1 != indexofDot) {
                str = str.substring(0, indexofDot);
            }
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            ToolLoggerFactory.getLogger(StringUtils.class).error(EMPTY, e);
            return -1;
        }
    }

    public static int str2Int(String str, int defaultValue) {
        if (-1 == StringUtils.str2Int(str)) {
            return defaultValue;
        }
        return StringUtils.str2Int(str);
    }

    public static long str2Long(String str) {
        if (StringUtils.isNULLStr(str)) {
            return -1L;
        }
        try {
            int indexofDot = str.indexOf(".");
            if (-1 != indexofDot) {
                str = str.substring(0, indexofDot);
            }
            return Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            ToolLoggerFactory.getLogger(StringUtils.class).error(EMPTY, e);
            return -1L;
        }
    }

    public static long str2Long(String str, long defaultValue) {
        if (-1L == StringUtils.str2Long(str)) {
            return defaultValue;
        }
        return StringUtils.str2Long(str);
    }

    public static String findMatchStr(String source, String regex) {
        return StringUtils.findMatchStr(source, regex, 1);
    }

    public static boolean hasMatchStr(String source, String regex) {
        String result = StringUtils.findMatchStr(source, regex, 0);
        return null != result && !result.isEmpty();
    }

    public static String findMatchStr(String source, String regex, int group) {
        Pattern pattern = Pattern.compile(regex = Normalizer.normalize(regex, Normalizer.Form.NFKC));
        Matcher matcher = pattern.matcher(source);
        if (matcher.find()) {
            return matcher.group(group);
        }
        return EMPTY;
    }

    public static boolean checkRegexReDos(String source, String regex) {
        JSONObject jsonObject = RegexConfigUtils.queryJsonObject();
        if (jsonObject == null) {
            return true;
        }
        return jsonObject.getBoolean("need_check_redos") == false && jsonObject.getIntValue("max_length") > source.length() && !Pattern.compile(regex).matcher(jsonObject.getString("check_regex")).find();
    }

    public static boolean isFullIpAddress(String ipAdrress) {
        return NetUtil.isValidIPV4(ipAdrress);
    }

    public static boolean allIsVaildIpv4(String ... ips) {
        for (String ip : ips) {
            if (StringUtils.isFullIpAddress(ip)) continue;
            return false;
        }
        return true;
    }

    public static boolean ipEqualsByBit(String ip1, String ip2) {
        if (StringUtils.allIsVaildIpv6(ip1, ip2)) {
            BigInteger ip1Bit = NetUtil.ipv6Str2Int(ip1);
            BigInteger ip2Bit = NetUtil.ipv6Str2Int(ip2);
            if (null == ip1Bit) {
                return false;
            }
            return ip1Bit.equals(ip2Bit);
        }
        if (StringUtils.allIsVaildIpv4(ip1, ip2)) {
            return NetUtil.ipv4Str2Long(ip1) == NetUtil.ipv4Str2Long(ip2);
        }
        return false;
    }

    public static boolean allIsVaildIpv6(String ... ips) {
        for (String v6Ip : ips) {
            if (StringUtils.isIpv6Address(v6Ip)) continue;
            return false;
        }
        return true;
    }

    public static boolean isDigit(String str) {
        return StringUtils.str2Int(str) != -1;
    }

    public static boolean isIpv6Address(String address) {
        if (StringUtils.isNULLStr(address)) {
            return false;
        }
        return NetUtil.isValidIPV6(address);
    }

    public static String fillValues(String src, Object ... args) {
        return MessageFormat.format(src, args);
    }

    public static String genNextIpAddr(String startIp) {
        if (!StringUtils.isFullIpAddress(startIp)) {
            return EMPTY;
        }
        String[] loca = startIp.split("\\.");
        Integer val = StringUtils.str2Int(loca[3]);
        String bakedIp = startIp.substring(0, startIp.lastIndexOf(46) + 1);
        return bakedIp + ((val = Integer.valueOf(val + 1)) > 254 ? 254 : val);
    }

    public static String genNextIpv6Addr(String startIp) {
        String[] loca = startIp.split(":");
        Integer val = Integer.valueOf(loca[loca.length - 1], 16) + 1;
        String bakedIp = startIp.substring(0, startIp.lastIndexOf(58) + 1);
        return bakedIp + Integer.toHexString(val > 65534 ? 65535 : val);
    }

    public static String genDigitString(int val, int num, boolean location) {
        StringBuilder sb = new StringBuilder(String.valueOf(val));
        while (sb.length() < num) {
            int locat = location ? 0 : sb.length();
            sb.insert(locat, "0");
        }
        return sb.toString();
    }

    public static KeyValue<Boolean, String> checkIpMaskUnite(String ip, String mask) {
        String strMask = Long.toBinaryString(StringUtils.ip2long(mask));
        String strIp = Long.toBinaryString(StringUtils.ip2long(ip));
        int hostLength = 32 - strMask.indexOf("0");
        int ipLength = strIp.length();
        String hostStr = strIp.substring(ipLength - hostLength, ipLength);
        char[] strArray = hostStr.toCharArray();
        int len = strArray.length;
        if (1 == len) {
            return new KeyValue<Boolean, String>(false, String.valueOf(strArray[0]));
        }
        char firstChar = strArray[0];
        for (int i = 1; i < len; ++i) {
            if (firstChar == strArray[i]) continue;
            return new KeyValue<Boolean, Object>(true, null);
        }
        return new KeyValue<Boolean, String>(false, String.valueOf(firstChar));
    }

    public static boolean ipMaskBinaryCheck(String mask) {
        String[] arr;
        String regex = "[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}";
        if (!mask.matches(regex)) {
            return false;
        }
        StringBuilder binMask = new StringBuilder();
        for (String str : arr = mask.split("\\.")) {
            if (StringUtils.str2Int(str) <= 255) continue;
            return false;
        }
        if (255 == StringUtils.str2Int(arr[3])) {
            return false;
        }
        for (String s : arr) {
            binMask.append(StringUtils.fillMask(Integer.toBinaryString(StringUtils.str2Int(s)).toCharArray()));
        }
        return -1 == binMask.indexOf("01");
    }

    public static char[] fillMask(char[] charr) {
        int len = charr.length;
        char[] eightBit = new char[]{'0', '0', '0', '0', '0', '0', '0', '0'};
        int startIndex = 8 - len;
        for (int i = 0; i < len; ++i) {
            eightBit[startIndex + i] = charr[i];
        }
        return eightBit;
    }

    public static String toUpperHexString(int i) {
        String hex = Integer.toHexString(i);
        return hex.toUpperCase(Locale.ENGLISH);
    }

    public static boolean startIgnoreCase(String sourceStr, String headerStr) {
        if (StringUtils.isNULLStr(sourceStr) || StringUtils.isNULLStr(headerStr)) {
            return false;
        }
        return sourceStr.toLowerCase(Locale.ENGLISH).startsWith(headerStr);
    }

    public static boolean isEmailAddress(String emailAddr) {
        if (StringUtils.isNULLStr(emailAddr)) {
            return false;
        }
        if (emailAddr.contains("..")) {
            return false;
        }
        return emailAddr.matches("^[\\w-_\\/]+[\\w-_\\/.]*+@([\\w-_\\/]+[.])+[-_\\/\\w]+$");
    }

    public static String getSplitLocaleStr(String src) {
        if (src.indexOf("##") == -1) {
            return src;
        }
        String[] sp = src.split("##");
        if (ApplicationContext.getInstance().isEnglishEnv()) {
            return sp[1];
        }
        return sp[0];
    }

    public static String getDateFormat(String formatString) {
        String foramt = EMPTY;
        try {
            SimpleDateFormat sdFormat = new SimpleDateFormat(formatString);
            foramt = sdFormat.format(new Date());
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(StringUtils.class).error("format date error.", e);
        }
        return foramt;
    }

    public static String safetyGetStr(String[] arr, int idx) {
        if (arr.length > idx && idx != -1) {
            return arr[idx].trim();
        }
        return EMPTY;
    }

    public static String fillStr(String src, int maxLen, String fillChar) {
        StringBuffer strBuffer = new StringBuffer(src);
        while (strBuffer.length() < maxLen) {
            strBuffer.append(fillChar);
        }
        return strBuffer.toString();
    }

    public static String formatDate(Object formatDate, String formatStyle) {
        String foramt = EMPTY;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(formatStyle);
            if (formatDate instanceof Calendar) {
                return sdf.format(((Calendar)formatDate).getTime());
            }
            foramt = sdf.format(formatDate);
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(StringUtils.class).error("format date error.", e);
        }
        return foramt;
    }

    public static long parseDate2Long(String dateStr, String dateStrStyle) {
        SimpleDateFormat sdFormat = new SimpleDateFormat(dateStrStyle);
        try {
            sdFormat.setLenient(false);
            Date date = sdFormat.parse(dateStr);
            return date.getTime();
        }
        catch (ParseException e) {
            ToolLoggerFactory.getLogger(StringUtils.class).error("parseDate2Long error.", e);
            return 0L;
        }
    }

    public static String millls2FormatString(long duringTimingMills) {
        return StringUtils.millls2FormatString(duringTimingMills, TimeAccurateLevel.SECOND);
    }

    public static String millls2FormatString(long duringTimingMills, Enum accurateLevel) {
        int s;
        int minuteNum;
        int hourCount;
        long second = 1000L;
        long minutes = second * 60L;
        long hour = minutes * 60L;
        long day = hour * 24L;
        StringBuilder buffer = new StringBuilder();
        int dayCount = (int)(duringTimingMills / day);
        if (dayCount > 0) {
            buffer.append(ResourceUtil.getStringWithParams("day", dayCount));
        }
        if ((hourCount = (int)(duringTimingMills % day / hour)) > 0) {
            buffer.append(ResourceUtil.getStringWithParams("hour", hourCount));
        }
        if ((minuteNum = (int)(duringTimingMills % day % hour / minutes)) > 0) {
            buffer.append(ResourceUtil.getStringWithParams("min", minuteNum));
        }
        if ((s = (int)(duringTimingMills % day % hour % minutes / second)) > 0) {
            buffer.append(ResourceUtil.getStringWithParams("second", s));
        }
        if (TimeAccurateLevel.SECOND == accurateLevel) {
            return buffer.toString();
        }
        int ms = (int)(duringTimingMills % day % hour % minutes % second);
        if (ms >= 0) {
            buffer.append(ResourceUtil.getStringWithParams("ms", ms));
        }
        return buffer.toString();
    }

    public static String deleteFirstLast(String str) {
        if (StringUtils.isNULLStr(str)) {
            return EMPTY;
        }
        StringBuilder sbr = new StringBuilder(str);
        sbr.deleteCharAt(0);
        sbr.deleteCharAt(sbr.length() - 1);
        return sbr.toString();
    }

    public static long ip2long(String ipAddress) {
        String regex = "\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}";
        if (!ipAddress.matches(regex)) {
            return 0L;
        }
        String[] strVals = ipAddress.split("\\.");
        int sectLength = strVals.length;
        long val = 0L;
        for (String s : strVals) {
            long sect = StringUtils.str2Long(s);
            int bit = 8 * (sectLength - 1);
            val += sect << bit;
            --sectLength;
        }
        return val;
    }

    public static String long2ip(long val) {
        long s1 = val >> 24;
        long s2 = val >> 16 & 0xFFL;
        long s3 = val >> 8 & 0xFFL;
        long s4 = val & 0xFFL;
        return s1 + "." + s2 + "." + s3 + "." + s4;
    }

    public static String trimXml(String source) {
        int xmlBeginIndex = source.toLowerCase(Locale.ENGLISH).indexOf("<?xml version=\"1.0\" encoding=\"UTF-8\"?>".toLowerCase(Locale.ENGLISH));
        String tail = "</root>";
        int xmlEndIndex = source.indexOf(tail);
        if (xmlBeginIndex < 0 || xmlEndIndex < 0) {
            return EMPTY;
        }
        return source.substring(xmlBeginIndex, xmlEndIndex + tail.length());
    }

    public static String getNoStripUUID() {
        UUID uuid = UUID.randomUUID();
        String s = uuid.toString();
        return s.replaceAll("-", EMPTY);
    }

    public static String toString(Object obj) {
        if (null == obj) {
            return EMPTY;
        }
        return obj.toString();
    }

    public static boolean isPort(int port) {
        return port <= 65535;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getToolConfig(String key) {
        String workPath = ApplicationContext.getInstance().getWorkPath();
        int index = workPath.lastIndexOf(TOOLS_FOLDER);
        if (index != -1) {
            workPath = workPath.substring(0, index);
        }
        File file = new File(workPath + File.separator + "configuration/system.properties");
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
            Properties properties = new Properties();
            properties.load(is);
            String string = properties.getProperty(key);
            return string;
        }
        catch (FileNotFoundException e) {
            LoggerFactory.getLogger(StringUtils.class).error("system property file {} not found.", (Object)file.getName());
            return EMPTY;
        }
        catch (IOException e) {
            LoggerFactory.getLogger(StringUtils.class).error("load system property file error", e);
        }
        return EMPTY;
    }

    public static String wrapParagraph(String paragraph, String warpCode, int maxLength) {
        StringBuilder sb = new StringBuilder();
        if (Locale.ENGLISH.equals(LanguageManager.getInstance().getCurrentLanguage())) {
            StringTokenizer st = new StringTokenizer(paragraph);
            int wordCount = 0;
            while (st.hasMoreTokens()) {
                sb.append(st.nextToken());
                sb.append(BLANK);
                if (++wordCount == 0 || wordCount % maxLength != 0) continue;
                sb.append(warpCode);
            }
        } else {
            for (int wordCount = 0; wordCount < paragraph.length(); ++wordCount) {
                sb.append(paragraph.charAt(wordCount));
                if (wordCount == 0 || wordCount % maxLength != 0) continue;
                sb.append(warpCode);
            }
        }
        return sb.toString();
    }

    public static enum TimeAccurateLevel {
        SECOND,
        MS;

    }
}

