/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.File;
import java.io.IOException;

public class SystemConfigReader {
    private static final String RUNTIME_DATA_PATH = "app.user.data.path";
    private static final String RUNING_LOG_PATH = "app.log.path";
    private static final String RUNTIME_IS_UPGRADE_INSTALL = "app.upgredeinstall";
    private static final String WATCHDOG_ENABLE_KEY = "app.watchdog.enable";
    private static final String WATCHDOG_PATH = "app.watchdog.directory";

    public final boolean isWatchDogEnable() {
        String isEnableStr = ApplicationContext.getInstance().getAppConfig(WATCHDOG_ENABLE_KEY);
        if (StringUtils.isNULLStr(isEnableStr)) {
            return false;
        }
        return Boolean.valueOf(isEnableStr);
    }

    public final String getWatchDogPath() {
        String isEnableStr = ApplicationContext.getInstance().getAppConfig(WATCHDOG_PATH);
        if (isEnableStr == null) {
            return "";
        }
        return isEnableStr;
    }

    public final String getRuntimePath() {
        String runtimeDataPath = ApplicationContext.getInstance().getAppConfig(RUNTIME_DATA_PATH);
        if (StringUtils.isNULLStr(runtimeDataPath)) {
            return "";
        }
        File runtimeFile = FilePathUtils.checkFile((File)new File(runtimeDataPath));
        if (runtimeFile.exists() && !runtimeFile.isDirectory()) {
            return "";
        }
        if (!runtimeFile.exists() && !runtimeFile.mkdirs()) {
            return "";
        }
        try {
            return runtimeFile.getCanonicalPath();
        }
        catch (IOException e) {
            return "";
        }
    }

    public final String getRunningLogPath() {
        String runtimeDataPath = ApplicationContext.getInstance().getAppConfig(RUNING_LOG_PATH);
        if (StringUtils.isNULLStr(runtimeDataPath)) {
            return "";
        }
        File runtimeFile = FilePathUtils.checkFile((File)new File(runtimeDataPath));
        if (runtimeFile.exists() && !runtimeFile.isDirectory()) {
            return "";
        }
        if (!runtimeFile.exists() && !runtimeFile.mkdirs()) {
            return "";
        }
        try {
            return runtimeFile.getCanonicalPath();
        }
        catch (IOException e) {
            return "";
        }
    }

    public final boolean isSupportForUpdateInstall() {
        String isSupportStr = ApplicationContext.getInstance().getAppConfig(RUNTIME_IS_UPGRADE_INSTALL);
        if (StringUtils.isNULLStr(isSupportStr)) {
            return false;
        }
        return Boolean.valueOf(isSupportStr);
    }
}

