/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.utils;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.obase.constant.ToolConstants;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.dom4j.io.SAXReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class XmlUtils {
    public static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"utf-8\"?>";
    private static final XPath XPATH = XPathFactory.newInstance().newXPath();

    public static DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        return com.huawei.ism.tool.base.utils.XmlUtils.newDocumentBuilder();
    }

    public static SAXReader getSaxReader() throws SAXException {
        return com.huawei.ism.tool.base.utils.XmlUtils.getSaxReader();
    }

    public static synchronized Document parseDocument(InputStream input) {
        return com.huawei.ism.tool.base.utils.XmlUtils.parseDocument((InputStream)input);
    }

    public static synchronized Document parseDocumentNoPrintException(InputStream input) {
        return XmlUtils.parseDocument(input);
    }

    public static String getTextContentOfChild(Element parent, String childTagName) {
        if (null == parent) {
            return null;
        }
        String result = null;
        Node node = parent.getFirstChild();
        while (null != node) {
            if (!(node instanceof Element)) {
                node = node.getNextSibling();
                continue;
            }
            Element element = (Element)node;
            String tagName = element.getTagName();
            String content = element.getTextContent();
            if (childTagName.equals(tagName)) {
                result = content.trim();
                break;
            }
            node = node.getNextSibling();
        }
        return result;
    }

    public static Collection<Element> getChildren(Element parent, String childTagName) {
        ArrayList<Element> children = new ArrayList<Element>();
        if (null == parent) {
            return children;
        }
        for (Node child = parent.getFirstChild(); null != child; child = child.getNextSibling()) {
            if (!(child instanceof Element)) continue;
            Element element = (Element)child;
            String tagName = element.getTagName();
            if (null != childTagName && !childTagName.equals(tagName)) continue;
            children.add(element);
        }
        return children;
    }

    public static Element getChild(Element parent, String childTagName) {
        if (null == parent) {
            return null;
        }
        Element result = null;
        for (Node child = parent.getFirstChild(); null != child; child = child.getNextSibling()) {
            Element element;
            String tagName;
            if (!(child instanceof Element) || !(tagName = (element = (Element)child).getTagName()).equals(childTagName)) continue;
            result = element;
            break;
        }
        return result;
    }

    public static Collection<Element> getChildren(Element parent) {
        return XmlUtils.getChildren(parent, null);
    }

    public static String getAttribute(Element element, String attribute) {
        if (null == element) {
            return null;
        }
        String result = element.getAttribute(attribute);
        if (StringUtils.isNULLStr((String)result)) {
            return null;
        }
        return result.trim();
    }

    public static String getLocaleAttribute(Element element, String attribute) {
        if (null == element) {
            return null;
        }
        String result = element.getAttribute(attribute);
        if (StringUtils.isNULLStr((String)result)) {
            return null;
        }
        if ((result = result.trim()).indexOf("##") == -1) {
            return result;
        }
        String[] sp = result.split("##");
        if (ApplicationContext.getInstance().isEnglishEnv()) {
            return sp[1];
        }
        return sp[0];
    }

    public static NodeList searchNodeByExp(Document doc, String xql) {
        NodeList nodeList = null;
        try {
            Object obj = XPATH.evaluate(xql, doc, XPathConstants.NODESET);
            nodeList = (NodeList)obj;
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(XmlUtils.class).error("eval error," + xql, e);
        }
        return nodeList;
    }

    public static NodeList searchNodeByExpNoPrintException(Document doc, String xql) {
        NodeList nodeList = null;
        try {
            Object result = XPATH.evaluate(xql, doc, XPathConstants.NODESET);
            nodeList = (NodeList)result;
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(XmlUtils.class).error("search NodeBy error," + xql);
        }
        return nodeList;
    }

    public static Collection<Element> searchByExp2Ele(Node node, String xql) {
        ArrayList<Element> elements = new ArrayList<Element>();
        NodeList nodeList = null;
        try {
            Object result = XPATH.evaluate(xql, node, XPathConstants.NODESET);
            nodeList = (NodeList)result;
            for (int j = 0; j < nodeList.getLength(); ++j) {
                Node n = nodeList.item(j);
                if (!(node instanceof Element)) continue;
                elements.add((Element)n);
            }
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(XmlUtils.class).error("eval error," + xql, e);
        }
        return elements;
    }

    public static NodeList searchNodeByExp(Element element, String xql) {
        NodeList list = null;
        try {
            Object result = XPATH.evaluate(xql, element, XPathConstants.NODESET);
            list = (NodeList)result;
        }
        catch (Exception e) {
            ToolLoggerFactory.getLogger(XmlUtils.class).error("eval error," + xql, e);
        }
        return list;
    }

    public static Document createDomByXmlString(String str, String tagName) throws ToolException {
        int beginIndex = str.indexOf("<" + tagName + ">");
        int endIndex = str.indexOf("</" + tagName + ">");
        if (-1 == beginIndex || -1 == endIndex) {
            throw new ToolException("The result xml \"" + str + "\" parse error:");
        }
        String returnXml = str.substring(beginIndex, endIndex + ("</" + tagName + ">").length());
        if (!str.contains("<?xml")) {
            returnXml = XML_HEADER + ToolConstants.ENTER + returnXml;
        }
        ByteArrayInputStream is = new ByteArrayInputStream(returnXml.getBytes(Charset.forName("UTF-8")));
        return XmlUtils.parseDocument(is);
    }

    public static Element getRootElement(Document doc, String tag) {
        if (doc != null) {
            NodeList nodeList = doc.getElementsByTagName(tag);
            return (Element)nodeList.item(0);
        }
        return null;
    }

    private XmlUtils() {
    }
}

