/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.obase.xml;

import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import java.util.Locale;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.w3c.dom.Element;

public class XmlNode {
    private Element xmlConfigElement;

    public XmlNode(Element node) {
        this.xmlConfigElement = node;
    }

    public String getTagName() {
        return this.xmlConfigElement.getTagName();
    }

    public String getName() {
        return this.getAttribute("name");
    }

    public String getName(Locale local) {
        return this.getAttribute("name", local);
    }

    public String getID() {
        return this.getAttribute("id");
    }

    public String getDescription() {
        return this.getAttribute("description");
    }

    public String getDescription(Locale locale) {
        return this.getAttribute("description", locale);
    }

    public Element getElement() {
        return this.xmlConfigElement;
    }

    protected String getAttribute(String attributeName) {
        return XmlUtils.getAttribute(this.xmlConfigElement, attributeName);
    }

    protected String getAttribute(String attributeName, Locale locale) {
        String value = this.getAttribute(attributeName);
        if (-1 == value.indexOf("##")) {
            throw new IllegalArgumentException("The config \"" + value + "\" doesn't contain chinese and engilish language");
        }
        String[] languages = value.split("##");
        if (languages.length != 2) {
            throw new IllegalArgumentException("The config \"" + value + "\" is error.");
        }
        if (Locale.CHINESE.getLanguage().equals(locale.getLanguage())) {
            if (StringUtils.isChinese(languages[0])) {
                return languages[0];
            }
            return languages[1];
        }
        if (!StringUtils.isChinese(languages[1])) {
            return languages[1];
        }
        return languages[0];
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE).appendSuper(super.toString()).append((Object)("ID:" + this.getID())).append((Object)("Name:" + this.getName())).toString();
    }
}

