/*
 * Decompiled with CFR 0.152.
 */
package utils;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FilesUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilesUtil.class);

    private FilesUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File copyFile(File targetFile, String toPath) {
        File result;
        FileOutputStream nfout;
        FileInputStream tfin;
        FileChannel newChannel;
        FileChannel targetChannel;
        block15: {
            File file;
            block14: {
                if (null == targetFile) {
                    return null;
                }
                targetChannel = null;
                newChannel = null;
                tfin = null;
                nfout = null;
                result = null;
                try {
                    File copyToDir = new File(toPath);
                    if (!copyToDir.exists() && !copyToDir.mkdirs()) {
                        File file2 = null;
                        return file2;
                    }
                    String newFile = copyToDir + File.separator + targetFile.getName();
                    if (targetFile.isDirectory()) {
                        if (!new File(newFile).mkdirs()) {
                            file = null;
                            FilesUtil.closeChannel(targetChannel, newChannel);
                            break block14;
                        }
                    } else {
                        tfin = new FileInputStream(targetFile);
                        nfout = new FileOutputStream(newFile);
                        targetChannel = tfin.getChannel();
                        newChannel = nfout.getChannel();
                        newChannel.transferFrom(targetChannel, 0L, targetChannel.size());
                        result = new File(newFile);
                    }
                    FilesUtil.closeChannel(targetChannel, newChannel);
                    break block15;
                }
                catch (FileNotFoundException e) {
                    LOGGER.error("Exception:file {} not found.", (Object)targetFile.getName());
                    return result;
                }
                catch (IOException e) {
                    LOGGER.error("transfer data from ", targetFile, " fail.", e.getMessage());
                    return result;
                }
            }
            StreamUtils.closeStream((OutputStream)nfout, (InputStream)tfin);
            return file;
        }
        StreamUtils.closeStream((OutputStream)nfout, (InputStream)tfin);
        return result;
        finally {
            FilesUtil.closeChannel(targetChannel, newChannel);
            StreamUtils.closeStream(nfout, tfin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File copyFiles(File[] targetFiles, String toPath) {
        FileChannel targetChannel = null;
        FileChannel newChannel = null;
        FileInputStream tfin = null;
        FileOutputStream nfout = null;
        File result = null;
        try {
            FilesUtil.mkdirs(toPath);
            for (File file : targetFiles) {
                String newFilePath = toPath + File.separator + file.getName();
                if (file.isDirectory()) {
                    FilesUtil.mkdirs(newFilePath);
                    FilesUtil.copyFiles(file.listFiles(), newFilePath);
                } else {
                    tfin = new FileInputStream(file);
                    targetChannel = tfin.getChannel();
                    nfout = new FileOutputStream(newFilePath);
                    newChannel = nfout.getChannel();
                    newChannel.transferFrom(targetChannel, 0L, targetChannel.size());
                    result = new File(newFilePath);
                }
                StreamUtils.closeStream(nfout, (InputStream)tfin);
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.error("Exception file not found.");
        }
        catch (IOException e) {
            LOGGER.error("transfer data fail.", (Object)e.getMessage());
        }
        finally {
            FilesUtil.closeChannel(targetChannel, newChannel);
            StreamUtils.closeStream(nfout, tfin);
        }
        return result;
    }

    private static void closeChannel(FileChannel targetChannel, FileChannel newChannel) {
        try {
            if (targetChannel != null) {
                targetChannel.close();
            }
            if (newChannel != null) {
                newChannel.close();
            }
        }
        catch (IOException e) {
            LOGGER.error("IOException", e);
        }
    }

    public static void mkdirs(String path) {
        File copyToDir = new File(path);
        if (!copyToDir.exists() && !copyToDir.mkdirs() && LOGGER.isInfoEnabled()) {
            LOGGER.info("create dirs error: {}", (Object)copyToDir);
        }
    }

    public static void clearFolder(File files) {
        File[] tempFiles = files.listFiles();
        if (tempFiles == null) {
            return;
        }
        for (File file : tempFiles) {
            if (file.isDirectory()) {
                File[] listFiles = file.listFiles();
                if (null == listFiles) {
                    if (LOGGER.isInfoEnabled()) {
                        LOGGER.info("file in {} is null!", (Object)file);
                    }
                    return;
                }
                if (listFiles.length != 0) {
                    FilesUtil.clearFolder(file);
                }
                try {
                    if (listFiles.length != 0 || file.getCanonicalFile().delete() || !LOGGER.isInfoEnabled()) continue;
                    LOGGER.info("file delete error:{}", (Object)file);
                }
                catch (IOException e) {
                    if (!LOGGER.isInfoEnabled()) continue;
                    LOGGER.info(" getCanonicalFile error:{}", (Object)file);
                }
                continue;
            }
            if (file.delete() || !LOGGER.isInfoEnabled()) continue;
            LOGGER.info("file delete error: {}", (Object)file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(List<String> strs, String filePath, String targetFile) {
        if (!StringUtils.isNULLStr(filePath) && strs != null && !strs.isEmpty()) {
            try (PrintWriter pw = null;){
                File fileDir;
                String target = filePath + File.separator + targetFile;
                File rootPath = new File(filePath);
                if (!rootPath.exists()) {
                    rootPath.mkdirs();
                }
                if (!(fileDir = new File(filePath, targetFile)).exists()) {
                    fileDir.createNewFile();
                }
                pw = new PrintWriter(new FileWriter(target));
                for (String str : strs) {
                    if (StringUtils.isNULLStr(str)) continue;
                    pw.println(str);
                }
            }
        }
    }

    public static boolean checkNormalPath(String path) {
        if (null == path) {
            return false;
        }
        path = path.replaceAll("\\\\", "");
        path = path.replaceAll("/", "");
        path = path.replaceAll(":", "");
        if ((path = path.replaceAll("\\.", "")).contains("  ")) {
            return false;
        }
        return path.matches("[\\w ]+");
    }

    public static boolean checkPathIsNormal(String path) {
        String tempPath = path;
        if (tempPath == null) {
            return false;
        }
        tempPath = tempPath.replaceAll("\\\\", "");
        tempPath = tempPath.replaceAll("/", "");
        tempPath = tempPath.replaceAll(":", "");
        if ((tempPath = tempPath.replaceAll("\\.", "")).contains("  ")) {
            return false;
        }
        return tempPath.matches("[\\u4e00-\\u9fa5\\w ]+");
    }

    public static boolean checkBlankPath(String path) {
        return ApplicationContext.getInstance().isWindowsOS() || !path.contains(" ");
    }

    public static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            LOGGER.error("get canonical path error", e);
            return "";
        }
    }
}

