/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.log.dao;

import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.framework.pubservice.entity.OperaLog;
import com.huawei.ism.tool.log.dao.IOperationLogDAO;
import com.huawei.ism.tool.log.dao.OperaLogDAOFileSupport;
import com.huawei.ism.tool.log.entity.LogQueryCondition;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperaLogDAOFile
implements IOperationLogDAO {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperaLogDAOFile.class);
    private static final String LOGFILE_FULL_PATH = ApplicationContext.getInstance().getUserDataPath() + "operalog" + File.separator;
    private static final String LOGFILE_NAME = "operalog.log";
    private static final String LOGFILE_NAME_BACKUP = "operalog_backup.log";
    private static final int MAX_LOG_NUM = 3000;
    private static final String FIELD_DIVIDE = "#,#";
    private File logFile = null;
    private BufferedWriter writer = null;
    private FileOutputStream fos = null;
    private OutputStreamWriter osw = null;
    private int operaLogNum = 0;
    private List<OperaLog> allOperaLogs = null;
    private ExecutorService executor = Executors.newSingleThreadExecutor();

    public OperaLogDAOFile() {
        this.executor.execute(new OperaLogInitTask());
    }

    @Override
    public List<OperaLog> getAllOperationLogs() {
        Future<List<OperaLog>> future = this.executor.submit(new GainOperaLogTask());
        try {
            this.allOperaLogs = future.get();
            return this.allOperaLogs;
        }
        catch (Exception e) {
            LOGGER.error("getAllOperationLogs ERROR", (Throwable)e);
            return new LinkedList<OperaLog>();
        }
    }

    @Override
    public List<OperaLog> getOperationLogs(LogQueryCondition condition) {
        Future<List<OperaLog>> future = this.executor.submit(new QueryOperaLogTask(condition));
        try {
            return future.get();
        }
        catch (Exception e) {
            LOGGER.error("query opera log failed!!!!", (Throwable)e);
            return new ArrayList<OperaLog>();
        }
    }

    @Override
    public boolean saveOperationLog(OperaLog operaLog) {
        this.executor.execute(new OperaLogAddTask(operaLog.copy()));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveUpdateCheckerLog(OperaLog operaLog) {
        OutputStreamWriter out2Writer;
        FileOutputStream output;
        BufferedWriter bufWriter;
        File operlogNewFile;
        block6: {
            StringBuffer workPathBuf = new StringBuffer(ApplicationContext.getInstance().getWorkPath());
            workPathBuf.append(File.separator).append("data").append(File.separator).append("operalog");
            File operalogDir = new File(workPathBuf.toString());
            if (!operalogDir.exists() && !operalogDir.mkdirs()) {
                LOGGER.error("create dirctory exception, file => " + operalogDir.getPath());
                return false;
            }
            operlogNewFile = new File(operalogDir, LOGFILE_NAME);
            bufWriter = null;
            output = null;
            out2Writer = null;
            if (operlogNewFile.exists() || operlogNewFile.createNewFile()) break block6;
            LOGGER.error("create new File exception, file => " + operlogNewFile.getCanonicalPath());
            boolean bl = false;
            StreamUtils.closeResource(null, bufWriter);
            StreamUtils.closeResource(null, out2Writer);
            StreamUtils.closeStream(output, null);
            return bl;
        }
        try {
            OperaLogDAOFileSupport support = new OperaLogDAOFileSupport();
            String logString = support.operaLogToString(operaLog);
            output = new FileOutputStream(operlogNewFile, true);
            out2Writer = new OutputStreamWriter((OutputStream)output, Charset.forName("utf-8"));
            bufWriter = new BufferedWriter(out2Writer);
            bufWriter.write(logString);
            bufWriter.newLine();
            bufWriter.flush();
        }
        catch (IOException e) {
            boolean bl;
            try {
                LOGGER.error("write File exception", (Throwable)e);
                bl = false;
            }
            catch (Throwable throwable) {
                StreamUtils.closeResource(null, bufWriter);
                StreamUtils.closeResource(null, out2Writer);
                StreamUtils.closeStream(output, null);
                throw throwable;
            }
            StreamUtils.closeResource(null, bufWriter);
            StreamUtils.closeResource(null, out2Writer);
            StreamUtils.closeStream(output, null);
            return bl;
        }
        StreamUtils.closeResource(null, bufWriter);
        StreamUtils.closeResource(null, out2Writer);
        StreamUtils.closeStream(output, null);
        return true;
    }

    @Override
    public void clearEnv() {
        this.executor.execute(new ClearEnvTask());
    }

    private boolean retrieveLogFile() {
        try {
            this.logFile = new File(LOGFILE_FULL_PATH + LOGFILE_NAME);
            if (this.logFile.isDirectory() && !this.logFile.delete()) {
                LOGGER.error("the logFile is a Directory and it cannot be deleted,you must be kidding me..");
                return false;
            }
            if (!this.logFile.exists()) {
                FileUtils.createDir(this.logFile.getParentFile());
                boolean result = this.logFile.createNewFile();
                if (!result) {
                    return false;
                }
            } else if (!this.backupFiles()) {
                return false;
            }
            this.fos = new FileOutputStream(this.logFile, true);
            this.osw = new OutputStreamWriter((OutputStream)this.fos, Charset.forName("utf-8"));
            this.writer = new BufferedWriter(this.osw);
            return true;
        }
        catch (IOException e) {
            LOGGER.error("create operation log File error!!!", (Throwable)e);
            return false;
        }
        catch (Exception e) {
            LOGGER.error("runtime error !!", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean checkOldVersionLog() {
        block8: {
            if (!this.logFile.exists()) break block8;
            InputStreamReader fileIn = null;
            BufferedReader reader = null;
            FileInputStream fileInputStream = null;
            String stringLine = "";
            try {
                fileInputStream = new FileInputStream(this.logFile);
                fileIn = new InputStreamReader((InputStream)fileInputStream, Charset.forName("utf-8"));
                reader = new BufferedReader(fileIn);
                stringLine = reader.readLine();
                stringLine = AESEncrypt.decrypt(stringLine);
            }
            catch (FileNotFoundException e) {
                LOGGER.info("filereader file error, file {} not found.", (Object)this.logFile.getName());
                boolean bl = false;
                StreamUtils.closeResource(null, reader);
                StreamUtils.closeResource(null, fileIn);
                StreamUtils.closeResource(null, fileInputStream);
                return bl;
            }
            catch (IOException e2) {
                LOGGER.info("read file line error:", (Throwable)e2);
                boolean bl = false;
                {
                    catch (Throwable throwable) {
                        StreamUtils.closeResource(null, reader);
                        StreamUtils.closeResource(null, fileIn);
                        StreamUtils.closeResource(null, fileInputStream);
                        throw throwable;
                    }
                }
                StreamUtils.closeResource(null, reader);
                StreamUtils.closeResource(null, fileIn);
                StreamUtils.closeResource(null, fileInputStream);
                return bl;
            }
            StreamUtils.closeResource(null, reader);
            StreamUtils.closeResource(null, fileIn);
            StreamUtils.closeResource(null, fileInputStream);
            if (StringUtils.isNULLStr(stringLine)) {
                return false;
            }
            String[] strs = stringLine.split(FIELD_DIVIDE, -1);
            if (strs.length != 11) {
                return false;
            }
        }
        return true;
    }

    private boolean backupFiles() throws IOException {
        if (!this.checkOldVersionLog()) {
            String backupFileName = LOGFILE_FULL_PATH + LOGFILE_NAME_BACKUP;
            File backupFile = new File(backupFileName);
            if (backupFile.exists()) {
                return this.copyBackuoFile();
            }
            this.clearWriter();
            if (!this.logFile.renameTo(backupFile)) {
                return false;
            }
            this.operaLogNum = 0;
            if (!this.retrieveLogFile()) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copyBackuoFile() throws IOException {
        String logString = null;
        BufferedReader reader = null;
        InputStreamReader in = null;
        OutputStreamWriter out = null;
        FileInputStream fileIn = null;
        FileOutputStream fileOut = null;
        try {
            fileIn = new FileInputStream(this.logFile);
            in = new InputStreamReader((InputStream)fileIn, Charset.forName("utf-8"));
            reader = new BufferedReader(in);
            fileOut = new FileOutputStream(LOGFILE_FULL_PATH + LOGFILE_NAME_BACKUP, true);
            out = new OutputStreamWriter((OutputStream)fileOut, Charset.forName("utf-8"));
            this.writer = new BufferedWriter(out);
            while ((logString = reader.readLine()) != null) {
                this.writer.write(logString);
                this.writer.newLine();
            }
        }
        catch (IOException e) {
            boolean bl;
            try {
                LOGGER.error("copy file error!", (Throwable)e);
                bl = false;
            }
            catch (Throwable throwable) {
                StreamUtils.closeResource(null, reader);
                StreamUtils.closeResource(null, in);
                StreamUtils.closeResource(null, fileIn);
                this.clearWriter();
                StreamUtils.closeResource(out, null);
                StreamUtils.closeResource(fileOut, null);
                throw throwable;
            }
            StreamUtils.closeResource(null, reader);
            StreamUtils.closeResource(null, in);
            StreamUtils.closeResource(null, fileIn);
            this.clearWriter();
            StreamUtils.closeResource(out, null);
            StreamUtils.closeResource(fileOut, null);
            return bl;
        }
        StreamUtils.closeResource(null, reader);
        StreamUtils.closeResource(null, in);
        StreamUtils.closeResource(null, fileIn);
        this.clearWriter();
        StreamUtils.closeResource(out, null);
        StreamUtils.closeResource(fileOut, null);
        return this.creatNewFile();
    }

    private boolean creatNewFile() {
        boolean delete = this.logFile.delete();
        LOGGER.error("delete file style:" + delete);
        this.operaLogNum = 0;
        return this.retrieveLogFile();
    }

    private void closeStream(Closeable stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            LOGGER.error("file close error!!!", (Throwable)e);
        }
    }

    private void clearWriter() {
        this.flushWriter();
        if (this.writer != null) {
            try {
                this.writer.close();
                this.writer = null;
            }
            catch (IOException e) {
                LOGGER.error("log File writer close failed , because of IO");
                this.writer = null;
            }
        }
    }

    private void flushWriter() {
        if (this.writer != null) {
            try {
                this.writer.flush();
            }
            catch (IOException e) {
                LOGGER.error("flush File writer failed , because of IO");
                this.writer = null;
            }
        }
    }

    private class OperaLogInitTask
    implements Runnable {
        private OperaLogInitTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            block8: {
                if (!OperaLogDAOFile.this.retrieveLogFile()) {
                    return;
                }
                if (!OperaLogDAOFile.this.logFile.exists()) break block8;
                int num = 0;
                BufferedReader reader = null;
                InputStreamReader fileIn = null;
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(OperaLogDAOFile.this.logFile);
                    fileIn = new InputStreamReader((InputStream)fileInputStream, Charset.forName("utf-8"));
                    reader = new BufferedReader(fileIn);
                    String lineStr = reader.readLine();
                    while (lineStr != null) {
                        ++num;
                        lineStr = reader.readLine();
                    }
                }
                catch (IOException e) {
                    LOGGER.error("gain num error", (Throwable)e);
                    OperaLogDAOFile.this.closeStream(reader);
                    StreamUtils.closeResource(null, fileIn);
                    StreamUtils.closeResource(null, fileInputStream);
                }
                catch (Exception e2) {
                    LOGGER.error("gain num error", (Throwable)e2);
                    {
                        catch (Throwable throwable) {
                            OperaLogDAOFile.this.closeStream(reader);
                            StreamUtils.closeResource(null, fileIn);
                            StreamUtils.closeResource(null, fileInputStream);
                            throw throwable;
                        }
                    }
                    OperaLogDAOFile.this.closeStream(reader);
                    StreamUtils.closeResource(null, fileIn);
                    StreamUtils.closeResource(null, fileInputStream);
                }
                OperaLogDAOFile.this.closeStream(reader);
                StreamUtils.closeResource(null, fileIn);
                StreamUtils.closeResource(null, fileInputStream);
                OperaLogDAOFile.this.operaLogNum = num;
            }
        }
    }

    private class ClearEnvTask
    implements Runnable {
        private ClearEnvTask() {
        }

        @Override
        public void run() {
            OperaLogDAOFile.this.logFile = null;
            OperaLogDAOFile.this.clearWriter();
            StreamUtils.closeResource(null, OperaLogDAOFile.this.osw);
            StreamUtils.closeResource(null, OperaLogDAOFile.this.fos);
            OperaLogDAOFile.this.executor.shutdown();
            OperaLogDAOFile.this.executor = null;
        }
    }

    private class OperaLogAddTask
    implements Runnable {
        private OperaLog log = null;

        public OperaLogAddTask(OperaLog log) {
            this.log = log;
        }

        @Override
        public void run() {
            boolean result;
            OperaLogDAOFileSupport support = new OperaLogDAOFileSupport();
            String logString = support.operaLogToString(this.log);
            if (OperaLogDAOFile.this.operaLogNum >= 3000 && !(result = this.brandNewLogFile())) {
                LOGGER.error("backup the operalog file error!!!!");
                return;
            }
            try {
                if (null == OperaLogDAOFile.this.writer) {
                    OperaLogDAOFile.this.fos = new FileOutputStream(OperaLogDAOFile.this.logFile, true);
                    OperaLogDAOFile.this.osw = new OutputStreamWriter((OutputStream)OperaLogDAOFile.this.fos, Charset.forName("utf-8"));
                    OperaLogDAOFile.this.writer = new BufferedWriter(OperaLogDAOFile.this.osw);
                }
                OperaLogDAOFile.this.writer.write(logString);
                OperaLogDAOFile.this.writer.newLine();
                OperaLogDAOFile.this.operaLogNum++;
            }
            catch (IOException e) {
                LOGGER.error("add opera log failed!!!!", (Throwable)e);
            }
        }

        private boolean brandNewLogFile() {
            String backupFileName = LOGFILE_FULL_PATH + OperaLogDAOFile.LOGFILE_NAME_BACKUP;
            File backupFile = new File(backupFileName);
            if (backupFile.exists() && !backupFile.delete()) {
                return false;
            }
            OperaLogDAOFile.this.clearWriter();
            if (!OperaLogDAOFile.this.logFile.renameTo(backupFile)) {
                return false;
            }
            OperaLogDAOFile.this.operaLogNum = 0;
            return OperaLogDAOFile.this.retrieveLogFile();
        }
    }

    private class QueryOperaLogTask
    implements Callable<List<OperaLog>> {
        private LogQueryCondition condition = null;

        public QueryOperaLogTask(LogQueryCondition condition) {
            this.condition = condition;
        }

        @Override
        public List<OperaLog> call() {
            LinkedList<OperaLog> queryResultLogs = new LinkedList<OperaLog>();
            Iterator iterator = OperaLogDAOFile.this.allOperaLogs.iterator();
            OperaLog currentLog = null;
            OperaLogDAOFileSupport support = new OperaLogDAOFileSupport();
            while (iterator.hasNext()) {
                currentLog = (OperaLog)iterator.next();
                if (!support.isSuit(currentLog, this.condition)) continue;
                queryResultLogs.add(currentLog);
            }
            return queryResultLogs;
        }
    }

    private class GainOperaLogTask
    implements Callable<List<OperaLog>> {
        private GainOperaLogTask() {
        }

        @Override
        public List<OperaLog> call() {
            OperaLogDAOFile.this.flushWriter();
            LinkedList<OperaLog> operaLogs = new LinkedList<OperaLog>();
            OperaLogDAOFileSupport support = new OperaLogDAOFileSupport();
            int index = this.readLogFile(support, operaLogs);
            if (index >= 3000) {
                return operaLogs;
            }
            this.readBackupFile(support, operaLogs, index);
            return operaLogs;
        }

        /*
         * Exception decompiling
         */
        private void readBackupFile(OperaLogDAOFileSupport support, List<OperaLog> operaLogs, int index) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        private int readLogFile(OperaLogDAOFileSupport support, List<OperaLog> operaLogs) {
            FileInputStream fileInputStream;
            InputStreamReader inputStreamReader;
            BufferedReader reader;
            int index;
            block7: {
                int n;
                index = 0;
                reader = null;
                inputStreamReader = null;
                fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(OperaLogDAOFile.this.logFile);
                    inputStreamReader = new InputStreamReader((InputStream)fileInputStream, Charset.forName("utf-8"));
                    reader = new BufferedReader(inputStreamReader);
                    String logString = null;
                    OperaLog currentLog = null;
                    while ((logString = reader.readLine()) != null) {
                        if (StringUtils.isNULLStr(logString) || (currentLog = support.stringToOperaLog(logString)) == null) continue;
                        operaLogs.add(0, currentLog);
                        ++index;
                    }
                    if (index < 3000) break block7;
                    n = index;
                }
                catch (IllegalCharsetNameException e) {
                    LOGGER.error("GainOperaLogTask ERROR!!!!", (Throwable)e);
                    operaLogs.clear();
                    int n2 = 3000;
                    OperaLogDAOFile.this.closeStream(reader);
                    StreamUtils.closeResource(null, inputStreamReader);
                    StreamUtils.closeResource(null, fileInputStream);
                    return n2;
                }
                catch (Exception e2) {
                    LOGGER.error("GainOperaLogTask ERROR!!!!", (Throwable)e2);
                    operaLogs.clear();
                    int n3 = 3000;
                    {
                        catch (Throwable throwable) {
                            OperaLogDAOFile.this.closeStream(reader);
                            StreamUtils.closeResource(null, inputStreamReader);
                            StreamUtils.closeResource(null, fileInputStream);
                            throw throwable;
                        }
                    }
                    OperaLogDAOFile.this.closeStream(reader);
                    StreamUtils.closeResource(null, inputStreamReader);
                    StreamUtils.closeResource(null, fileInputStream);
                    return n3;
                }
                OperaLogDAOFile.this.closeStream(reader);
                StreamUtils.closeResource(null, inputStreamReader);
                StreamUtils.closeResource(null, fileInputStream);
                return n;
            }
            OperaLogDAOFile.this.closeStream(reader);
            StreamUtils.closeResource(null, inputStreamReader);
            StreamUtils.closeResource(null, fileInputStream);
            return index;
        }
    }
}

