/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.log.dao;

import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.framework.pubservice.entity.OperaLog;
import com.huawei.ism.tool.log.entity.LogQueryCondition;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperaLogDAOFileSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperaLogDAOFileSupport.class);
    private static final String FIELD_DIVIDE = "#,#";
    private static final Map<String, String> LOG_MAP = Collections.synchronizedMap(new LinkedHashMap());
    private static final int LOG_BUFFER_LEN = 1000;

    public String operaLogToString(OperaLog log) {
        StringBuffer logString = new StringBuffer();
        logString.append(log.getOperaName()).append(FIELD_DIVIDE).append(log.getOperateType()).append(FIELD_DIVIDE).append(log.getLevel().ordinal()).append(FIELD_DIVIDE).append(log.getOperateDate().getTime()).append(FIELD_DIVIDE).append(log.getDeviceName()).append(FIELD_DIVIDE).append(log.isResult()).append(FIELD_DIVIDE).append(log.getUserName()).append(FIELD_DIVIDE).append(log.getResultView()).append(FIELD_DIVIDE).append(log.isResultHasReport()).append(FIELD_DIVIDE).append(log.getDeviceNameEn()).append(FIELD_DIVIDE).append(log.getDetailInfo());
        return AESEncrypt.encrypt(logString.toString());
    }

    public boolean isSuit(OperaLog log, LogQueryCondition condition) {
        if (condition.isResult() != null && log.isResult() != condition.isResultCache()) {
            return false;
        }
        if (condition.getStartDate() != null && log.getOperateDate().getTime() < condition.getStartDate().getTime()) {
            return false;
        }
        if (condition.getEndDate() != null && log.getOperateDate().getTime() > condition.getEndDate().getTime()) {
            return false;
        }
        return StringUtils.isNULLStr(condition.getType()) || condition.getType().equals(ResourceUtil.getString(log.getOperateType()));
    }

    public OperaLog stringToOperaLog(String logString) {
        if (LOG_MAP.containsKey(logString)) {
            logString = LOG_MAP.get(logString);
        } else {
            String logValue = AESEncrypt.decrypt(logString);
            if (LOG_MAP.size() <= 1000) {
                LOG_MAP.put(logString, logValue);
            }
            logString = logValue;
        }
        String[] logFields = logString.split(FIELD_DIVIDE, -1);
        int size = logFields.length;
        if (!this.checkLogString(logFields)) {
            return null;
        }
        try {
            int num = 0;
            OperaLog log = new OperaLog();
            log.setOperaName(logFields[num++]);
            log.setOperateType(logFields[num++]);
            log.setLevel(this.getOperaLevel(Integer.parseInt(logFields[num++])));
            log.setOperateDate(new Date(Long.parseLong(logFields[num++])));
            log.setDeviceName(logFields[num++]);
            log.setResult(Boolean.parseBoolean(logFields[num++]));
            log.setUserName(logFields[num++]);
            log.setResultView(logFields[num++]);
            log.setResultHasReport(Boolean.parseBoolean(logFields[num++]));
            log.setDeviceNameEn(logFields[num++]);
            if (num < size) {
                log.setDetailInfo(logFields[num]);
            }
            return log;
        }
        catch (Exception e) {
            LOGGER.error("construct OperaLog Error!!!!", (Throwable)e);
            return null;
        }
    }

    private boolean checkLogString(String[] logFields) {
        if (logFields.length >= 2 && (StringUtils.isNULLStr(logFields[0]) || StringUtils.isNULLStr(logFields[1]))) {
            return false;
        }
        int len = logFields.length;
        return len == 11 || len == 10 || len == 9;
    }

    private OperaLog.OperaLevel getOperaLevel(int value) {
        OperaLog.OperaLevel[] levels;
        for (OperaLog.OperaLevel level : levels = OperaLog.OperaLevel.values()) {
            if (level.ordinal() != value) continue;
            return level;
        }
        return OperaLog.OperaLevel.COMM;
    }
}

