/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.log.service;

import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.log.entity.DebugLog;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.ZipUtils;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Set;

public class ExportDebugLogService {
    public TaskResult exportDebugLog(Set<DebugLog> debugLogs, String exportPath) {
        TaskResult result = new TaskResult();
        result.setResult(TaskResult.Result.SUCCESS);
        String name = "exporLog" + StringUtils.formatDate(new Date(), "yyyyMMddHHmmss");
        String exportLogPathTmp = "";
        try {
            exportLogPathTmp = new File(new File(ApplicationContext.getInstance().getTmpPath()), name).getCanonicalPath();
        }
        catch (IOException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("get path failed.", (Throwable)e);
        }
        for (DebugLog debugLog2 : debugLogs) {
            this.copyDebugLog(exportLogPathTmp, debugLog2);
        }
        File exportFile = new File(exportPath);
        if (!exportFile.getParentFile().exists()) {
            ToolLoggerFactory.getLogger(this.getClass()).info("creat exportPath's parent file dir");
            if (!exportFile.getParentFile().mkdirs()) {
                ToolLoggerFactory.getLogger(this.getClass()).warn("make dir failed");
                result.setResult(TaskResult.Result.FAILED);
                return result;
            }
        }
        File logFile = new File(exportPath);
        if (!ZipUtils.compressFile(exportPath, exportLogPathTmp) || logFile.exists() && logFile.length() == 0L) {
            com.huawei.ism.tool.obase.utils.FileUtils.deleteFile(logFile);
            ToolLoggerFactory.getLogger(this.getClass()).info("export debug log fail");
            result.setResult(TaskResult.Result.FAILED);
            return result;
        }
        com.huawei.ism.tool.obase.utils.FileUtils.deleteAllInFolder(exportLogPathTmp);
        com.huawei.ism.tool.obase.utils.FileUtils.deleteFile(new File(exportLogPathTmp));
        FileUtils.setFilePermissions(exportPath);
        return result;
    }

    private void copyDebugLog(String exportLogPathTmp, DebugLog debugLog2) {
        if ("Toolkit".equals(debugLog2.getType()) && new File(debugLog2.getLogPath()).exists()) {
            try {
                com.huawei.ism.tool.obase.utils.FileUtils.copyDir(debugLog2.getLogPath(), new File(exportLogPathTmp, debugLog2.getType()).getCanonicalPath());
            }
            catch (IOException e) {
                ToolLoggerFactory.getLogger(this.getClass()).info("get path fail.", (Throwable)e);
            }
        }
        if (!"Toolkit".equals(debugLog2.getType())) {
            File logOldFile = new File(debugLog2.getLogOldPath());
            File logFile = new File(debugLog2.getLogPath());
            String debugLog = "";
            String debugLogLog = "";
            String debugLogOldLog = "";
            try {
                debugLog = new File(exportLogPathTmp, debugLog2.getType()).getCanonicalPath();
                debugLogLog = new File(exportLogPathTmp + File.separator + debugLog2.getType(), "log").getCanonicalPath();
                debugLogOldLog = new File(exportLogPathTmp + File.separator + debugLog2.getType(), "log_old").getCanonicalPath();
            }
            catch (IOException e) {
                ToolLoggerFactory.getLogger(this.getClass()).info("get path fail.", (Throwable)e);
            }
            if (logOldFile.exists() && logFile.exists()) {
                com.huawei.ism.tool.obase.utils.FileUtils.copyDir(debugLog2.getLogPath(), debugLogLog);
                com.huawei.ism.tool.obase.utils.FileUtils.copyDir(debugLog2.getLogOldPath(), debugLogOldLog);
            } else if (logOldFile.exists()) {
                com.huawei.ism.tool.obase.utils.FileUtils.copyDir(debugLog2.getLogOldPath(), debugLog);
            } else if (logFile.exists()) {
                com.huawei.ism.tool.obase.utils.FileUtils.copyDir(debugLog2.getLogPath(), debugLog);
            }
        }
    }
}

