/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.log.service;

import com.huawei.ism.tool.log.entity.DebugLog;
import com.huawei.ism.tool.log.service.ExportDebugLogService;
import com.huawei.ism.tool.obase.taskexecutor.ServiceTask;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import java.io.File;
import java.util.Set;

public class ExportDebugTask
extends ServiceTask {
    private Set<DebugLog> exportDebugLog;
    private String exportPath;

    public ExportDebugTask(Set<DebugLog> exportDebugLog, String exportPath) {
        this.exportDebugLog = exportDebugLog;
        this.exportPath = exportPath;
    }

    public Set<DebugLog> getExportDebugLog() {
        return this.exportDebugLog;
    }

    public void setExportDebugLog(Set<DebugLog> exportDebugLog) {
        this.exportDebugLog = exportDebugLog;
    }

    public String getExportPath() {
        return this.exportPath;
    }

    public void setExportPath(String exportPath) {
        this.exportPath = exportPath;
    }

    @Override
    protected TaskResult doTask() {
        this.initLogPathAndModifyTime(this.exportDebugLog);
        ExportDebugLogService exportDebugLogService = new ExportDebugLogService();
        return exportDebugLogService.exportDebugLog(this.exportDebugLog, this.exportPath);
    }

    private void initLogPathAndModifyTime(Set<DebugLog> exportDebugLog2) {
        for (DebugLog debugLog : exportDebugLog2) {
            String logPath = this.getLogPath(debugLog);
            String oldLogPath = this.getOldLogPath(debugLog);
            debugLog.setLogPath(logPath);
            debugLog.setLogOldPath(oldLogPath);
        }
    }

    private String getLogPath(DebugLog debugLog) {
        if ("Toolkit".equals(debugLog.getType())) {
            return ApplicationContext.getInstance().getRunnigLogPath() + File.separator + "log";
        }
        return new StringBuffer().append(ApplicationContext.getInstance().getRunnigLogPath()).append(File.separator).append("tools").append(File.separator).append(debugLog.getType()).append(File.separator).append("log").toString();
    }

    private String getOldLogPath(DebugLog debugLog) {
        if ("Toolkit".equals(debugLog.getType())) {
            return "";
        }
        return new StringBuffer().append(ApplicationContext.getInstance().getRunnigLogPath()).append(File.separator).append("tools").append(File.separator).append(debugLog.getType()).append(File.separator).append("log_old").toString();
    }
}

