/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.log.service;

import com.huawei.ism.tool.framework.pubservice.entity.OperaLog;
import com.huawei.ism.tool.framework.pubui.PublicUiManage;
import com.huawei.ism.tool.framework.pubui.common.IToolBoxUI;
import com.huawei.ism.tool.log.dao.IOperationLogDAO;
import com.huawei.ism.tool.log.dao.OperaLogDAOFile;
import com.huawei.ism.tool.log.entity.LogQueryCondition;
import com.huawei.ism.tool.log.service.ExportLogFileWriter;
import com.huawei.ism.tool.log.service.IOperaLogService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperaLogService
implements IOperaLogService {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperaLogService.class);
    private static final OperaLogService INSTANCE = new OperaLogService();
    private IOperationLogDAO operaLogDAO = new OperaLogDAOFile();

    private OperaLogService() {
    }

    public static OperaLogService getInstance() {
        return INSTANCE;
    }

    @Override
    public void addOperaLog(OperaLog log) {
        if (log == null || !log.isValid()) {
            throw new IllegalArgumentException();
        }
        IToolBoxUI toolBoxUI = PublicUiManage.getInstance().getUi(IToolBoxUI.class);
        if (null == toolBoxUI) {
            this.operaLogDAO.saveUpdateCheckerLog(log);
            return;
        }
        this.operaLogDAO.saveOperationLog(log);
    }

    @Override
    public List<OperaLog> getAllOperaLogs() {
        return this.operaLogDAO.getAllOperationLogs();
    }

    @Override
    public List<OperaLog> queryOperaLogs(LogQueryCondition condition) {
        return this.operaLogDAO.getOperationLogs(condition);
    }

    @Override
    public boolean exportOperaLog(String fileName, List<OperaLog> logs) {
        if (null == logs || logs.isEmpty()) {
            return true;
        }
        ExportLogFileWriter writer = new ExportLogFileWriter();
        writer.setLogs(logs);
        try {
            return writer.exportOperaFile(fileName);
        }
        catch (Exception e) {
            LOGGER.error("export operaFile error!!", (Throwable)e);
            return false;
        }
    }

    @Override
    public void clearEnv() {
        this.operaLogDAO.clearEnv();
    }
}

