/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.log.ui;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.framework.pubservice.PublicServiceManage;
import com.huawei.ism.tool.framework.pubservice.common.ILogSupportService;
import com.huawei.ism.tool.framework.pubservice.entity.OperaLog;
import com.huawei.ism.tool.log.service.OperaLogService;
import com.huawei.ism.tool.log.service.RefreshOperaLogTask;
import com.huawei.ism.tool.log.ui.LogDatailDialog;
import com.huawei.ism.tool.log.ui.OperaLogPanel;
import com.huawei.ism.tool.log.ui.QueryOperaLogDialog;
import com.huawei.ism.tool.log.util.DateFormatUtil;
import com.huawei.ism.tool.log.util.OperaLogParser;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.taskexecutor.ServiceTaskExecutor;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class OperaLogMainPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String EXPORT_FILE_PATH_ID = "com.huawei.ism.tool.log.ui.OperaLogMainDialog";
    private OperaLogPanel logPanel = null;
    private transient DateFormatUtil formatUtil = new DateFormatUtil();
    private transient OperaLogParser parser = new OperaLogParser();
    private JDialog parentDialog = null;
    private QueryOperaLogDialog queryDialog = null;

    public OperaLogMainPanel(JDialog parent) {
        this.parentDialog = parent;
        this.queryDialog = new QueryOperaLogDialog(this);
        this.initUI();
        this.addListener();
        this.refreshDataWithProgressDialog(this.parentDialog);
    }

    private void initUI() {
        this.logPanel = new OperaLogPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)UiMethod.buildFrameSpace(this.logPanel, 10), "Center");
    }

    public void refreshDataWithProgressDialog(Window parent) {
        ProgressDialog progressDialog = new ProgressDialog(parent, ResourceUtil.getString("operalog.loading"));
        ServiceTaskExecutor taskExecutor = new ServiceTaskExecutor(progressDialog);
        TaskResult taskResult = taskExecutor.execute(new RefreshOperaLogTask());
        if (TaskResult.Result.SUCCESS.equals((Object)taskResult.getResult())) {
            List operaLogs = (List)taskResult.getResultObject();
            this.refleshLogs(operaLogs);
        }
    }

    public void initData() {
        OperaLogService service = OperaLogService.getInstance();
        List<OperaLog> operaLogs = service.getAllOperaLogs();
        this.refleshLogs(operaLogs);
    }

    public final void refleshLogs(List<OperaLog> operaLogs) {
        this.logPanel.getOperaLogTableModel().removeAll();
        for (OperaLog currentLog : operaLogs) {
            this.logPanel.getOperaLogTableModel().addRow(this.constructRow(currentLog));
        }
    }

    private TableRow constructRow(OperaLog operaLog) {
        boolean isIp;
        DefaultTableRow row = new DefaultTableRow(7, operaLog);
        row.setValueAt(0, ResourceUtil.getString(operaLog.getOperaName()));
        row.setValueAt(1, this.formatUtil.getDateString(operaLog.getOperateDate()));
        row.setValueAt(2, ResourceUtil.getString(operaLog.getOperateType()));
        Locale locale = LanguageManager.getInstance().getCurrentLanguage();
        String ip = operaLog.getDeviceName();
        boolean bl = isIp = StringUtils.isFullIpAddress(ip) || StringUtils.isIpv6Address(ip);
        if (isIp) {
            row.setValueAt(3, ip);
            operaLog.setDeviceNameEn(ip);
        } else if ("zh".equalsIgnoreCase(locale.getLanguage())) {
            row.setValueAt(3, operaLog.getDeviceName());
        } else {
            row.setValueAt(3, operaLog.getDeviceNameEn());
        }
        row.setValueAt(4, this.parser.getResultString(operaLog.isResult()));
        String userName = operaLog.getUserName();
        if (StringUtils.isNULLStr(userName)) {
            row.setValueAt(5, "--");
        } else {
            row.setValueAt(5, userName);
        }
        String detailInfo = operaLog.getDetailInfo();
        if (StringUtils.isNULLStr(detailInfo)) {
            row.setValueAt(6, new IsmTableCell.HyperlinkCell(ResourceUtil.getString("detailInfo.none")));
        } else {
            String detailInfoName = ResourceUtil.getString("detailInfo.name");
            IsmTableCell.HyperlinkCell hyperLinkOpen = new IsmTableCell.HyperlinkCell(detailInfoName, new DetailListener(operaLog));
            row.setValueAt(6, hyperLinkOpen);
        }
        return row;
    }

    private void addListener() {
        JButton searchBtn = this.logPanel.getSearchButton();
        searchBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OperaLogMainPanel.this.queryDialog.initData();
                OperaLogMainPanel.this.queryDialog.setVisible(true);
            }
        });
        JButton exBtn = this.logPanel.getExportButton();
        exBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (OperaLogMainPanel.this.logPanel.getOperaLogTable().getRowCount() == 0) {
                    DialogUtils.showInfoDialog(OperaLogMainPanel.this.parentDialog, ResourceUtil.getString("operalog.export.log.empty"));
                    return;
                }
                String exportFileTitle = ResourceUtil.getString("operalog.export.dialog.title");
                String exportFileName = "operalog";
                String path = ToolFileChooser.getSaveFilePath(exportFileTitle, "xls", (Window)OperaLogMainPanel.this.parentDialog, exportFileName, OperaLogMainPanel.EXPORT_FILE_PATH_ID, 0);
                if (path == null) {
                    return;
                }
                ArrayList<OperaLog> openaLogList = new ArrayList<OperaLog>();
                for (TableRow row : OperaLogMainPanel.this.logPanel.getOperaLogTableModel().getAllRows()) {
                    OperaLog openaLog = (OperaLog)row.getIdentifier();
                    if (null == openaLog || !OperaLogMainPanel.this.checkContainText(row, OperaLogMainPanel.this.logPanel.getTableScrollPanel().getFilterFiled().getKeyword())) continue;
                    openaLogList.add(openaLog);
                }
                List<?> ret = AsyncExcutor.execute((Window)OperaLogMainPanel.this.parentDialog, new ExportOperaLogCallable(path, openaLogList));
                OperaLogMainPanel.this.addOperaLog((Boolean)ret.get(0));
                if (!((Boolean)ret.get(0)).booleanValue()) {
                    com.huawei.ism.tool.obase.utils.FileUtils.deleteFile(new File(path));
                    DialogUtils.showInfoDialog(OperaLogMainPanel.this.parentDialog, ResourceUtil.getString("operalog.export.error"));
                } else {
                    DialogUtils.showInfoDialog(OperaLogMainPanel.this.parentDialog, ResourceUtil.getString("operalog.export.success"));
                }
            }
        });
    }

    private boolean checkContainText(TableRow row, String subjectText) {
        if (null == row) {
            return false;
        }
        if (null == subjectText || "".equals(subjectText)) {
            return true;
        }
        for (int i = 0; i < row.getColumnCount(); ++i) {
            if (null == row.getValueAt(i) || !String.valueOf(row.getValueAt(i)).toUpperCase(Locale.ENGLISH).contains(subjectText.toUpperCase(Locale.ENGLISH))) continue;
            return true;
        }
        return false;
    }

    private void addOperaLog(boolean succeed) {
        OperaLog log = new OperaLog();
        log.setUserName(ApplicationContext.getInstance().getCurToolkitUser());
        log.setDeviceName("Smartkit");
        log.setDeviceNameEn("Smartkit");
        log.setOperateType("operalog.type.system");
        log.setOperaName("operalog.export.dialog.title");
        log.setResult(succeed);
        log.setDetailInfo("");
        ILogSupportService logService = PublicServiceManage.getInstance().getService(ILogSupportService.class);
        if (null != logService) {
            logService.addOperaLog(log);
        }
    }

    private static class DetailListener
    implements ActionListener {
        private OperaLog log;

        public DetailListener(OperaLog log) {
            this.log = log;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LogDatailDialog logDetailDialog = new LogDatailDialog();
            String content = ResourceUtil.getString(this.log.getDetailInfo());
            if ("--".equals(content)) {
                content = this.log.getDetailInfo();
            }
            logDetailDialog.initData(content);
            logDetailDialog.setVisible(true);
        }
    }

    class ExportOperaLogCallable
    implements Callable<Boolean> {
        private String path;
        private List<OperaLog> logList = new ArrayList<OperaLog>();

        public ExportOperaLogCallable() {
        }

        public ExportOperaLogCallable(String path, List<OperaLog> logList) {
            this.path = path;
            this.logList = logList;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public List<OperaLog> getLogList() {
            return this.logList;
        }

        public void setLogList(List<OperaLog> logList) {
            this.logList = logList;
        }

        @Override
        public Boolean call() {
            boolean ret = OperaLogService.getInstance().exportOperaLog(this.path, this.logList);
            if (!ret) {
                return false;
            }
            FileUtils.setFilePermissions(this.path);
            OperaLogMainPanel.this.initData();
            return true;
        }
    }
}

