/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.log.ui;

import com.huawei.ism.tool.framework.platform.util.JComponentNameUtils;
import com.huawei.ism.tool.framework.pubservice.entity.OperaLog;
import com.huawei.ism.tool.log.entity.LogQueryCondition;
import com.huawei.ism.tool.log.service.OperaLogService;
import com.huawei.ism.tool.log.ui.ComboItem;
import com.huawei.ism.tool.log.ui.OperaLogMainPanel;
import com.huawei.ism.tool.log.ui.QueryOperaLogLayout;
import com.huawei.ism.tool.log.util.DateFormatUtil;
import com.huawei.ism.tool.obase.ui.dialogs.PublicDialog;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.util.SwingUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class QueryOperaLogDialog
extends PublicDialog {
    private static final long serialVersionUID = 1L;
    private QueryOperaLogLayout layout = null;
    private LogQueryCondition logQueryCon = null;
    private DateFormatUtil formatUtil = new DateFormatUtil();
    private JButton clearBtn;
    private OperaLogMainPanel parent = null;

    public QueryOperaLogDialog(OperaLogMainPanel parent) {
        this.parent = parent;
        this.initUI();
        this.logQueryCon = new LogQueryCondition();
        this.addListener();
        this.addName();
    }

    private void addName() {
        JComponentNameUtils.setJComponentName(this.clearBtn, "logsupport_operation_log_clear_btn");
        JComponentNameUtils.setJComponentName(this.getAppBtn(), "logsupport_app_btn");
        JComponentNameUtils.setJComponentName(this.getOkBtn(), "logsupport_confirm_btn");
        JComponentNameUtils.setJComponentName(this.getCancelBtn(), "logsupport_cancel_btn");
    }

    public final void initData() {
        this.layout.getTypeInput().setText(this.logQueryCon.getType());
        this.layout.getResultCombo().setSelectedItem(new ComboItem<Boolean>(this.logQueryCon.isResult()));
        this.layout.getStartDateInput().setText(this.formatUtil.getDateString(this.logQueryCon.getStartDate()));
        this.layout.getEndDateInput().setText(this.formatUtil.getDateString(this.logQueryCon.getEndDate()));
    }

    private void initUI() {
        JPanel contentPanel = this.getContentPanel();
        contentPanel.setLayout(new BorderLayout());
        this.layout = new QueryOperaLogLayout();
        contentPanel.add((Component)UiMethod.buildFrameSpace(this.layout, 15), "Center");
        this.pack();
        SwingUtil.putScreenCenter(this);
        this.setModal(true);
        this.setResizable(false);
        this.setTitle(ResourceUtil.getString("operalog.dialog.query.title"));
        this.setAppButtonVisible(false);
        this.setHelpButtonVisiable(false);
    }

    private void addListener() {
        JButton cancelButton = this.getCancelBtn();
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                QueryOperaLogDialog.this.setVisible(false);
            }
        });
        JButton okButton = this.getOkBtn();
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                QueryOperaLogDialog.this.doOKJob();
            }
        });
        this.clearBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                QueryOperaLogDialog.this.clearQueryCondition();
            }
        });
    }

    private void doOKJob() {
        LogQueryCondition condition = this.constructCondition();
        if (condition == null) {
            return;
        }
        if (!this.judgeCondition(condition)) {
            return;
        }
        this.logQueryCon = condition;
        List<OperaLog> logs = OperaLogService.getInstance().queryOperaLogs(condition);
        this.parent.refleshLogs(logs);
        this.parent.repaint();
        this.setVisible(false);
    }

    private void clearQueryCondition() {
        this.layout.getTypeInput().setText("");
        this.layout.getStartDateInput().setText("");
        this.layout.getEndDateInput().setText("");
        this.layout.getResultCombo().setSelectedIndex(0);
    }

    private LogQueryCondition constructCondition() {
        LogQueryCondition contion = new LogQueryCondition();
        contion.setType(this.layout.getTypeInput().getText());
        ComboItem item = (ComboItem)this.layout.getResultCombo().getSelectedItem();
        contion.setResult((Boolean)item.getValue());
        String startDateString = this.layout.getStartDateInput().getText();
        if (!StringUtils.isNULLStr(startDateString)) {
            try {
                contion.setStartDate(this.formatUtil.getDate(startDateString));
            }
            catch (ParseException e) {
                DialogUtils.showErrorDialog(this, ResourceUtil.getString("operalog.dialog.query.startdate.parse.error"));
                return null;
            }
        } else {
            contion.setStartDate(null);
        }
        String endDateString = this.layout.getEndDateInput().getText();
        if (!StringUtils.isNULLStr(endDateString)) {
            try {
                contion.setEndDate(this.formatUtil.getDate(endDateString));
            }
            catch (ParseException e) {
                DialogUtils.showErrorDialog(this, ResourceUtil.getString("operalog.dialog.query.enddate.parse.error"));
                return null;
            }
        } else {
            contion.setEndDate(null);
        }
        return contion;
    }

    private boolean judgeCondition(LogQueryCondition condition) {
        if (!condition.isDateAvailable()) {
            DialogUtils.showErrorDialog(this, ResourceUtil.getString("operalog.dialog.query.date.error"));
            return false;
        }
        return true;
    }

    @Override
    protected JComponent buildBtnPanel() {
        JButton okBtn = this.getOkBtn();
        JButton cancelBtn = this.getCancelBtn();
        this.clearBtn = UiMethod.createButton(ResourceUtil.getString("operalog.remind.clear"), 'L');
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new BoxLayout(btnPanel, 0));
        btnPanel.add(Box.createHorizontalGlue());
        btnPanel.add(okBtn);
        btnPanel.add(Box.createHorizontalStrut(10));
        btnPanel.add(this.clearBtn);
        btnPanel.add(Box.createHorizontalStrut(10));
        btnPanel.add(cancelBtn);
        btnPanel.add(Box.createHorizontalStrut(12));
        return UCD.buildVerticalBox(null, Box.createVerticalStrut(0), btnPanel, Box.createVerticalStrut(0));
    }
}

