/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui;

import com.huawei.ism.tool.base.ui.UiConstants;
import com.huawei.ism.ui.swing.plaf.IsmBorders;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;

public class ToolBorderUtils {
    private static final int CONTENTPANELBORDERWIDTH = 5;

    public static void painRoundBorder(Graphics graphics, JComponent component, Color color) {
        int xCoordinates = 0;
        int yCoordinates = 0;
        int componentWidth = component.getWidth();
        int componentHeight = component.getHeight();
        Color oldColor = graphics.getColor();
        graphics.setColor(color);
        graphics.fillRect(xCoordinates, yCoordinates + 1, 2, 1);
        graphics.fillRect(xCoordinates + 1, yCoordinates, 1, 2);
        graphics.fillRect(xCoordinates, yCoordinates + componentHeight - 2, 2, 1);
        graphics.fillRect(xCoordinates + 1, yCoordinates + componentHeight - 2, 1, 2);
        graphics.fillRect(xCoordinates + componentWidth - 2, yCoordinates + componentHeight - 2, 2, 1);
        graphics.fillRect(xCoordinates + componentWidth - 2, yCoordinates + componentHeight - 2, 1, 2);
        graphics.fillRect(xCoordinates + componentWidth - 2, yCoordinates + 1, 2, 1);
        graphics.fillRect(xCoordinates + componentWidth - 2, yCoordinates, 1, 2);
        graphics.setColor(oldColor);
    }

    public static Border getSplitPaneDividerBorder() {
        return new ToolSplitPaneDividerBorder();
    }

    public static LeftPanelBorder createLeftPanelBorder() {
        return new LeftPanelBorder();
    }

    public static ContentPanelBorder createContentPanelBorder() {
        return new ContentPanelBorder();
    }

    public static void drawBorder(Color paintColor, Graphics graphics, int xValue, int yValue, int width, int height, int borderWidth) {
        Color oldColor = graphics.getColor();
        graphics.setColor(paintColor);
        graphics.fillRect(xValue, yValue, width, yValue + borderWidth);
        graphics.fillRect(xValue, yValue, xValue + borderWidth, height);
        graphics.fillRect(xValue, yValue + height - borderWidth, xValue + width, yValue + height);
        graphics.fillRect(xValue + width - borderWidth, yValue, xValue + width, yValue + height);
        graphics.setColor(oldColor);
    }

    private static class LeftPanelBorder
    implements Border {
        private LeftPanelBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(3, 0, 0, 3);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component c, Graphics graphics, int xValue, int yValue, int width, int height) {
            Color oldColor = graphics.getColor();
            graphics.setColor(UiConstants.INNERBORDERCOLOR);
            graphics.fillRect(xValue, yValue, width, yValue + 3);
            graphics.fillRect(xValue + width - 3, yValue, xValue + width, yValue + height);
            graphics.setColor(oldColor);
        }
    }

    private static class ContentPanelBorder
    implements Border {
        private ContentPanelBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(5, 5, 5, 5);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component c, Graphics graphics, int xValue, int yValue, int width, int height) {
            ToolBorderUtils.drawBorder(UiConstants.INNERBORDERCOLOR, graphics, xValue, yValue, width, height, 5);
        }
    }

    public static class ToolSplitPaneDividerBorder
    extends IsmBorders.SplitPaneDividerBorder {
        public void paintBorder(Component component, Graphics graphics, int xValue, int yValue, int width, int height) {
            Color highlight = UIManager.getColor("SplitPane.borderColor");
            Color shadow = UIManager.getColor("SplitPane.borderColor");
            JSplitPane splitPane = null;
            if (!(component instanceof BasicSplitPaneDivider)) {
                return;
            }
            BasicSplitPaneDivider tmp = (BasicSplitPaneDivider)component;
            splitPane = tmp.getBasicSplitPaneUI().getSplitPane();
            Dimension size = component.getSize();
            Component child = splitPane.getLeftComponent();
            boolean borderCutted = UIManager.getBoolean("SplitPaneDivider.BorderCutted");
            graphics.setColor(borderCutted ? highlight : component.getBackground());
            graphics.drawRect(xValue, yValue, width - 1, height - 1);
            if (splitPane.getOrientation() == 1) {
                if (child != null) {
                    graphics.setColor(highlight);
                    graphics.drawLine(0, 0, 0, size.height);
                }
                if ((child = splitPane.getRightComponent()) != null) {
                    graphics.setColor(shadow);
                    graphics.drawLine(size.width - 1, 0, size.width - 1, size.height);
                }
                if (UIManager.getBoolean("SplitPaneDivider.BorderCutted")) {
                    graphics.setColor(UIManager.getColor("IsmArmorStyle.BaseColor"));
                    graphics.fillRect(0, 0, width, 3);
                    graphics.fillRect(0, height, width, height);
                }
            } else {
                if (child != null) {
                    graphics.setColor(highlight);
                    graphics.drawLine(0, 0, size.width, 0);
                }
                if ((child = splitPane.getRightComponent()) != null) {
                    graphics.setColor(shadow);
                    graphics.drawLine(0, size.height - 1, size.width, size.height - 1);
                }
            }
        }
    }
}

