/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui.component;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DateChooserDialog;
import com.huawei.ism.util.SwingUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateChooseField
extends JTextField {
    public static final int CHOOSE_TYPE_DATE = 0;
    public static final int CHOOSE_TYPE_TIME = 1;
    public static final int CHOOSE_TYPE_DATETIME = 2;
    JButton button;
    private static final ImageIcon CAL_ICON = ResourceUtil.getImage("calender.gif");
    private static final long serialVersionUID = -6059832561009845524L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DateChooseField.class);

    public DateChooseField() {
        this.setEditable(false);
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add(this.initUI(), "Center");
        this.setBackground(Color.WHITE);
    }

    public DateChooseField(int chooseModel) {
        this();
        this.setDateChooseModel(chooseModel);
    }

    private Component initUI() {
        this.button = new JButton();
        this.button.setRolloverIcon(CAL_ICON);
        this.button.setIcon(CAL_ICON);
        this.button.setPressedIcon(CAL_ICON);
        this.button.setSelectedIcon(CAL_ICON);
        this.button.setRolloverSelectedIcon(CAL_ICON);
        UiMethod.setComponentSize(new Dimension(CAL_ICON.getIconWidth(), CAL_ICON.getIconHeight()), this.button);
        this.button.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                DateChooseField.this.button.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                DateChooseField.this.button.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        return UiMethod.buildCompsRight(this.button);
    }

    public final void setDateChooseModel(int model) {
        this.button.addActionListener(new DateChooselistener(model, this));
    }

    private class DateChooselistener
    implements ActionListener {
        private int chooseType = 2;
        private JTextField parentFiled;

        public DateChooselistener(int timeType, JTextField field) {
            this.parentFiled = field;
            if (timeType != 0 && timeType != 1 && timeType != 2) {
                timeType = 2;
            }
            this.chooseType = timeType;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.parentFiled.isEnabled()) {
                return;
            }
            Date selectDate = this.chooseDate();
            if (null == selectDate) {
                return;
            }
            String dateStr = this.formateDate(selectDate);
            DateChooseField.this.setText(dateStr);
        }

        private String formateDate(Date selectDate) {
            switch (this.chooseType) {
                case 2: {
                    return StringUtils.formatDate(selectDate, "yyyy-MM-dd HH:mm:ss");
                }
                case 0: {
                    return StringUtils.formatDate(selectDate, "yyyy-MM-dd");
                }
                case 1: {
                    return StringUtils.formatDate(selectDate, "HH:mm:ss");
                }
            }
            return "";
        }

        private Date chooseDate() {
            JDialog parentDialog = this.getParentJDialog();
            if (parentDialog == null) {
                LOGGER.error("the DateChooseField`s parent is not JDialog!!!!");
                return new Date();
            }
            DateChooserDialog dateChooserDialog = new DateChooserDialog(parentDialog, "");
            SwingUtil.setCloseWhenEscKeyPressed((JDialog)dateChooserDialog);
            SwingUtil.cancelEscKeyToClose((JDialog)dateChooserDialog);
            dateChooserDialog.setDate(null);
            dateChooserDialog.setVisible(true);
            dateChooserDialog.toFront();
            return dateChooserDialog.getDate();
        }

        private JDialog getParentJDialog() {
            Container parent = DateChooseField.this;
            do {
                if (!((parent = parent.getParent()) instanceof JDialog)) continue;
                return (JDialog)parent;
            } while (parent != null);
            return null;
        }
    }
}

