/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui.component;

import com.huawei.ism.tool.base.ui.action.ToolAction;
import com.huawei.ism.ui.swing.plaf.IsmBorders;
import com.huawei.ism.util.UCD;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class RolloverButton
extends JButton {
    private static final long serialVersionUID = 1L;
    private static final String UICLASSID = "RolloverButtonUI";
    private Border arrawVisibleBorder = IsmBorders.getRolloverButtonButton((boolean)true);
    private Border arrawInvisibleBorder = IsmBorders.getRolloverButtonButton((boolean)false);
    private boolean isArrowVisiable;

    public RolloverButton(String groupName, Icon icon, final List<ToolAction> actions) {
        super(groupName, icon);
        this.setToolTipText(groupName);
        this.setFocusable(false);
        this.updatePreferSize();
        this.isArrowVisiable = true;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent me) {
                JPopupMenu popmenu = new JPopupMenu();
                for (ToolAction action : actions) {
                    popmenu.add(action);
                    popmenu.setEnabled(action.isAvailable());
                }
                popmenu.show(me.getComponent(), 0, RolloverButton.this.getY() + RolloverButton.this.getHeight() - 3);
            }
        });
    }

    public RolloverButton(String groupName, List<ToolAction> actions) {
        this(groupName, null, actions);
    }

    public RolloverButton(ToolAction action) {
        super(action);
        this.setFocusable(false);
        this.setEnabled(action.isAvailable());
        this.setToolTips(action);
        this.updatePreferSize();
    }

    public RolloverButton(String text) {
        super(text);
        this.setFocusable(false);
        this.setEnabled(true);
        this.setToolTipText(text);
        this.updatePreferSize();
    }

    public RolloverButton(ToolAction action, boolean isArrowVisiable) {
        super(action);
        this.isArrowVisiable = isArrowVisiable;
        this.setFocusable(false);
        this.setEnabled(action.isAvailable());
        this.setToolTips(action);
        this.updatePreferSize();
    }

    private void setToolTips(ToolAction action) {
        if (null != action.getValue("Name")) {
            this.setToolTipText(action.getValue("Name").toString());
        }
    }

    public void updateStatus() {
    }

    private void updatePreferSize() {
        Dimension dim = UCD.computeButtonPreferredSize((AbstractButton)this);
        dim.height = 25;
        this.setMinimumSize(dim);
        this.setPreferredSize(dim);
        this.setMaximumSize(dim);
    }

    @Override
    public String getUIClassID() {
        return UICLASSID;
    }

    @Override
    public void paintComponent(Graphics gra) {
        if (this.isArrowVisiable) {
            Icon arrow = UIManager.getIcon("Table.descendingSortIcon");
            int wid = this.getWidth() - arrow.getIconWidth() - 4;
            int hei = (this.getHeight() - arrow.getIconHeight()) / 2;
            arrow.paintIcon(this, gra, wid, hei);
        }
        this.setBorder(this.isArrowVisiable ? this.arrawVisibleBorder : this.arrawInvisibleBorder);
        super.paintComponent(gra);
    }
}

