/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui.component;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.IsmTableCellRenderer;
import java.awt.Component;
import java.io.ObjectStreamException;
import java.text.Collator;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class TextEditCell
extends IsmTableCell {
    private static final long serialVersionUID = 7809319318876201368L;
    private static final TableCellRenderer RENDER = new IsmTableCellRenderer();
    private static final TableCellRenderer PASSWORDRENDERER = new PassWordCellRenderer();
    private TableCellEditor editor = null;
    private boolean isEditable;
    private String value;
    private transient Comparable<?> comparable;
    private boolean passwordEdit = false;

    public TextEditCell(String value) {
        this.isEditable = false;
        this.value = value;
        this.editor = new TextEditor(new JTextField());
    }

    public TextEditCell(String value, JTextField editComp) {
        this.isEditable = null != editComp;
        this.value = value;
        if (null != editComp) {
            this.editor = new TextEditor(editComp);
        }
    }

    public TextEditCell(String value, JComboBox combox) {
        this.isEditable = null != combox;
        this.value = value;
        if (null != combox) {
            this.editor = new ComboEditor(combox);
        }
    }

    public TextEditCell(String value, JTextField editComp, boolean passwordEdit) {
        this.isEditable = null != editComp;
        this.value = value;
        if (null != editComp) {
            this.editor = new TextEditor(editComp);
        }
        this.passwordEdit = passwordEdit;
    }

    public TextEditCell(String value, Comparable<?> comp) {
        this(value);
        this.comparable = comp;
    }

    public TableCellRenderer getRender() {
        if (this.passwordEdit) {
            return PASSWORDRENDERER;
        }
        return RENDER;
    }

    public Object getValue() {
        return this.value;
    }

    public TableCellEditor getEditor() {
        if (this.isEditable) {
            return this.editor;
        }
        return null;
    }

    public String toString() {
        return this.value;
    }

    protected Object readResolve() throws ObjectStreamException {
        return new TextEditCell(this.value);
    }

    public int compareTo(IsmTableCell cell) {
        if (!(cell instanceof TextEditCell)) {
            return -1;
        }
        if (null == this.comparable || null == ((TextEditCell)cell).comparable) {
            String thatVal = ((TextEditCell)cell).value;
            String thisVal = this.value;
            if (null == thatVal || null == thisVal) {
                return -1;
            }
            return Collator.getInstance().compare(thisVal, thatVal);
        }
        Comparable<?> thisVal = this.comparable;
        Comparable<?> thatVal = ((TextEditCell)cell).comparable;
        return thisVal.compareTo(thatVal);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TextEditCell)) {
            return false;
        }
        TextEditCell that = (TextEditCell)((Object)obj);
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    static class PassWordCellRenderer
    extends IsmTableCellRenderer {
        private static final long serialVersionUID = -7577187902527471021L;

        PassWordCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent comp = (JComponent)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (table instanceof IsmTable) {
                String cellText = this.getText();
                this.setText(StringUtils.fillStr("", cellText.length(), "*"));
                this.setToolTipText(null);
            }
            return comp;
        }
    }

    static class TextEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 1L;
        private TextEditCell currentCell;

        public TextEditor(JTextField textField) {
            super(textField);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            String val = "";
            if (value instanceof TextEditCell) {
                this.currentCell = (TextEditCell)((Object)value);
                val = this.currentCell.value;
            }
            ((JTextField)this.getComponent()).setText(val);
            return this.editorComponent;
        }

        @Override
        public boolean stopCellEditing() {
            boolean success = this.delegate.stopCellEditing();
            if (success) {
                this.currentCell.value = ((JTextField)this.getComponent()).getText();
            }
            return success;
        }
    }

    static class ComboEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 1L;
        private TextEditCell currentCell;

        public ComboEditor(JComboBox combox) {
            super(combox);
        }

        @Override
        public Component getTableCellEditorComponent(JTable paramJTable, Object paramObject, boolean paramBoolean, int paramInt1, int paramInt2) {
            if (paramObject instanceof TextEditCell) {
                this.currentCell = (TextEditCell)((Object)paramObject);
            }
            return super.getTableCellEditorComponent(paramJTable, paramObject, paramBoolean, paramInt1, paramInt2);
        }

        @Override
        public Object getCellEditorValue() {
            return this.currentCell.value;
        }

        @Override
        public boolean stopCellEditing() {
            boolean success = this.delegate.stopCellEditing();
            if (success) {
                this.currentCell.value = ((JComboBox)this.getComponent()).getSelectedItem().toString();
            }
            return success;
        }
    }
}

