/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui.component.jlist;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.ui.component.jlist.OperateLogList;
import com.huawei.ism.tool.base.ui.component.jlist.StepListItem;
import com.huawei.ism.util.CommonUtil;
import com.huawei.ism.util.UCD;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

public class DetectStepListCellRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = -2263332707001857534L;
    private static final int PADDING_WIDTH = 12;
    private static final int ICON_WIDTH = 16;
    private JScrollPane listScrollPane;

    public DetectStepListCellRenderer(JScrollPane listScrollPane) {
        this.listScrollPane = listScrollPane;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object item, int index, boolean isSelected, boolean cellHasFocus) {
        if (!(item instanceof StepListItem)) {
            return new JLabel();
        }
        JPanel listItem = this.buildListItemPanel(item);
        listItem.setComponentOrientation(list.getComponentOrientation());
        listItem.setEnabled(list.isEnabled());
        listItem.setFont(list.getFont());
        this.setToolTip(item, listItem);
        if (isSelected) {
            Color bg = UIManager.getColor("List.selectionBackground");
            listItem.setBackground(bg == null ? list.getSelectionBackground() : bg);
            UiMethod.setBatchComponentProperty("setForeground", new Object[]{Color.WHITE}, listItem);
        } else {
            boolean isRollover;
            OperateLogList opLogList = (OperateLogList)CommonUtil.convertObject((Object)list, OperateLogList.class);
            boolean bl = isRollover = opLogList.getCurRolloverIndex() == index;
            if (isRollover) {
                Color bg = UIManager.getColor("List.rolloverbackground");
                listItem.setBackground(bg == null ? list.getBackground() : bg);
            } else {
                listItem.setBackground(list.getBackground());
                listItem.setForeground(list.getForeground());
            }
        }
        return listItem;
    }

    private JPanel buildListItemPanel(Object obj) {
        StepListItem item = (StepListItem)obj;
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        int left = 12 * item.getLevel();
        panel.add(Box.createHorizontalStrut(left));
        ImageIcon icon = item.getImageIcon();
        panel.add(new JLabel(icon));
        panel.add(Box.createHorizontalStrut(12));
        panel.add(new JLabel(item.getContent()));
        return panel;
    }

    private void setToolTip(Object obj, JPanel itemPanel) {
        int visibleWidth;
        StepListItem item = (StepListItem)obj;
        String itemText = item.getContent();
        if (null == itemText) {
            this.setToolTipText(null);
            return;
        }
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int cellWidth = fm.stringWidth(itemText) + 12 + 16;
        if (1 == item.getLevel()) {
            cellWidth += 12;
        }
        if (cellWidth > (visibleWidth = this.listScrollPane.getVisibleRect().width - this.listScrollPane.getVerticalScrollBar().getWidth())) {
            itemPanel.setToolTipText(UCD.wrapTextWithHTML((FontMetrics)fm, (String)itemText, (int)300));
        } else {
            this.setToolTipText(null);
        }
    }
}

