/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui.component.wizard;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.ui.component.wizard.IHelpActionCallBack;
import com.huawei.ism.tool.base.ui.component.wizard.IWizardClosingObserver;
import com.huawei.ism.tool.base.ui.component.wizard.WizardConstants;
import com.huawei.ism.tool.base.ui.component.wizard.WizardRootPaneUI;
import com.huawei.ism.tool.base.ui.component.wizard.WizardStepGroup;
import com.huawei.ism.tool.base.ui.component.wizard.WizardStepItem;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ToolWizardDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final int WIZARD_DIALOG_WIDTH = 785;
    private static final int WIZARD_DIALOG_HEIGHT = 500;
    boolean hasHelpIcon = true;
    private WizardRootPaneUI rootPaneUI = new WizardRootPaneUI();
    private WizardStepGroup stepsGroup = new WizardStepGroup();
    private Card currentCard;
    private Box navigationBar;
    private JPanel contentPane;
    private IWizardClosingObserver closeObserver;
    private String wizardName = "";

    public ToolWizardDialog(JFrame frame, List<String[]> stepNames, boolean hasHelpIcon) {
        super((Frame)frame, true);
        this.hasHelpIcon = hasHelpIcon;
        this.init(stepNames);
        this.initListener();
    }

    public ToolWizardDialog(Dialog dialog, List<String[]> stepNames, boolean hasHelpIcon) {
        super(dialog, true);
        this.hasHelpIcon = hasHelpIcon;
        this.init(stepNames);
        this.initListener();
    }

    public ToolWizardDialog(JFrame frame, List<String[]> stepNames) {
        this(frame, stepNames, true);
    }

    public ToolWizardDialog(List<String[]> stepNames) {
        this((JFrame)null, stepNames, true);
    }

    public ToolWizardDialog(Dialog dialog, List<String[]> stepNames) {
        this(dialog, stepNames, true);
    }

    public void setObserver(IWizardClosingObserver observer) {
        this.closeObserver = observer;
    }

    public void setHelpActionCallBack(IHelpActionCallBack helpActionCallBack) {
        this.rootPaneUI.setHelpActionCallBack(helpActionCallBack);
    }

    public void setWizardName(String name) {
        this.wizardName = name;
    }

    private void initListener() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ToolWizardDialog.this.confirmExit();
            }
        });
    }

    private void confirmExit() {
        if (null != this.closeObserver) {
            this.closeObserver.onClose();
        }
    }

    public void setFirstCard(Card firstCard) {
        this.setCurrentCard(firstCard);
    }

    public void chg2NextCard() {
        if (null != this.getCurrentCard().getNextCard()) {
            this.setCurrentCard(this.getCurrentCard().getNextCard());
        }
    }

    private void init(List<String[]> stepNames) {
        this.getRootPane().setUI(this.rootPaneUI);
        if (null == stepNames) {
            return;
        }
        ArrayList<WizardStepItem> stepList = new ArrayList<WizardStepItem>();
        int i = 1;
        for (String[] stepNameArray : stepNames) {
            WizardStepItem step = new WizardStepItem(stepNameArray[0], stepNameArray[1], i, LanguageManager.getInstance().getCurrentLanguage());
            if (1 == i) {
                step.setSelected(true);
            }
            ++i;
            stepList.add(step);
        }
        this.stepsGroup.setSetps(stepList.toArray(new WizardStepItem[stepList.size()]));
        this.contentPane = new JPanel(new BorderLayout());
        this.navigationBar = Box.createHorizontalBox();
        Box southBox = Box.createVerticalBox();
        southBox.add(Box.createVerticalStrut(12));
        southBox.add(this.navigationBar);
        JPanel stepsPanel = new JPanel(new BorderLayout());
        stepsPanel.add((Component)this.stepsGroup, "West");
        stepsPanel.add((Component)this.contentPane, "Center");
        stepsPanel.add((Component)southBox, "South");
        southBox.setPreferredSize(new Dimension((int)this.getPreferredSize().getWidth(), 39));
        stepsPanel.setBackground(WizardConstants.WIZARD_BACKGROUND);
        stepsPanel.setPreferredSize(new Dimension(785, 500));
        JPanel buttomPanel = new JPanel();
        buttomPanel.setPreferredSize(new Dimension((int)this.getPreferredSize().getWidth(), 6));
        buttomPanel.setBackground(WizardConstants.WIZARD_BUTTOM_LINE_COLOR);
        Container container = this.getContentPane();
        this.setLayout(new BorderLayout());
        container.add((Component)stepsPanel, "Center");
        container.add((Component)buttomPanel, "South");
        int height = this.getStepsGroupHeight();
        this.setSize(height / 3 * 4, height);
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.pack();
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
    }

    private void setCurrentCard(Card card) {
        if (null != card) {
            this.currentCard = card;
            this.contentPane.removeAll();
            this.contentPane.add(UiMethod.buildFrameSpace(card, 20));
            this.initNavigationHandle();
            this.updateNavigationBar();
            this.updateStepPane();
            StringBuffer sb = new StringBuffer();
            sb.append(this.wizardName).append(card.getStep() + 1).append(ResourceUtil.getString("toolbase.common.txt.commer"));
            String title = card.getTitle();
            sb.append(StringUtils.isNULLStr(title) ? "" : title);
            this.setTitle(sb.toString());
            this.contentPane.revalidate();
            this.contentPane.repaint();
            this.repaint();
        }
    }

    public Card getCurrentCard() {
        return this.currentCard;
    }

    private void updateStepPane() {
        int currentStep = this.currentCard.getStep();
        if (0 <= currentStep && currentStep < this.stepsGroup.getStepSize()) {
            this.stepsGroup.setSelect(currentStep);
        }
    }

    private void initNavigationHandle() {
        if (!this.currentCard.actionInjected) {
            Map naviButtons = this.currentCard.navigationButtons;
            if (naviButtons.containsKey((Object)Navigation.PREVIOUS)) {
                JButton previousButton = (JButton)naviButtons.get((Object)Navigation.PREVIOUS);
                previousButton.addActionListener(new PreviousBtnAction());
            }
            if (naviButtons.containsKey((Object)Navigation.NEXT)) {
                JButton nextButton = (JButton)naviButtons.get((Object)Navigation.NEXT);
                nextButton.addActionListener(new NexBtnAction());
            }
            if (naviButtons.containsKey((Object)Navigation.COMPLETE)) {
                JButton completeButton = (JButton)naviButtons.get((Object)Navigation.COMPLETE);
                completeButton.addActionListener(new CompleteBtnAction());
            }
            if (naviButtons.containsKey((Object)Navigation.CANCEL)) {
                JButton cancelButton = (JButton)naviButtons.get((Object)Navigation.CANCEL);
                cancelButton.addActionListener(new CancelBtnAction());
            }
            this.getRootPane().getActionMap().remove("ESCAPE");
            this.getRootPane().getActionMap().put("ESCAPE", new EscBtnAction());
            this.currentCard.actionInjected = true;
        }
    }

    @Override
    protected void processWindowEvent(WindowEvent event) {
        if (event.getID() == 201 && !this.currentCard.isValid(Navigation.CANCEL)) {
            return;
        }
        super.processWindowEvent(event);
    }

    @Override
    public void dispose() {
        try {
            if (null != this.currentCard) {
                this.currentCard.doCancelTask();
            }
        }
        catch (Exception ex) {
            ToolLoggerFactory.getLogger(this.getClass()).error("", (Throwable)ex);
        }
        super.dispose();
    }

    private void updateNavigationBar() {
        JButton button;
        Map naviButtons = this.currentCard.navigationButtons;
        this.navigationBar.removeAll();
        this.navigationBar.add(Box.createHorizontalGlue());
        if (naviButtons.containsKey((Object)Navigation.PREVIOUS)) {
            this.navigationBar.add((Component)naviButtons.get((Object)Navigation.PREVIOUS));
        }
        if (naviButtons.containsKey((Object)Navigation.NEXT)) {
            this.navigationBar.add(Box.createHorizontalStrut(10));
            this.navigationBar.add((Component)naviButtons.get((Object)Navigation.NEXT));
        }
        if (naviButtons.containsKey((Object)Navigation.COMPLETE)) {
            this.navigationBar.add(Box.createHorizontalStrut(10));
            this.navigationBar.add((Component)naviButtons.get((Object)Navigation.COMPLETE));
        }
        if (naviButtons.containsKey((Object)Navigation.CANCEL)) {
            this.navigationBar.add(Box.createHorizontalStrut(15));
            this.navigationBar.add((Component)naviButtons.get((Object)Navigation.CANCEL));
        }
        this.navigationBar.add(Box.createHorizontalStrut(20));
        if (naviButtons.containsKey((Object)Navigation.NEXT)) {
            button = (JButton)naviButtons.get((Object)Navigation.NEXT);
            this.getRootPane().setDefaultButton(button);
            button.requestFocus();
        }
        if (naviButtons.containsKey((Object)Navigation.COMPLETE)) {
            button = (JButton)naviButtons.get((Object)Navigation.COMPLETE);
            this.getRootPane().setDefaultButton(button);
            button.requestFocus();
        }
    }

    public int getStepsGroupHeight() {
        return (int)this.stepsGroup.getPreferredSize().getHeight() + 6 + 39;
    }

    public static abstract class Card
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private Card previousCard;
        private boolean actionInjected;
        private Map<Navigation, JButton> navigationButtons = new HashMap<Navigation, JButton>();

        public Card() {
        }

        public Card(Card previousCard, Navigation ... supportedNavigation) {
            this.setLayout(new BorderLayout());
            this.previousCard = previousCard;
            HashSet<Navigation> naviList = new HashSet<Navigation>();
            if (null == supportedNavigation || 0 == supportedNavigation.length) {
                naviList.add(Navigation.PREVIOUS);
                naviList.add(Navigation.NEXT);
            } else {
                naviList.addAll(Arrays.asList(supportedNavigation));
            }
            naviList.add(Navigation.CANCEL);
            Navigation tempNav = (Navigation)((Object)naviList.toArray()[0]);
            for (Navigation navigation : naviList) {
                if (navigation.toString().length() <= tempNav.toString().length()) continue;
                tempNav = navigation;
            }
            JButton tplBtn = UiMethod.createButton(tempNav.toString());
            this.navigationButtons.put(tempNav, tplBtn);
            for (Navigation navigation : naviList) {
                if (navigation.equals((Object)tempNav)) continue;
                String name = navigation.toString();
                JButton button = UiMethod.createButton(name);
                this.navigationButtons.put(navigation, button);
            }
            this.updateNavigationBar();
        }

        public final void updateNavigationBar() {
            for (Navigation type : this.navigationButtons.keySet()) {
                JButton button = this.navigationButtons.get((Object)type);
                button.setEnabled(this.isValid(type));
            }
        }

        public final Card getPreviousCard() {
            return this.previousCard;
        }

        public abstract String getTitle();

        public abstract int getStep();

        protected abstract Card getNextCard();

        protected abstract boolean isValid(Navigation var1);

        protected abstract boolean process(Navigation var1);

        protected void doCancelTask() {
        }
    }

    public static enum Navigation {
        PREVIOUS,
        NEXT,
        COMPLETE,
        CANCEL;


        public String toString() {
            String prefix = "toolbase.common.txt.";
            return ResourceUtil.getString(prefix + this.name().toLowerCase(Locale.getDefault()));
        }
    }

    private final class EscBtnAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private EscBtnAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!ToolWizardDialog.this.currentCard.isValid(Navigation.CANCEL)) {
                return;
            }
            ToolWizardDialog.this.dispose();
        }
    }

    private final class NexBtnAction
    implements ActionListener {
        private NexBtnAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Card nextCard;
            boolean success = ToolWizardDialog.this.currentCard.process(Navigation.NEXT);
            if (success && null != (nextCard = ToolWizardDialog.this.currentCard.getNextCard())) {
                ToolWizardDialog.this.setCurrentCard(nextCard);
            }
        }
    }

    private final class CompleteBtnAction
    implements ActionListener {
        private CompleteBtnAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean success = ToolWizardDialog.this.currentCard.process(Navigation.COMPLETE);
            if (success) {
                if (null != ToolWizardDialog.this.closeObserver) {
                    ToolWizardDialog.this.closeObserver.onComplete();
                }
                ToolWizardDialog.this.dispose();
            }
        }
    }

    private final class CancelBtnAction
    implements ActionListener {
        private CancelBtnAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (ToolWizardDialog.this.currentCard.process(Navigation.CANCEL)) {
                ToolWizardDialog.this.confirmExit();
            }
        }
    }

    private final class PreviousBtnAction
    implements ActionListener {
        private PreviousBtnAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Card previousCard;
            boolean success = ToolWizardDialog.this.currentCard.process(Navigation.PREVIOUS);
            if (success && null != (previousCard = ToolWizardDialog.this.currentCard.getPreviousCard())) {
                ToolWizardDialog.this.setCurrentCard(previousCard);
            }
        }
    }
}

