/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui.dialogs;

import com.huawei.ism.tool.base.ui.UiResource;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.ui.swing.ImagePanel;
import com.huawei.ism.ui.swing.plaf.IsmFontFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;

public class ProgressNumDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private UiResource resource = UiResource.getInstance();
    private JLabel progressLabel = this.createIconPanel("task_loading.gif");
    private Locale loc = null;

    public ProgressNumDialog(Window parent) {
        this(parent, LanguageManager.getInstance().getCurrentLanguage());
    }

    public ProgressNumDialog(Window parent, Locale loc) {
        super(parent);
        this.loc = loc;
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.setName("ISMV1R2_framework_uiComponent_ProgressNumDialog");
        this.layoutUI();
        this.setUndecorated(true);
        this.pack();
        this.setLocationRelativeTo(parent);
        this.toFront();
        this.setFocusableWindowState(true);
    }

    private void layoutUI() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JComponent iconLabel = null;
        iconLabel = this.createArmorContentPane();
        iconLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
        panel.add((Component)iconLabel, "North");
        JButton jButton = new JButton("");
        jButton.setSize(0, 0);
        jButton.setPreferredSize(new Dimension(0, 0));
        panel.add((Component)jButton, "South");
        this.add(panel);
    }

    private JLabel createIconPanel(String imgName) {
        ImageIcon process = ResourceUtil.getImage(imgName);
        JLabel iconLabel = new JLabel();
        iconLabel.setIcon(process);
        process.setImageObserver(iconLabel);
        return iconLabel;
    }

    private JComponent createArmorContentPane() {
        ImagePanel leftImagePanel = new ImagePanel(ResourceUtil.getImage("loading-left.png"));
        ImagePanel rightImagePanel = new ImagePanel(ResourceUtil.getImage("loading-right.png"));
        ImagePanel middleImagePanel = new ImagePanel(ResourceUtil.getImage("loading-middle.png"), ImagePanel.ExtendOrient.HORIZONAL);
        leftImagePanel.setPreferredSize(new Dimension(20, 122));
        middleImagePanel.setPreferredSize(new Dimension(220, 122));
        rightImagePanel.setPreferredSize(new Dimension(20, 122));
        leftImagePanel.setOpaque(false);
        middleImagePanel.setOpaque(false);
        rightImagePanel.setOpaque(false);
        middleImagePanel.setLayout((LayoutManager)new BorderLayout());
        this.progressLabel.setFont(IsmFontFactory.getPlaint12Font());
        this.progressLabel.setForeground(Color.WHITE);
        this.progressLabel.setText(this.resource.getStringWithParams(this.loc, "progress.dialog.tips", 0));
        Box lableBox = Box.createHorizontalBox();
        lableBox.add(Box.createHorizontalGlue());
        lableBox.add(this.progressLabel);
        lableBox.add(Box.createHorizontalGlue());
        middleImagePanel.add((Component)lableBox);
        Box box = Box.createHorizontalBox();
        box.add((Component)leftImagePanel);
        box.add((Component)middleImagePanel);
        box.add((Component)rightImagePanel);
        return box;
    }

    public void updateProgress(int progress) {
        if (progress < 0 || progress > 100) {
            progress = 100;
        }
        this.progressLabel.setText(this.resource.getStringWithParams(this.loc, "progress.dialog.tips", progress));
    }

    @Override
    protected void dialogInit() {
        super.dialogInit();
        if (JDialog.isDefaultLookAndFeelDecorated()) {
            JRootPane rootPane = this.getRootPane();
            boolean supportsWindowDecorations = UIManager.getLookAndFeel().getSupportsWindowDecorations();
            if (supportsWindowDecorations) {
                this.setUndecorated(true);
                rootPane.setWindowDecorationStyle(0);
            }
        }
    }
}

