/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui.dialogs;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.base.ui.UiResource;
import com.huawei.ism.tool.base.ui.dialogs.IDialogCallback;
import com.huawei.ism.tool.base.ui.dialogs.UiValidator;
import com.huawei.ism.tool.base.validate.AbstractValidator;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public abstract class PublicDialog
extends JDialog
implements UiValidator.IValidatorNameUser {
    private static final long serialVersionUID = 539018767316840745L;
    public JButton okBtn = null;
    public JButton appBtn = null;
    public JButton cancelBtn = null;
    public JButton helpBtn = null;
    protected IDialogCallback parentComponent = null;
    private UiResource resource = UiResource.getInstance();
    private Locale loc = null;
    private UiValidator validator = new UiValidator();
    private boolean isSupAppBtn = false;
    private JPanel btnPanel = new JPanel();
    protected JPanel contentPanel = new JPanel();
    private Component marginComp = Box.createHorizontalStrut(10);
    private Component helpComp = Box.createHorizontalStrut(12);
    private Component cancelComp = Box.createHorizontalStrut(12);

    public PublicDialog() {
        this(LanguageManager.getInstance().getCurrentLanguage());
    }

    public PublicDialog(Locale loc) {
        this((JDialog)null, loc);
    }

    public PublicDialog(JDialog parent) {
        this(parent, LanguageManager.getInstance().getCurrentLanguage());
    }

    public PublicDialog(JDialog parent, Locale loc) {
        this(parent, loc, false);
    }

    public PublicDialog(JDialog parent, boolean isSupAppBtn) {
        this(parent, LanguageManager.getInstance().getCurrentLanguage(), isSupAppBtn);
    }

    public PublicDialog(JDialog parent, Locale loc, boolean isSupAppBtn) {
        super(parent);
        this.isSupAppBtn = isSupAppBtn;
        this.init(loc);
    }

    public PublicDialog(JFrame parent) {
        this(parent, LanguageManager.getInstance().getCurrentLanguage());
    }

    public PublicDialog(JFrame parent, Locale loc) {
        this(parent, loc, false);
    }

    public PublicDialog(JFrame parent, boolean isSupAppBtn) {
        this(parent, LanguageManager.getInstance().getCurrentLanguage(), false);
    }

    public PublicDialog(JFrame parent, Locale loc, boolean isSupAppBtn) {
        super(parent);
        this.isSupAppBtn = isSupAppBtn;
        this.init(loc);
    }

    public void showCloseButton() {
        this.okBtn.setVisible(false);
        this.cancelBtn.setText(this.resource.getString(this.loc, "toolbase.public.dialog.txt.close"));
    }

    private void init(Locale locale) {
        this.loc = locale;
        this.okBtn = UiMethod.createButton(this.resource.getString(locale, "text.ok"), 'O');
        this.appBtn = UiMethod.createButton(this.resource.getString(locale, "text.apply"), 'P');
        this.cancelBtn = UiMethod.createButton(this.resource.getString(locale, "text.cancel"), 'C');
        this.helpBtn = UiMethod.createButton(this.resource.getString(locale, "text.help"), 'H');
        this.initUI();
        this.initCancelBtnListener();
    }

    private void initUI() {
        JComponent btnComp = this.buildBtnPanel();
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JSeparator sp = new JSeparator();
        panel.add((Component)sp, "North");
        panel.add((Component)btnComp, "East");
        panel.add((Component)this.getBtnPanel(), "South");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(this.contentPanel);
        this.getContentPane().add((Component)panel, "South");
    }

    private JPanel getBtnPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        return buttonPanel;
    }

    protected JComponent buildBtnPanel() {
        this.btnPanel.setLayout(new BoxLayout(this.btnPanel, 0));
        this.btnPanel.add(Box.createHorizontalGlue());
        this.btnPanel.add(this.okBtn);
        this.btnPanel.add(Box.createHorizontalStrut(10));
        this.btnPanel.add(this.appBtn);
        this.btnPanel.add(this.marginComp);
        this.btnPanel.add(this.cancelBtn);
        this.btnPanel.add(this.cancelComp);
        this.btnPanel.add(this.helpBtn);
        this.btnPanel.add(this.helpComp);
        if (this.isSupAppBtn) {
            this.setAppButtonVisible(true);
            this.setHelpButtonVisiable(true);
        } else {
            this.setAppButtonVisible(false);
            this.setHelpButtonVisiable(false);
        }
        return UCD.buildVerticalBox(null, (Component[])new Component[]{Box.createVerticalStrut(0), this.btnPanel, Box.createVerticalStrut(0)});
    }

    public void setCancelButtonVisible(boolean isVisible) {
        if (!isVisible) {
            this.cancelBtn.setVisible(isVisible);
            this.btnPanel.remove(this.cancelComp);
            this.btnPanel.remove(this.cancelBtn);
        }
    }

    public void setAppButtonVisible(boolean isVisible) {
        if (!isVisible) {
            this.appBtn.setVisible(isVisible);
            this.btnPanel.remove(this.marginComp);
            this.btnPanel.remove(this.appBtn);
        }
    }

    public void setHelpButtonVisiable(boolean isVisiable) {
        if (!isVisiable) {
            this.helpBtn.setVisible(isVisiable);
            this.btnPanel.remove(this.helpComp);
            this.btnPanel.remove(this.helpBtn);
        }
    }

    protected void initCancelBtnListener() {
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PublicDialog.this.dispose();
            }
        });
    }

    public JPanel getContentPanel() {
        return this.contentPanel;
    }

    public void addValidation(JComponent component, JLabel lable, String validatorName, Object ... params) {
        this.validator.addValidation(component, lable, validatorName, params);
    }

    public void addValidations(JComponent component, JLabel lable, String ... validatorNames) {
        this.validator.addValidations(component, lable, validatorNames);
    }

    protected void addValidation(JComponent component, JLabel lable, AbstractValidator abstractValidator, Object ... params) {
        this.validator.addValidation(component, lable, abstractValidator, params);
    }

    protected void addValidations(JComponent component, JLabel lable, AbstractValidator ... validators) {
        this.validator.addValidations(component, lable, validators);
    }

    protected void addValidator(AbstractValidator abstractValidator) {
        this.validator.append(abstractValidator);
    }

    protected boolean validateInput() {
        return this.validator.validateInput(this, this.loc);
    }

    protected boolean validateInput(UiValidator.IValidateMsgDisplayer msgDisplayer) {
        return this.validator.validateInput(msgDisplayer, this.loc);
    }

    static class ButtonPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        ButtonPanel() {
        }

        @Override
        public void paint(Graphics arg0) {
            Color oldColor = arg0.getColor();
            arg0.setColor(new Color(0xD6D6D6));
            arg0.fillRect(0, this.getHeight() - 4, this.getWidth(), 4);
            arg0.setColor(oldColor);
        }
    }
}

