/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.base.ui.filechooser;

import com.huawei.ism.tool.base.ui.UiResource;
import com.huawei.ism.tool.base.ui.file.FileTypeUtils;
import com.huawei.ism.tool.base.ui.filechooser.FileChooserWrapper;
import com.huawei.ism.tool.base.ui.filechooser.HibernateContainer;
import com.huawei.ism.tool.base.utils.FileUtils;
import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.base.utils.SceneUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.ui.swing.IsmFileChooser;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Component;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.swing.JFileChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ToolFileChooser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ToolFileChooser.class);
    private static final String NETWORKPATH = "network shortcuts";
    private static final long REQUIRED_FREE_DISK = 0x6400000L;
    private static final int MAX_FILE_LENGTH = 200;

    private ToolFileChooser() {
    }

    public static IsmFileChooser createIsmFileChooser(String title, String defaultPath, String description, String[] exts) {
        IsmFileChooser ismFileChooser = new IsmFileChooser(title);
        ismFileChooser.setAcceptAllFileFilterUsed(false);
        if (!StringUtils.isNULLStr(defaultPath)) {
            File defaultPackagePath = new File(defaultPath);
            ismFileChooser.setCurrentDirectory(defaultPackagePath.isDirectory() ? defaultPackagePath : defaultPackagePath.getParentFile());
        } else {
            ismFileChooser.setCurrentDirectory(null);
        }
        ismFileChooser.addFileFilter(exts, description);
        return ismFileChooser;
    }

    public static File selectFile(Window parent, String title, String[] exts, String defaultPathId, String desc, int fileSelectionMode, boolean isWindowsOS, Locale locale) {
        return ToolFileChooser.selectFile(parent, title, exts, defaultPathId, desc, fileSelectionMode, false, isWindowsOS, locale);
    }

    public static File selectFile(Window parent, String title, String[] exts, String defaultPathIdStr, String description, int fileSelectionMode, boolean isOpenDialog, boolean isWindowsOS, Locale locale, int length) {
        String defaultPath;
        Object defaultPathObj = HibernateContainer.getInstance().get(defaultPathIdStr);
        String string = defaultPath = defaultPathObj != null ? defaultPathObj.toString() : null;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("read filechooser default path: " + defaultPathIdStr + " -->" + defaultPath);
        }
        File file = null;
        file = length == 200 ? ToolFileChooser.selectFileByPath(parent, title, exts, defaultPath, description, fileSelectionMode, isOpenDialog, isWindowsOS, locale) : ToolFileChooser.selectFileByPathDealDot(parent, title, exts, defaultPath, description, fileSelectionMode, isOpenDialog, isWindowsOS, locale, false, length);
        if (file != null) {
            try {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("[Selected file >> " + file.getCanonicalPath() + "][Success]");
                }
                HibernateContainer.getInstance().put(defaultPathIdStr, (Object)file.getCanonicalPath());
            }
            catch (IOException e) {
                LOGGER.error("get canonical path exception: " + e);
            }
        }
        return file;
    }

    public static File selectFile(Window parent, String title, String[] exts, String defaultPathIdStr, String description, int fileSelectionMode, boolean isOpenDialog, boolean isWindowsOS, Locale locale) {
        return ToolFileChooser.selectFile(parent, title, exts, defaultPathIdStr, description, fileSelectionMode, isOpenDialog, isWindowsOS, locale, 200);
    }

    public static File selectFileByPath(Window parent, String title, String[] exts, String defaultPath, String description, int fileSelectionMode, boolean isOpenDialog, boolean isWindowsOS, Locale locale) {
        return ToolFileChooser.selectFileByPathDealDot(parent, title, exts, defaultPath, description, fileSelectionMode, isOpenDialog, isWindowsOS, locale, false);
    }

    public static File selectFileByPathDealDot(Window parent, String title, String[] exts, String defaultPath, String description, int fileSelectionMode, boolean isOpenDialog, boolean isWindowsOS, Locale locale, boolean isDotsupport) {
        String failFileNames = "";
        IsmFileChooser chooser = ToolFileChooser.createIsmFileChooser(title, defaultPath, description, exts);
        int showResult = ToolFileChooser.checkFileChooseWrapper(parent, fileSelectionMode, isOpenDialog, isWindowsOS, chooser);
        if (showResult == 0) {
            boolean ismatch;
            File aFile = chooser.getSelectedFile();
            if (aFile == null) {
                return null;
            }
            String path = null;
            try {
                path = aFile.getCanonicalPath();
            }
            catch (IOException e) {
                LOGGER.error("Get canonical path exception:", (Throwable)e);
                return null;
            }
            if (ToolFileChooser.checkShowInfoDialog(parent, fileSelectionMode, locale, isDotsupport, path)) {
                return null;
            }
            boolean isDirectory = aFile.isDirectory();
            if (!isDirectory && !(ismatch = FileTypeUtils.getInstance().matchFileType(path))) {
                failFileNames = failFileNames + aFile.getName() + System.lineSeparator();
                DialogUtils.showInfoDialog((Window)parent, (String)ResourceUtil.getStringWithParams("filechooser.prompt.file.path.extension.inconsistent.error", failFileNames));
                return null;
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("[Selected file is >> " + path + "][Success]");
            }
            return aFile;
        }
        return null;
    }

    static boolean checkShowInfoDialog(Window parent, int fileSelectionMode, Locale locale, boolean isDotsupport, String path) {
        if (ToolFileChooser.isNwPath(parent, path, locale)) {
            return true;
        }
        if (ToolFileChooser.isNlPath(parent, path, locale)) {
            return true;
        }
        if (!ToolFileChooser.checkSpecialChar(path, fileSelectionMode, isDotsupport)) {
            LOGGER.info("The selected path is invailabe.");
            if (isDotsupport) {
                DialogUtils.showInfoDialog((Window)parent, (String)ResourceUtil.getString("filechooser.prompt.file.path.specialcharacterdealdot"));
            } else {
                DialogUtils.showInfoDialog((Window)parent, (String)ResourceUtil.getString("filechooser.prompt.file.path.specialcharacter"));
            }
            return true;
        }
        if (!ToolFileChooser.checkSelectFile(path, fileSelectionMode)) {
            DialogUtils.showInfoDialog((Window)parent, (String)ResourceUtil.getString("filechooser.prompt.file.error.path"));
            return true;
        }
        if (!ToolFileChooser.checkDiskFreeSpace(path, fileSelectionMode)) {
            LOGGER.info("The selected disk space in not enough.");
            DialogUtils.showInfoDialog((Window)parent, (String)ResourceUtil.getString("filechooser.prompt.file.remind.diskspacenotenough"));
            return true;
        }
        if (!ToolFileChooser.checkPathDeep(path)) {
            LOGGER.info("The path is too long.");
            DialogUtils.showInfoDialog((Window)parent, (String)ResourceUtil.getString("filechooser.prompt.file.max.length"));
            return true;
        }
        return !ToolFileChooser.checkSpace(parent, path);
    }

    static int checkFileChooseWrapper(final Window parent, final int fileSelectionMode, boolean isOpenDialog, boolean isWindowsOS, final IsmFileChooser chooser) {
        chooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String type = evt.getPropertyName();
                String newValue = String.valueOf(evt.getNewValue());
                if ("directoryChanged".equals(type) && newValue.length() > 128) {
                    chooser.cancelSelection();
                    DialogUtils.showInfoDialog((Window)parent, (String)ResourceUtil.getString("filechooser.prompt.file.max.length"));
                }
                if ("directoryChanged".equals(evt.getPropertyName()) && fileSelectionMode == 0) {
                    chooser.setFilenametext("");
                }
            }
        });
        FileChooserWrapper.wrapper((JFileChooser)chooser);
        FileChooserWrapper.setDefaultFileName("", (JFileChooser)chooser, isWindowsOS);
        chooser.setFileSelectionMode(fileSelectionMode);
        int showResult = 0;
        showResult = isOpenDialog ? chooser.showOpenDialog((Component)parent) : chooser.showSaveDialog((Component)parent);
        return showResult;
    }

    public static File selectFileByPathDealDot(Window parent, String title, String[] exts, String defaultPath, String description, int fileSelectionMode, boolean isOpenDialog, boolean isWindowsOS, Locale locale, boolean isDotsupport, int length) {
        String failFileNames = "";
        IsmFileChooser chooser = ToolFileChooser.createIsmFileChooser(title, defaultPath, description, exts);
        ToolFileChooser.checkPropertyChange(parent, fileSelectionMode, isWindowsOS, length, (JFileChooser)chooser);
        int showResult = 0;
        showResult = isOpenDialog ? chooser.showOpenDialog(parent) : chooser.showSaveDialog(parent);
        if (showResult == 0) {
            boolean ismatch;
            File aFile = chooser.getSelectedFile();
            if (aFile == null) {
                return null;
            }
            String path = null;
            path = ToolFileChooser.checkDialogUtil(parent, fileSelectionMode, locale, isDotsupport, length, aFile);
            if (path == null) {
                return null;
            }
            if (!ToolFileChooser.checkSpace(parent, path)) {
                return null;
            }
            boolean isDirectory = aFile.isDirectory();
            if (!isDirectory && !(ismatch = FileTypeUtils.getInstance().matchFileType(path))) {
                failFileNames = failFileNames + aFile.getName() + System.lineSeparator();
                DialogUtils.showInfoDialog((Window)parent, (String)ResourceUtil.getStringWithParams("filechooser.prompt.file.path.extension.inconsistent.error", failFileNames));
                return null;
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("[Selected file is >> " + path + "][Success]");
            }
            return aFile;
        }
        return null;
    }

    static String checkDialogUtil(Window parent, int fileSelectionMode, Locale locale, boolean isDotsupport, int length, File aFile) {
        String path;
        try {
            path = aFile.getCanonicalPath();
        }
        catch (IOException e) {
            LOGGER.error("get canonical path exception: " + e);
            return null;
        }
        if (ToolFileChooser.isNwPath(parent, path, locale)) {
            return null;
        }
        if (ToolFileChooser.isNlPath(parent, path, locale)) {
            return null;
        }
        if (!ToolFileChooser.checkSpecialChar(path, fileSelectionMode, isDotsupport)) {
            LOGGER.info("The selected path is invailabe.");
            if (isDotsupport) {
                DialogUtils.showInfoDialog((Window)parent, (String)ResourceUtil.getString("filechooser.prompt.file.path.specialcharacterdealdot"));
            } else {
                DialogUtils.showInfoDialog((Window)parent, (String)ResourceUtil.getString("filechooser.prompt.file.path.specialcharacter"));
            }
            return null;
        }
        if (!ToolFileChooser.checkSelectFile(path, fileSelectionMode)) {
            DialogUtils.showInfoDialog((Window)parent, (String)ResourceUtil.getString("filechooser.prompt.file.error.path"));
            return null;
        }
        if (!ToolFileChooser.checkDiskFreeSpace(path, fileSelectionMode)) {
            LOGGER.info("The selected disk space in not enough.");
            DialogUtils.showInfoDialog((Window)parent, (String)ResourceUtil.getString("filechooser.prompt.file.remind.diskspacenotenough"));
            return null;
        }
        if (!ToolFileChooser.checkPathDeep(path, length)) {
            LOGGER.info("The path is too long.");
            DialogUtils.showInfoDialog((Window)parent, (String)ResourceUtil.getStringWithParams("filechooser.prompt.file.scene.max.length", String.valueOf(length)));
            return null;
        }
        return path;
    }

    static void checkPropertyChange(final Window parent, int fileSelectionMode, boolean isWindowsOS, final int length, final JFileChooser chooser) {
        chooser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String type = evt.getPropertyName();
                String newValue = String.valueOf(evt.getNewValue());
                if ("directoryChanged".equals(type) && newValue.length() > length) {
                    chooser.cancelSelection();
                    DialogUtils.showInfoDialog((Window)parent, (String)ResourceUtil.getStringWithParams("filechooser.prompt.file.scene.max.length", String.valueOf(length)));
                }
            }
        });
        FileChooserWrapper.wrapper(chooser);
        FileChooserWrapper.setDefaultFileName("", chooser, isWindowsOS);
        chooser.setFileSelectionMode(fileSelectionMode);
    }

    private static boolean checkPathDeep(String path) {
        return path.length() <= 128;
    }

    private static boolean checkPathDeep(String path, int length) {
        return path.length() <= length;
    }

    private static boolean checkDiskFreeSpace(String path, int fileSelectionMode) {
        if (fileSelectionMode != 1) {
            return true;
        }
        File file = new File(path);
        long freeSpace = file.getFreeSpace();
        return freeSpace >= 0x6400000L;
    }

    private static boolean checkSpecialChar(String path, int fileSelectionMode, boolean isSupportDot) {
        if (fileSelectionMode != 1) {
            return true;
        }
        String tempVerifyPath = path;
        if ("Upgrade_FSFW".equals(SceneUtils.getCurrentSubScene())) {
            tempVerifyPath = tempVerifyPath.replaceAll("-", "");
            tempVerifyPath = tempVerifyPath.replaceAll("\\.", "");
        }
        tempVerifyPath = tempVerifyPath.replaceAll("\\\\", "");
        tempVerifyPath = tempVerifyPath.replaceAll("/", "");
        tempVerifyPath = tempVerifyPath.replaceAll(":", "");
        if (isSupportDot) {
            tempVerifyPath = tempVerifyPath.replaceAll("\\.", "");
        }
        if (tempVerifyPath.contains("  ")) {
            return false;
        }
        return tempVerifyPath.matches("[\\w ]+");
    }

    public static String getSaveFilePath(String title, String suffix, Window pDialog, String defaultFileName, String defaultPathId, boolean isWindowsOS, Locale locale) {
        String endFix = "." + suffix;
        Object defaultPathObj = HibernateContainer.getInstance().get(defaultPathId);
        String defaultPath = defaultPathObj != null ? defaultPathObj.toString() : null;
        IsmFileChooser ismFileChooser = new IsmFileChooser(title);
        ismFileChooser.setAcceptAllFileFilterUsed(false);
        ismFileChooser.addFileFilter(new String[]{suffix}, endFix);
        if (!StringUtils.isNULLStr(defaultPath)) {
            File defaultPackagePath = new File(defaultPath);
            ismFileChooser.setCurrentDirectory(defaultPackagePath.isDirectory() ? defaultPackagePath : defaultPackagePath.getParentFile());
        } else {
            ismFileChooser.setCurrentDirectory(null);
        }
        FileChooserWrapper.wrapper((JFileChooser)ismFileChooser);
        FileChooserWrapper.setDefaultFileName(defaultFileName, (JFileChooser)ismFileChooser, isWindowsOS);
        int resultCode = ismFileChooser.showSaveDialog((Component)pDialog);
        if (resultCode != 0) {
            return null;
        }
        File selectedFile = ismFileChooser.getSelectedFile();
        if (selectedFile == null) {
            return null;
        }
        String filePath = ToolFileChooser.checkDialogUtils(pDialog, defaultPathId, locale, endFix, selectedFile);
        if (filePath == null) {
            return null;
        }
        return filePath;
    }

    static String checkDialogUtils(Window pDialog, String defaultPathId, Locale locale, String endFix, File selectedFile) {
        String filePath = null;
        try {
            filePath = selectedFile.getCanonicalPath();
        }
        catch (IOException e) {
            LOGGER.error("Get canonical path exception:", (Throwable)e);
            return null;
        }
        if (ToolFileChooser.isNwPath(pDialog, filePath, locale)) {
            return null;
        }
        if (ToolFileChooser.isNlPath(pDialog, filePath, locale)) {
            return null;
        }
        if (filePath.endsWith(".")) {
            int index = filePath.lastIndexOf(".");
            filePath = filePath.substring(0, index);
        }
        if (!filePath.endsWith(endFix)) {
            filePath = filePath + endFix;
        }
        if (filePath.length() > 200 && ApplicationContext.getInstance().isFileChooserPathLenLimit()) {
            DialogUtils.showInfoDialog((Window)pDialog, (String)UiResource.getInstance().getString(locale, "filechooser.prompt.file.max.length"));
            return null;
        }
        if (!ToolFileChooser.checkSpace(pDialog, filePath)) {
            return null;
        }
        HibernateContainer.getInstance().put(defaultPathId, (Object)filePath);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("[Save file path >> " + FileUtils.filterLogIfComputerName(filePath) + "][Success]");
        }
        return filePath;
    }

    private static boolean isNwPath(Window parent, String path, Locale locale) {
        if (path.startsWith("\\")) {
            DialogUtils.showInfoDialog((Window)parent, (String)UiResource.getInstance().getString(locale, "filechooser.prompt.file.network.path"));
            return true;
        }
        return false;
    }

    private static boolean isNlPath(Window parent, String path, Locale locale) {
        if (path.toLowerCase(Locale.getDefault()).contains(NETWORKPATH)) {
            DialogUtils.showInfoDialog((Window)parent, (String)UiResource.getInstance().getString(locale, "filechooser.prompt.file.network.path"));
            return true;
        }
        return false;
    }

    private static boolean checkSpace(Window parent, String path) {
        if (path.contains("  ")) {
            DialogUtils.showInfoDialog((Window)parent, (String)ResourceUtil.getString("filechooser.prompt.file.path.black"));
            return false;
        }
        return true;
    }

    private static boolean checkSelectFile(String path, int fileSelectionMode) {
        if (fileSelectionMode != 1) {
            return true;
        }
        File checkFile = new File(path + File.separator + "CheckFile");
        boolean checkSucc = checkFile.mkdirs();
        if (!checkSucc) {
            return false;
        }
        if (!checkFile.delete()) {
            LOGGER.info("Delete checkFile failed.");
        }
        return true;
    }
}

