/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.channel.upload.entity;

import com.huawei.ism.tool.channel.upload.entity.UploadStatus;
import com.huawei.ism.tool.channel.upload.entity.UploadTask;
import java.io.File;
import java.math.BigDecimal;
import java.text.DecimalFormat;

public class UploadProcess {
    private static final int PRECENT_RATIO = 100;
    private static final double SECOND = 1000.0;
    private static final int BYTE_UNIT = 1024;
    private static final int TIME_UNIT = 60;
    private static final int ACCURACY = 4;
    private long taskId;
    private String fileId;
    private String compressPath;
    private long fileSize;
    private long fileBreakpoint;
    private double percent;
    private long leftTime;
    private long speed;
    private UploadStatus status;
    private String description;
    private String detailZh;
    private String detailEn;
    private long costTime;

    public UploadProcess() {
    }

    public UploadProcess(UploadTask task) {
        this.taskId = task.getTaskId();
        this.status = UploadStatus.WAITING;
        File file = new File(task.getFileFullPath());
        this.fileSize = file.length();
    }

    public void setCompressPath(String compressPath) {
        this.compressPath = compressPath;
    }

    public String getCompressPath() {
        return this.compressPath;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public long getFileBreakpoint() {
        return this.fileBreakpoint;
    }

    public void setFileBreakpoint(long fileBreakpoint) {
        this.fileBreakpoint = fileBreakpoint;
    }

    public double getPercent() {
        return this.percent;
    }

    public long getLeftTime() {
        return this.leftTime;
    }

    public void setLeftTime(long leftTime) {
        this.leftTime = leftTime;
    }

    public long getSpeed() {
        return this.speed;
    }

    public void setSpeed(long speed) {
        this.speed = speed;
    }

    public UploadStatus getStatus() {
        return this.status;
    }

    public void setStatus(UploadStatus status) {
        this.status = status;
        if (status == UploadStatus.FINISHED) {
            this.percent = 1.0;
            this.leftTime = 0L;
            this.speed = 0L;
            this.description = "";
            this.detailEn = "";
            this.detailZh = "";
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDetailZh() {
        return this.detailZh;
    }

    public void setDetailZh(String detailZh) {
        this.detailZh = detailZh;
    }

    public String getDetailEn() {
        return this.detailEn;
    }

    public void setDetailEn(String detailEn) {
        this.detailEn = detailEn;
    }

    public String getDescription() {
        return this.description;
    }

    public long getTaskId() {
        return this.taskId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public String getFileId() {
        return this.fileId;
    }

    public boolean isFailed() {
        return this.status == UploadStatus.FAILED;
    }

    public boolean isFinished() {
        return this.status == UploadStatus.FINISHED;
    }

    public void setPercent(long totalSize, long uploadedSize) {
        if (totalSize == 0L) {
            return;
        }
        try {
            double percentd = (double)uploadedSize / (double)totalSize;
            this.percent = percentd = Double.parseDouble(new DecimalFormat("0.0000").format(percentd));
        }
        catch (NumberFormatException e) {
            this.percent = 0.0;
        }
    }

    public String getPercentStr() {
        String percentStr;
        int len = (percentStr = this.percent * 100.0 + "").length();
        percentStr = percentStr.substring(0, len > 4 ? 4 : len);
        return percentStr + "%";
    }

    public void setSpeed(long costTimes, long uploadedSize) {
        if (costTimes == 0L) {
            return;
        }
        double speedd = (double)uploadedSize / ((double)costTimes / 1000.0);
        speedd = Math.round(speedd);
        this.speed = (long)speedd;
    }

    public String getSpeedStr() {
        double kiloByte = (double)this.speed / 1024.0;
        if (kiloByte < 1.0) {
            return this.speed + " B/s";
        }
        double megaByte = kiloByte / 1024.0;
        if (megaByte < 1.0) {
            BigDecimal result1 = new BigDecimal(Double.toString(kiloByte));
            return Math.round(result1.doubleValue()) + " KB/s";
        }
        BigDecimal result2 = new BigDecimal(Double.toString(megaByte));
        return Math.round(result2.doubleValue()) + " MB/s";
    }

    public void setLeftTimeBySize(long remainSize) {
        if (this.speed == 0L) {
            return;
        }
        this.leftTime = remainSize / this.speed;
    }

    public String getLeftTimeStr() {
        double second = (double)this.leftTime / 60.0;
        if (second < 1.0) {
            return this.leftTime + " Second";
        }
        double min = second / 60.0;
        if (min < 1.0) {
            BigDecimal result1 = new BigDecimal(Double.toString(second));
            return Math.round(result1.doubleValue()) + " Min";
        }
        double hour = min / 60.0;
        if (hour < 1.0) {
            BigDecimal result2 = new BigDecimal(Double.toString(min));
            return Math.round(result2.doubleValue()) + " Hour";
        }
        double day = hour / 60.0;
        if (day < 1.0) {
            BigDecimal result3 = new BigDecimal(Double.toString(hour));
            return Math.round(result3.doubleValue()) + " Day";
        }
        BigDecimal result4 = new BigDecimal(Double.toString(min));
        return Math.round(result4.doubleValue()) + " Month";
    }

    public long getCostTime() {
        return this.costTime;
    }

    public void setCostTime(long costTime) {
        this.costTime = costTime;
    }
}

