/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.channel.upload.task;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.channel.upload.UploadContext;
import com.huawei.ism.tool.channel.upload.entity.UploadProcess;
import com.huawei.ism.tool.channel.upload.entity.UploadStatus;
import com.huawei.ism.tool.channel.upload.entity.UploadTask;
import com.huawei.ism.tool.channel.upload.entity.UploadTaskType;
import com.huawei.ism.tool.channel.upload.service.HttpsPrepareService;
import com.huawei.ism.tool.channel.upload.utils.FileCompressUtil;
import com.huawei.ism.tool.https.conn.HttpsConnManager;
import com.huawei.ism.tool.https.utils.IndicatorUtils;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import javax.net.ssl.HttpsURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpsUploadHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpsUploadHandler.class);
    private static final String RESP_COSTTIME = "costTime";
    private static final String RESP_FILEID = "fileId";
    private static final long UPLOAD_LOOP_CYCLE = 1000L;
    private static final int ONE_TIME_BYTES = 1024;
    private static final int FINISH_POINT = -1;
    long totalTime = 0L;

    public void executeUploadTask(HttpsURLConnection connection, UploadTask task, UploadProcess uploadProcess) {
        long totalSize;
        File file = this.handleUploadFile(connection, task, uploadProcess);
        long breakPoint = uploadProcess.getFileBreakpoint();
        if (breakPoint >= (totalSize = uploadProcess.getFileSize())) {
            LOGGER.error("the file breakPoint is bigger than totalSize.");
        }
        ParameterForUploadStream parameterForUploadStream = new ParameterForUploadStream();
        parameterForUploadStream.setConnection(connection);
        parameterForUploadStream.setTask(task);
        parameterForUploadStream.setUploadProcess(uploadProcess);
        parameterForUploadStream.setFile(file);
        parameterForUploadStream.setBreakPoint(breakPoint);
        parameterForUploadStream.setTotalSize(totalSize);
        this.processUploadStream(parameterForUploadStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUploadStream(ParameterForUploadStream parameterForUploadStream) {
        try {
            if (parameterForUploadStream.getBreakPoint() >= parameterForUploadStream.getTotalSize() || parameterForUploadStream.getBreakPoint() == -1L) {
                parameterForUploadStream.getUploadProcess().setStatus(UploadStatus.FINISHED);
                this.handleReponse(parameterForUploadStream.getConnection(), parameterForUploadStream.getTask(), parameterForUploadStream.getUploadProcess(), true);
                String logStr = "the file has finished uploaded";
                String logStr1 = this.taskCanStart(parameterForUploadStream.getTask(), parameterForUploadStream.getUploadProcess(), parameterForUploadStream.getTotalSize(), logStr);
                HttpsConnManager.getInstance().isHttpsResponseSuccess(parameterForUploadStream.getConnection());
                UploadContext.getInstance().setUploadProcess(parameterForUploadStream.getUploadProcess());
                LOGGER.info(logStr1);
                return;
            }
            parameterForUploadStream.setOutStream(new DataOutputStream(parameterForUploadStream.getConnection().getOutputStream()));
            parameterForUploadStream.setAccessFile(new RandomAccessFile(parameterForUploadStream.getFile(), "r"));
            this.processFileUpload(parameterForUploadStream.getConnection(), parameterForUploadStream.getTask(), parameterForUploadStream.getUploadProcess(), parameterForUploadStream.getBreakPoint(), parameterForUploadStream.getTotalSize(), parameterForUploadStream.getOutStream(), parameterForUploadStream.getAccessFile());
        }
        catch (IOException e) {
            parameterForUploadStream.getTask().setTaskFailed(true);
            parameterForUploadStream.getUploadProcess().setStatus(UploadStatus.FAILED);
            if (parameterForUploadStream.getTask().getListener() != null) {
                parameterForUploadStream.getTask().getListener().notifyUploadProcess(parameterForUploadStream.getUploadProcess());
            }
            LOGGER.error("IOException while uploading");
        }
        finally {
            this.closeAccessFile(parameterForUploadStream.getAccessFile());
            StreamUtils.closeStream((OutputStream)parameterForUploadStream.getOutStream(), null);
            parameterForUploadStream.getConnection().disconnect();
            parameterForUploadStream.getTask().setStartTask(false);
        }
    }

    private void processFileUpload(HttpsURLConnection connection, UploadTask task, UploadProcess uploadProcess, long breakPoint, long totalSize, DataOutputStream outStream, RandomAccessFile accessFile) throws IOException {
        LOGGER.info("seek file from breakpoint:{}", (Object)breakPoint);
        accessFile.seek(breakPoint);
        long remainTotalSize = totalSize - breakPoint;
        long startTime = System.currentTimeMillis();
        long lastRefreshTime = System.currentTimeMillis();
        IndicatorUtils uploadedSize = new IndicatorUtils(0L);
        long lastUploadedSize = 0L;
        byte[] buffer = new byte[1024];
        IndicatorUtils isFinished = new IndicatorUtils(false);
        this.startToUpload(task, uploadProcess, breakPoint, totalSize, outStream, accessFile, remainTotalSize, startTime, lastRefreshTime, uploadedSize, lastUploadedSize, buffer, isFinished);
        long endTime = System.currentTimeMillis();
        outStream.flush();
        String logStr = "the file has finished uploaded";
        String logStr1 = this.taskCanStart(task, uploadProcess, totalSize, logStr);
        this.totalTime = endTime - startTime;
        this.handleReponse(connection, task, uploadProcess, isFinished.getFlag());
        LOGGER.info("{}, total uploaded {} bytes and cost {}s", logStr1, uploadedSize, endTime - startTime);
    }

    private void startToUpload(UploadTask task, UploadProcess uploadProcess, long breakPoint, long totalSize, DataOutputStream outStream, RandomAccessFile accessFile, long remainTotalSize, long startTime, long lastRefreshTime, IndicatorUtils uploadedSize, long lastUploadedSize, byte[] buffer, IndicatorUtils isFinished) throws IOException {
        long iterLastUploadedSize = lastUploadedSize;
        long iterLastRefreshTime = lastRefreshTime;
        while (!this.chanceToBreak(task, uploadProcess, remainTotalSize, uploadedSize, isFinished)) {
            int curUploadedSize = 0;
            curUploadedSize = uploadedSize.getLongCounter() + (long)buffer.length > remainTotalSize ? accessFile.read(buffer, 0, (int)(remainTotalSize - uploadedSize.getLongCounter())) : accessFile.read(buffer);
            if (this.uploadFinished(outStream, uploadedSize, buffer, isFinished, curUploadedSize)) break;
            long curTime = System.currentTimeMillis();
            if (curTime - iterLastRefreshTime <= 1000L) continue;
            uploadProcess.setStatus(UploadStatus.UPLOADING);
            uploadProcess.setPercent(totalSize, breakPoint + uploadedSize.getLongCounter());
            uploadProcess.setSpeed(curTime - iterLastRefreshTime, uploadedSize.getLongCounter() - iterLastUploadedSize);
            uploadProcess.setLeftTimeBySize(remainTotalSize - uploadedSize.getLongCounter());
            uploadProcess.setCostTime(iterLastRefreshTime - startTime);
            UploadContext.getInstance().setUploadProcess(uploadProcess);
            iterLastRefreshTime = curTime;
            iterLastUploadedSize = uploadedSize.getLongCounter();
            LOGGER.info("the file has uploaded {} bytes from {} bytes, percent: {}, speed: {}B/s, leftTime: {}s", uploadedSize, breakPoint, uploadProcess.getPercentStr(), uploadProcess.getSpeed(), uploadProcess.getLeftTime());
            if (task.getListener() == null) continue;
            task.getListener().notifyUploadProcess(uploadProcess);
        }
    }

    private boolean uploadFinished(DataOutputStream outStream, IndicatorUtils uploadedSize, byte[] buffer, IndicatorUtils isFinished, int curUploadedSize) throws IOException {
        if (outStream == null) {
            LOGGER.error("DataOutputStream is null.");
            return false;
        }
        if (curUploadedSize == -1) {
            isFinished.setFlag(true);
            LOGGER.info("the file has finished uploaded, file read has reach the end.");
            return true;
        }
        outStream.write(buffer, 0, curUploadedSize);
        outStream.flush();
        uploadedSize.setLongCounter(uploadedSize.getLongCounter() + (long)curUploadedSize);
        return false;
    }

    private boolean chanceToBreak(UploadTask task, UploadProcess uploadProcess, long remainTotalSize, IndicatorUtils uploadedSize, IndicatorUtils isFinished) {
        if (uploadedSize.getLongCounter() >= remainTotalSize) {
            isFinished.setFlag(true);
            LOGGER.info("the file has finished uploaded, the uploaded size is larger.");
            return true;
        }
        if (!task.isTaskCanStart()) {
            LOGGER.info("the task has been canceled while uploading:{}", (Object)task.getTaskId());
            UploadContext.getInstance().setUploadProcess(uploadProcess);
            return true;
        }
        return false;
    }

    private void closeAccessFile(RandomAccessFile accessFile) {
        if (accessFile != null) {
            try {
                accessFile.close();
            }
            catch (IOException e) {
                LOGGER.error("close access file error");
            }
        }
    }

    private String taskCanStart(UploadTask task, UploadProcess uploadProcess, long totalSize, String logStr) {
        String logContent = logStr;
        if (!task.isTaskCanStart()) {
            logContent = "the file has been canceled";
            uploadProcess.setStatus(UploadStatus.CANCELED);
            if (task.getListener() != null) {
                task.getListener().notifyUploadProcess(uploadProcess);
            }
        } else if (uploadProcess.getStatus() == UploadStatus.FAILED) {
            logContent = "the file upload failed";
            uploadProcess.setStatus(UploadStatus.FAILED);
            task.setTaskFailed(true);
            task.setStartTask(false);
            if (task.getListener() != null) {
                task.getListener().notifyUploadProcess(uploadProcess);
            }
        } else {
            uploadProcess.setStatus(UploadStatus.FINISHED);
            uploadProcess.setPercent(totalSize, totalSize);
            if (task.getListener() != null) {
                task.getListener().notifyUploadProcess(uploadProcess);
            }
        }
        return logContent;
    }

    public HttpsURLConnection prepareUploadTask(UploadProcess uploadProcess, UploadTask task) {
        if (uploadProcess.isFailed()) {
            LOGGER.info("prepare upload task failed.");
            return null;
        }
        long breakPoint = HttpsPrepareService.getInstance().prepareTrans(uploadProcess, task);
        uploadProcess.setFileBreakpoint(breakPoint);
        if (uploadProcess.isFailed()) {
            LOGGER.info("prepare upload task failed , after getting break point");
            return null;
        }
        HttpsURLConnection connection = HttpsPrepareService.getInstance().establishConnection(uploadProcess, task);
        if (uploadProcess.isFailed()) {
            LOGGER.info("prepare upload task failed , after establish connection");
            return null;
        }
        uploadProcess.setStatus(UploadStatus.UPLOADING);
        uploadProcess.setPercent(uploadProcess.getFileSize(), breakPoint);
        uploadProcess.setLeftTime(0L);
        uploadProcess.setSpeed(0L);
        return connection;
    }

    public void handleReponse(HttpsURLConnection connection, UploadTask task, UploadProcess uploadProcess, boolean isFinished) {
        if (!HttpsConnManager.getInstance().isHttpsResponseSuccess(connection)) {
            uploadProcess.setStatus(UploadStatus.FAILED);
            uploadProcess.setDescription("upload.http.response.error");
            if (!task.isTaskCanStart()) {
                uploadProcess.setStatus(UploadStatus.CANCELED);
                uploadProcess.setDescription("");
            }
            UploadContext.getInstance().setUploadProcess(uploadProcess);
            return;
        }
        int resultCode = 3;
        resultCode = Integer.parseInt(HttpsConnManager.getInstance().getHttpsResponseParams(connection, "resultCode"));
        if (resultCode == 3) {
            uploadProcess.setStatus(UploadStatus.FAILED);
            uploadProcess.setDescription("upload.http.response.error");
            uploadProcess.setDetailZh(HttpsConnManager.getInstance().getHttpsResponseParams(connection, "reasonZh"));
            uploadProcess.setDetailEn(HttpsConnManager.getInstance().getHttpsResponseParams(connection, "reasonEn"));
            uploadProcess.setFileId(HttpsConnManager.getInstance().getHttpsResponseParams(connection, RESP_FILEID));
            LOGGER.error("response error:{} :details:{}", (Object)"upload.http.response.error", (Object)StringUtils.getCleanMessage((String)uploadProcess.getDetailEn()));
        }
        if (isFinished && resultCode != 3) {
            uploadProcess.setStatus(UploadStatus.FINISHED);
            uploadProcess.setCostTime(this.totalTime);
        }
        UploadContext.getInstance().setUploadProcess(uploadProcess);
    }

    private File handleUploadFile(HttpsURLConnection connection, UploadTask task, UploadProcess uploadProcess) {
        if (task.getUploadTaskType().equals((Object)UploadTaskType.TOOLOPERATIONS) || task.getUploadTaskType().equals((Object)UploadTaskType.FEEDBACK)) {
            return this.handUserOperationFile(connection, task, uploadProcess);
        }
        return this.handFileUploadFile(connection, task, uploadProcess);
    }

    private File handUserOperationFile(HttpsURLConnection connection, UploadTask task, UploadProcess uploadProcess) {
        File file = new File(task.getFileFullPath());
        if (uploadProcess.getFileBreakpoint() != -1L) {
            this.setConnection(connection, uploadProcess.getFileSize(), uploadProcess.getFileBreakpoint());
        }
        return file;
    }

    private File handFileUploadFile(HttpsURLConnection connection, UploadTask task, UploadProcess uploadProcess) {
        File file = FileCompressUtil.compressUploadFile(task.getFileFullPath(), task.getFileName());
        if (file == null) {
            file = new File(task.getFileFullPath());
            HttpsPrepareService.getInstance().setFileNameParams(connection, task.getFileName(), file.getName(), file.length());
        } else {
            uploadProcess.setFileSize(file.length());
            HttpsPrepareService.getInstance().setFileNameParams(connection, task.getFileName(), file.getName(), file.length());
            try {
                uploadProcess.setCompressPath(file.getCanonicalPath());
            }
            catch (IOException e) {
                LOGGER.error("get compress file canonicalPath error.");
            }
        }
        if (uploadProcess.getFileBreakpoint() != -1L) {
            this.setConnection(connection, uploadProcess.getFileSize(), uploadProcess.getFileBreakpoint());
        }
        return file;
    }

    private void setConnection(HttpsURLConnection connection, long fileSize, long breakPoint) {
        connection.setFixedLengthStreamingMode(fileSize - breakPoint);
        connection.setUseCaches(false);
        connection.setAllowUserInteraction(false);
    }

    private static class ParameterForUploadStream {
        private HttpsURLConnection connection;
        private UploadTask task;
        private UploadProcess uploadProcess;
        private File file;
        private long breakPoint;
        private long totalSize;
        private DataOutputStream outStream;
        private RandomAccessFile accessFile;

        private ParameterForUploadStream() {
        }

        private HttpsURLConnection getConnection() {
            return this.connection;
        }

        private void setConnection(HttpsURLConnection connection) {
            this.connection = connection;
        }

        private UploadTask getTask() {
            return this.task;
        }

        private void setTask(UploadTask task) {
            this.task = task;
        }

        private UploadProcess getUploadProcess() {
            return this.uploadProcess;
        }

        private void setUploadProcess(UploadProcess uploadProcess) {
            this.uploadProcess = uploadProcess;
        }

        private File getFile() {
            return this.file;
        }

        private void setFile(File file) {
            this.file = file;
        }

        private long getBreakPoint() {
            return this.breakPoint;
        }

        private void setBreakPoint(long breakPoint) {
            this.breakPoint = breakPoint;
        }

        private long getTotalSize() {
            return this.totalSize;
        }

        private void setTotalSize(long totalSize) {
            this.totalSize = totalSize;
        }

        private DataOutputStream getOutStream() {
            return this.outStream;
        }

        private void setOutStream(DataOutputStream outStream) {
            this.outStream = outStream;
        }

        private RandomAccessFile getAccessFile() {
            return this.accessFile;
        }

        private void setAccessFile(RandomAccessFile accessFile) {
            this.accessFile = accessFile;
        }
    }
}

