/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.channel.upload.utils;

import com.huawei.ism.tool.base.utils.ZipUtils;
import com.huawei.ism.tool.channel.utils.HttpsPropUtils;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.File;

public class FileCompressUtil {
    private static final String COMP_SAVE_PATH = "upload";
    private static final String ZIP = ".zip";

    private FileCompressUtil() {
    }

    public static File compressUploadFile(String fileFullPath, String fileName) {
        if (StringUtils.isNULLStr(fileFullPath) || StringUtils.isNULLStr(fileName)) {
            return null;
        }
        String fileType = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
        if (HttpsPropUtils.isCompFileType(fileType)) {
            return null;
        }
        if (!FileCompressUtil.initCompFolder()) {
            return null;
        }
        String zipFileName = fileName.substring(0, fileName.lastIndexOf(".")) + ZIP;
        String zipFilePath = FileCompressUtil.getCompFolderPath() + zipFileName;
        boolean isSuccess = ZipUtils.compressFile((String)zipFilePath, (String)fileFullPath);
        return isSuccess ? new File(zipFilePath) : null;
    }

    public static String getUploadFileName(String fileFullPath, String fileName) {
        if (StringUtils.isNULLStr(fileName) || StringUtils.isNULLStr(fileFullPath)) {
            return null;
        }
        String fileType = fileName.substring(fileName.lastIndexOf(".") + 1, fileName.length());
        if (HttpsPropUtils.isCompFileType(fileType)) {
            return null;
        }
        if (!FileCompressUtil.initCompFolder()) {
            return null;
        }
        String zipFileName = fileName.substring(0, fileName.lastIndexOf(".")) + ZIP;
        return zipFileName;
    }

    private static boolean initCompFolder() {
        String path = FileCompressUtil.getCompFolderPath();
        File pubFoler = new File(path);
        return pubFoler.exists() || pubFoler.mkdir();
    }

    private static String getCompFolderPath() {
        String workPath;
        StringBuffer sb = new StringBuffer();
        String userDataPath = ApplicationContext.getInstance().getUserDataPath();
        String filePath = workPath = ApplicationContext.getInstance().getWorkPath();
        sb.append(filePath).append(File.separator);
        sb.append(userDataPath);
        sb.append(File.separatorChar);
        sb.append(COMP_SAVE_PATH);
        sb.append(File.separatorChar);
        return sb.toString();
    }
}

