/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.channel.utils;

import com.huawei.ism.tool.base.utils.ResourceUtil;
import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.slf4j.Logger;

public final class HttpsPropUtils {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(HttpsPropUtils.class);
    private static final String DEFAULT_URL_DOMAIN = ResourceUtil.getString((String)"default.smartkit.url");
    private static final String INTERNET_PARAMS_CFG = "config/https/https.properties";
    private static final String HTTPS_FILE_PREPARE_URL = "https.file.prepare.url";
    private static final String HTTPS_FILE_UPLOAD_URL = "https.file.upload.url";
    private static final String HTTPS_FILE_TEST_URL = "https.file.test.url";
    private static final String HTTPS_UPLOAD_IPCHECK_URL = "https.upload.ipcheck.url";
    private static final String HTTPS_UPLOAD_CHECKDEVICE_URL = "https.upload.checkdevice.url";
    private static final String DEFAULT_FILE_PREPARE_URL = ":443/uploadGateway/prepare";
    private static final String DEFAULT_FILE_UPLOAD_URL = ":443/uploadGateway/upload";
    private static final String DEFAULT_FILE_TEST_URL = ":443/uploadGateway/test";
    private static final String DEFAULT_UPLOAD_IPCHECK_URL = "/uploadGateway/getIpInfo";
    private static final String DEFAULT_UPLOAD_CHECKDEVICE_URL = "/v1/archive/info/base/checkdevice";
    private static final String HTTPS_URL_DOMAIN = "https.url.domain";
    private static final String HTTPS_SPARE_URL_DOMAIN = "https.url.sparedomain";
    private static final String HTTPS_CERT_APPLY_URL = "https.cert.apply.url";
    private static final String DEFAULT_CERT_APPLY_URL = ":7445/Certificate/applyCertificate";
    private static final String HTTPS_UPLOAD_ALLOW_FILE_COMPRESS_TYPE = "https.upload.allow.file.compress.type";
    private static final String DEFAULT_ALLOW_FILE_COMPRESS_TYPE = "zip,rar,7z,bz2,gz,tar,wim,xz";
    private static final String HTTPS_UPLOAD_ALLOW_FILE_NONECOMP_TYPE = "https.upload.allow.file.nonecomp.type";
    private static final String DEFAULT_ALLOW_FILE_NONECOMP_TYPE = "log,txt";
    private static final String SPLITER = ",";
    private static final String CONF_UPLOAD_FILE_TYPE = "conf.upload.file.type";
    private static final String DEFAULT_CONF_UPLOAD_FILE_TYPE = "zip,rar,7z,bz2,gz,tar,wim,xz,log,txt,xml";
    private static final String TOOLSFOLDER = "tools";
    private static final int DEFAULT_INTERNT_PORT = 8080;
    private static final String PUBLICKEY_VALUEKEY = "channel.upload.publickey.version";
    private static final String CERT_FILE_DIR = "https.cert.file.dir";
    private static Properties properties = new Properties();

    private HttpsPropUtils() {
    }

    public static String getPropValue(String key, String defaultValue) {
        if (StringUtils.isNULLStr(key) || !properties.containsKey(key)) {
            return defaultValue;
        }
        String value = properties.getProperty(key);
        if (StringUtils.isNULLStr(value)) {
            return defaultValue;
        }
        return value;
    }

    public static List<String> getAllowCompFileTypes() {
        String fileTypeStr = HttpsPropUtils.getPropValue(HTTPS_UPLOAD_ALLOW_FILE_COMPRESS_TYPE, DEFAULT_ALLOW_FILE_COMPRESS_TYPE);
        String[] fileTypeArray = fileTypeStr.split(SPLITER);
        ArrayList<String> fileTypeList = new ArrayList<String>();
        for (String fileType : fileTypeArray) {
            fileTypeList.add(fileType.toUpperCase(Locale.ENGLISH));
        }
        return fileTypeList;
    }

    public static List<String> getUploadFileType() {
        String fileTypeStr = HttpsPropUtils.getPropValue(CONF_UPLOAD_FILE_TYPE, DEFAULT_CONF_UPLOAD_FILE_TYPE);
        String[] fileTypeStrList = fileTypeStr.split(SPLITER);
        ArrayList<String> fileTypeList = new ArrayList<String>();
        for (String fileType : fileTypeStrList) {
            fileTypeList.add(fileType.toUpperCase(Locale.ENGLISH));
        }
        return fileTypeList;
    }

    public static List<String> getAllowNoneCompFileTypes() {
        String fileTypeStr = HttpsPropUtils.getPropValue(HTTPS_UPLOAD_ALLOW_FILE_NONECOMP_TYPE, DEFAULT_ALLOW_FILE_NONECOMP_TYPE);
        String[] fileTypeArray = fileTypeStr.split(SPLITER);
        ArrayList<String> fileTypeList = new ArrayList<String>();
        for (String fileType : fileTypeArray) {
            fileTypeList.add(fileType.toUpperCase(Locale.ENGLISH));
        }
        return fileTypeList;
    }

    public static List<String> getAllowFileTypes() {
        List<String> fileTypeList = HttpsPropUtils.getAllowCompFileTypes();
        fileTypeList.addAll(HttpsPropUtils.getAllowNoneCompFileTypes());
        return fileTypeList;
    }

    public static boolean isAllowFileType(String fileType) {
        if (StringUtils.isNULLStr(fileType)) {
            return false;
        }
        List<String> fileTypeList = HttpsPropUtils.getAllowFileTypes();
        return fileTypeList.contains(fileType.toUpperCase(Locale.ENGLISH));
    }

    public static boolean isCompFileType(String fileType) {
        if (StringUtils.isNULLStr(fileType)) {
            return false;
        }
        List<String> fileTypeList = HttpsPropUtils.getAllowCompFileTypes();
        return fileTypeList.contains(fileType.toUpperCase(Locale.ENGLISH));
    }

    public static String getFileTransUrl() {
        return HttpsPropUtils.getGreenHttpsDomain() + HttpsPropUtils.getPropValue(HTTPS_FILE_UPLOAD_URL, DEFAULT_FILE_UPLOAD_URL);
    }

    public static String getFilePrepareUrl(String domain) {
        String validDomain = StringUtils.isNULLStr(domain) ? DEFAULT_URL_DOMAIN : domain;
        return validDomain + HttpsPropUtils.getPropValue(HTTPS_FILE_PREPARE_URL, DEFAULT_FILE_PREPARE_URL);
    }

    public static String getCertRequestUrl() {
        return HttpsPropUtils.getGreenHttpsDomain() + HttpsPropUtils.getPropValue(HTTPS_CERT_APPLY_URL, DEFAULT_CERT_APPLY_URL);
    }

    public static String getSpareCertRequestUrl() {
        return HttpsPropUtils.getYellowHttpsDomain() + HttpsPropUtils.getPropValue(HTTPS_CERT_APPLY_URL, DEFAULT_CERT_APPLY_URL);
    }

    public static String getUploadIpCheckRequestUrl() {
        return HttpsPropUtils.getGreenHttpsDomain() + HttpsPropUtils.getPropValue(HTTPS_UPLOAD_IPCHECK_URL, DEFAULT_UPLOAD_IPCHECK_URL);
    }

    public static String getSpareUploadIpCheckRequestUrl() {
        return HttpsPropUtils.getYellowHttpsDomain() + HttpsPropUtils.getPropValue(HTTPS_UPLOAD_IPCHECK_URL, DEFAULT_UPLOAD_IPCHECK_URL);
    }

    public static String getCheckDeviceRequestUrl() {
        return HttpsPropUtils.getGreenHttpsDomain() + HttpsPropUtils.getPropValue(HTTPS_UPLOAD_CHECKDEVICE_URL, DEFAULT_UPLOAD_CHECKDEVICE_URL);
    }

    public static String getSpareCheckDeviceRequestUrl() {
        return HttpsPropUtils.getYellowHttpsDomain() + HttpsPropUtils.getPropValue(HTTPS_UPLOAD_CHECKDEVICE_URL, DEFAULT_UPLOAD_CHECKDEVICE_URL);
    }

    public static String getFileTestUrl() {
        return HttpsPropUtils.getGreenHttpsDomain() + HttpsPropUtils.getPropValue(HTTPS_FILE_TEST_URL, DEFAULT_FILE_TEST_URL);
    }

    private static void init() {
        ClassLoader cl = HttpsPropUtils.class.getClassLoader();
        InputStream inputStream = null;
        try {
            if (null == cl) {
                LOGGER.error("get class loader exception.");
                return;
            }
            inputStream = cl.getResourceAsStream(INTERNET_PARAMS_CFG);
            properties.load(inputStream);
        }
        catch (IOException e) {
            LOGGER.error("get channel params exception.");
        }
        finally {
            if (null != inputStream) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("close inputstream error.");
                }
            }
        }
    }

    private static String getGreenHttpsDomain() {
        String domain = HttpsPropUtils.getPropValue(HTTPS_URL_DOMAIN, DEFAULT_URL_DOMAIN);
        if (StringUtils.isNULLStr(domain)) {
            domain = DEFAULT_URL_DOMAIN;
        }
        return domain;
    }

    private static String getYellowHttpsDomain() {
        String domain = HttpsPropUtils.getPropValue(HTTPS_SPARE_URL_DOMAIN, DEFAULT_URL_DOMAIN);
        if (StringUtils.isNULLStr(domain)) {
            domain = DEFAULT_URL_DOMAIN;
        }
        return domain;
    }

    public static String getPublicKeyVersioin() {
        String publicKey = HttpsPropUtils.getPropValue(PUBLICKEY_VALUEKEY, "");
        return publicKey;
    }

    public static File getCurrWorkPath() {
        File updatChecker;
        String workPathStr = ApplicationContext.getInstance().getWorkPath();
        File workPath = null;
        if (null != workPathStr && (updatChecker = new File(workPath = new File(workPathStr), "updatechecker.exe")).exists()) {
            return workPath.getParentFile();
        }
        int index = -1;
        if (null != workPath && workPath.length() > 0L) {
            String tempPath = Normalizer.normalize(TOOLSFOLDER, Normalizer.Form.NFKC);
            index = workPathStr.lastIndexOf(tempPath);
        }
        if (-1 != index) {
            workPathStr = workPathStr.substring(0, index - 1);
        }
        if (StringUtils.isNULLStr(workPathStr)) {
            return workPath;
        }
        return new File(workPathStr);
    }

    public static boolean parseBoolean(Properties prop, String key, boolean defaultValue) {
        String value = prop.getProperty(key);
        if (StringUtils.isNULLStr(value)) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public static String parseString(Properties prop, String key, String defaultValue) {
        String value = prop.getProperty(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static int parsePort(Properties prop, String key) {
        String value = prop.getProperty(key);
        if (StringUtils.isNULLStr(value)) {
            return 8080;
        }
        return Integer.parseInt(value);
    }

    public static String getCertFileDir() {
        return HttpsPropUtils.getPropValue(CERT_FILE_DIR, "certdir");
    }

    static {
        HttpsPropUtils.init();
    }
}

