/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.pyengine.engine;

import com.huawei.ism.tool.framework.platform.log.ToolLoggerFactory;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.EnvHelper;
import com.huawei.ism.tool.protocol.factory.ConnectorFactory;
import com.huawei.ism.tool.protocol.tlv.TlvCreater;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JythonContextAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JythonContextAdapter.class);
    private DevNode devNode;
    private String lan;
    private String errMsg;
    private String suggestion;
    private boolean succ;
    private Map<String, Object> contextMap;
    private Map<String, Object> userOpData = new HashMap<String, Object>();

    public JythonContextAdapter() {
        this.contextMap = this.createSsEnv();
    }

    public JythonContextAdapter(DevNode devNode) {
        this.devNode = devNode;
        this.contextMap = this.createSsEnv();
    }

    Map<String, Object> createSsEnv() {
        HashMap<String, Object> ssEnv = new HashMap<String, Object>();
        this.lan = this.getLanguage();
        ssEnv.put("devNode", this.devNode);
        ssEnv.put("dev", this.devNode);
        ssEnv.put("lan", this.lan);
        ssEnv.put("errMsg", this.errMsg);
        ssEnv.put("suggestion", this.suggestion);
        ssEnv.put("succ", this.succ);
        ssEnv.put("connectorFactory", ConnectorFactory.getInstance());
        ssEnv.put("isOem", ApplicationContext.getInstance().isOEM());
        ssEnv.put("userOpData", this.userOpData);
        ssEnv.put("newDev", EnvHelper.getDevMapForRest(this.devNode));
        ssEnv.put("lang", this.lan);
        ssEnv.put("logger", ToolLoggerFactory.getLoggerInStandAlone((String)this.devNode.getDeviceSerialNumber()));
        ssEnv.put("sshFactory", ConnectorFactory.getInstance());
        ssEnv.put("TLVBUILDER", new TlvCreater());
        StringBuilder tmpPath = new StringBuilder();
        tmpPath.append(ApplicationContext.getInstance().getWorkPath());
        tmpPath.append(File.separator);
        tmpPath.append(ApplicationContext.getInstance().getTmpPath());
        tmpPath.append(File.separator);
        tmpPath.append("scriptTmp");
        File tmpFile = new File(tmpPath.toString());
        if (!tmpFile.exists() && !tmpFile.mkdirs()) {
            LOGGER.error("create script tmp path err");
        }
        ssEnv.put("tmpPath", tmpPath.toString());
        return ssEnv;
    }

    private String getLanguage() {
        return LanguageManager.getInstance().getCurrentLanguage().getLanguage();
    }

    public DevNode getDevNode() {
        return this.devNode;
    }

    public void setDevNode(DevNode devNode) {
        this.devNode = devNode;
    }

    public String getLan() {
        return this.lan;
    }

    public void setLan(String lan) {
        this.lan = lan;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public String getSuggestion() {
        return this.suggestion;
    }

    public void setSuggestion(String suggestion) {
        this.suggestion = suggestion;
    }

    public boolean isSucc() {
        return this.succ;
    }

    public void setSucc(boolean succ) {
        this.succ = succ;
    }

    public Map<String, Object> getContextMap() {
        return this.contextMap;
    }

    public void setContextMap(Map<String, Object> contextMap) {
        this.contextMap = contextMap;
    }

    public Map<String, Object> getUserOpData() {
        return this.userOpData;
    }

    public void setUserOpData(Map<String, Object> userOpData) {
        this.userOpData = userOpData;
    }
}

