/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.pyengine.jython;

import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.ism.tool.pyengine.psdk.IPyTaskProxy;
import com.huawei.ism.tool.pyengine.psdk.ITaskCallBack;
import com.huawei.ism.tool.pyengine.psdk.bean.PyTask;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.python.core.Py;
import org.python.util.PythonInterpreter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JythonTaskProxy
implements IPyTaskProxy {
    private static final Logger log = LoggerFactory.getLogger(JythonTaskProxy.class);
    private static final JythonTaskProxy INSTANCE = new JythonTaskProxy();

    private JythonTaskProxy() {
    }

    public static JythonTaskProxy getInstance() {
        return INSTANCE;
    }

    @Override
    public String executeTask(@NotNull PyTask task) {
        return this.executeTask(task, null);
    }

    @Override
    public void submitTask(@NotNull PyTask task, @NotNull ITaskCallBack callBack) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String executeTask(@NotNull PyTask task, ITaskCallBack callBack) {
        JythonExecuter executor = null;
        try {
            File psdkPath = new File(ApplicationContext.getInstance().getWorkPath(), "packages/common/psdk");
            if (!psdkPath.exists()) {
                log.info("psdk dir not exist");
                String string = "";
                return string;
            }
            PythonInterpreter interpreter = new PythonInterpreter(null, Py.defaultSystemState);
            executor = new JythonExecuter(interpreter);
            executor.addClassPaths(Collections.singletonList(psdkPath.getParentFile()));
            interpreter.exec("from psdk.platform.main.py_task_executor import execute_py_task");
            List<Object> result = callBack == null ? executor.invokeFunction("execute_py_task", task) : executor.invokeFunction("execute_py_task", task, callBack);
            String string = (String)result.get(0);
            return string;
        }
        catch (Exception e) {
            log.error("execute py task error", (Throwable)e);
        }
        finally {
            if (null != executor) {
                executor.cleanup();
            }
        }
        return "";
    }
}

