/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.pyengine.psdk;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.huawei.ism.tool.pyengine.psdk.IPyTaskProxy;
import com.huawei.ism.tool.pyengine.psdk.ITaskCallBack;
import com.huawei.ism.tool.pyengine.psdk.bean.PyTask;
import com.huawei.ism.tool.pyengine.psdk.bean.PyTaskResult;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonTaskService {
    private static final Logger log = LoggerFactory.getLogger(PythonTaskService.class);
    private final IPyTaskProxy pyTaskProxy;

    public PythonTaskService(IPyTaskProxy pyTaskProxy) {
        this.pyTaskProxy = pyTaskProxy;
    }

    public PyTaskResult executePyScript(@NotNull PyTask pyTask) {
        return this.executePyScript(pyTask, null);
    }

    public void executeCheckScript(@NotNull PyTask pyTask, @NotNull ITaskCallBack callBack) {
        this.pyTaskProxy.submitTask(pyTask, callBack);
    }

    public PyTaskResult executePyScript(@NotNull PyTask pyTask, ITaskCallBack callBack) {
        String result = "";
        result = this.pyTaskProxy.executeTask(pyTask, callBack);
        log.info("execute py task result={}", (Object)result);
        PyTaskResult taskResult = null;
        try {
            taskResult = (PyTaskResult)JSON.parseObject((String)result, PyTaskResult.class);
        }
        catch (JSONException e) {
            log.error("task result parse exception.", (Throwable)e);
            return new PyTaskResult();
        }
        return taskResult == null ? new PyTaskResult() : taskResult;
    }
}

