/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.pyengine.psdk.bean;

import com.huawei.ism.tool.framework.platform.exception.ToolException;
import com.huawei.ism.tool.framework.platform.util.ApplicationContext;
import com.huawei.ism.tool.framework.platform.util.UserOpDataSaveUtil;
import com.huawei.ism.tool.framework.pubservice.entity.SceneValue;
import com.huawei.ism.tool.framework.pubservice.sceneimpl.SceneEnvironmentImpl;
import com.huawei.json.JSONUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteEnv {
    private static final Logger log = LoggerFactory.getLogger(ExecuteEnv.class);
    private String scenario;
    private String toolName;
    private String step;
    private String sysPath;
    private String toolVersion = "";
    private boolean oem = false;
    private boolean chinaZone = false;
    private Map<String, Object> oriEnv;
    private String sceneValue = "";

    public ExecuteEnv(String scenario, String toolName, String step) {
        this.scenario = scenario;
        this.toolName = toolName;
        this.step = step;
        this.initSceneInfo();
    }

    private void initSceneInfo() {
        try {
            this.oem = ApplicationContext.getInstance().isOEM();
            this.chinaZone = UserOpDataSaveUtil.isChinaToolBox();
            SceneValue sceneData = (SceneValue)SceneEnvironmentImpl.getInstance().getEnvirValueByKey("jsonScene");
            if (sceneData != null) {
                this.sceneValue = JSONUtils.toJson((Object)sceneData);
            }
        }
        catch (ToolException e) {
            log.error("init scene info error.", (Throwable)e);
        }
    }

    public ExecuteEnv() {
    }

    public String getScenario() {
        return this.scenario;
    }

    public String getToolName() {
        return this.toolName;
    }

    public String getStep() {
        return this.step;
    }

    public String getSysPath() {
        return this.sysPath;
    }

    public String getToolVersion() {
        return this.toolVersion;
    }

    public boolean isOem() {
        return this.oem;
    }

    public boolean isChinaZone() {
        return this.chinaZone;
    }

    public Map<String, Object> getOriEnv() {
        return this.oriEnv;
    }

    public String getSceneValue() {
        return this.sceneValue;
    }

    public void setScenario(String scenario) {
        this.scenario = scenario;
    }

    public void setToolName(String toolName) {
        this.toolName = toolName;
    }

    public void setStep(String step) {
        this.step = step;
    }

    public void setSysPath(String sysPath) {
        this.sysPath = sysPath;
    }

    public void setToolVersion(String toolVersion) {
        this.toolVersion = toolVersion;
    }

    public void setOem(boolean oem) {
        this.oem = oem;
    }

    public void setChinaZone(boolean chinaZone) {
        this.chinaZone = chinaZone;
    }

    public void setOriEnv(Map<String, Object> oriEnv) {
        this.oriEnv = oriEnv;
    }

    public void setSceneValue(String sceneValue) {
        this.sceneValue = sceneValue;
    }
}

