/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.pyengine.service.zip;

import com.huawei.ism.tool.base.utils.ZipUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PYZip {
    public static final String PY_ZIP_KEY = "PYENGINE.PY_ZIP";
    private static final Logger LOGGER = LoggerFactory.getLogger(PYZip.class);

    public boolean compressFile(String compressFileFullPath, String srcFilePath) {
        return com.huawei.ism.tool.obase.utils.ZipUtils.compressFile(compressFileFullPath, srcFilePath);
    }

    public boolean decompressTarFile(String tarFileName, String toPath) {
        File tarFile = new File(tarFileName);
        if (!tarFile.isFile()) {
            LOGGER.error("tarFile ERROR!");
            return false;
        }
        return ZipUtils.decompressTarFile((File)tarFile, (String)toPath);
    }

    public boolean decompressTarBz2File(String tarBz2FileName, String toPath) {
        File tarBz2File = new File(tarBz2FileName);
        if (!tarBz2File.exists() || !tarBz2File.isFile()) {
            LOGGER.error("tarBz2File ERROR!");
            return false;
        }
        return com.huawei.ism.tool.obase.utils.ZipUtils.decompressTarBz2File(tarBz2File, toPath);
    }

    public boolean decompressTarGzFile(String tgzfileName, String toPath) {
        File tgzFile = new File(tgzfileName);
        if (!tgzFile.exists() || !tgzFile.isFile()) {
            LOGGER.error("tgzFile ERROR!");
            return false;
        }
        try {
            com.huawei.ism.tool.obase.utils.ZipUtils.decompressTarGzFile(tgzFile, toPath);
            return true;
        }
        catch (IOException e) {
            LOGGER.error("tgzFile unZip error!!!", (Throwable)e);
            return false;
        }
    }

    public List<String> decompressTarGzFileAndGetFileNames(String tgzfileName, String toPath) {
        File tgzFile = new File(tgzfileName);
        if (!tgzFile.exists() || !tgzFile.isFile()) {
            LOGGER.error("tgzFile ERROR!");
            return Collections.emptyList();
        }
        try {
            return com.huawei.ism.tool.obase.utils.ZipUtils.decompressTarGzFileAndGetFileNames(tgzFile, toPath);
        }
        catch (IOException e) {
            LOGGER.error("tgzFile unZip error!!!", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public boolean decompressZipFile(String zipFileName, String toPath) {
        File zipFile = new File(zipFileName);
        if (!zipFile.exists() || !zipFile.isFile()) {
            LOGGER.error("tarBz2File ERROR!");
            return false;
        }
        try {
            com.huawei.ism.tool.obase.utils.ZipUtils.decompressFile(zipFile, toPath);
            return true;
        }
        catch (Exception e) {
            LOGGER.error("decompressZipFile error.", (Throwable)e);
            return false;
        }
    }

    public List<String> decompressZipFileAndGetFileNames(String zipFileName, String toPath) {
        File zipFile = new File(zipFileName);
        if (!zipFile.exists() || !zipFile.isFile()) {
            LOGGER.error("tarBz2File ERROR!");
            return Collections.emptyList();
        }
        try {
            return com.huawei.ism.tool.obase.utils.ZipUtils.decompressFileAndGetFileNames(zipFile, toPath);
        }
        catch (Exception e) {
            LOGGER.error("decompressZipFile error.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public boolean decompressZipFile(String zipFileName, String toPath, String password) {
        File file = new File(zipFileName);
        if (!file.exists() || !file.isFile()) {
            LOGGER.error("tarBz2File ERROR!");
            return false;
        }
        try {
            ZipUtils.decompressZipFile((String)zipFileName, (String)toPath);
            return true;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

