#!/bin/bash

# 单个CPU使用256K连续内存的个数
MEM_256K_TH_PER_ENGINE=514

# 全局变量
ZIP_ENGINE_NUM=""
MEM_256K_MIN_NUM=""
MEM_256K_TOTAL_NUM=0

function get_zip_engine_num_by_lspci()
{
    local engine_num=$(lspci -tv | grep "HiSilicon ZIP Engine" | wc -l)
    ZIP_ENGINE_NUM=${engine_num}
    OS_echo "acc_mem_check.sh get zip engine num by lspci is ${ZIP_ENGINE_NUM}"
}

function get_256k_mem_min_num()
{
    get_zip_engine_num_by_lspci
    # 如果查询不出zip引擎个数,则返回False
    if [ "${ZIP_ENGINE_NUM}" = "0" ]; then
        echo "False"
        exit 0
    fi

    MEM_256K_MIN_NUM=$((${MEM_256K_TH_PER_ENGINE}*${ZIP_ENGINE_NUM}))
    let MEM_256K_MIN_NUM+=2000 # 当前策略是容量后直接+500M
    OS_echo "acc_mem_check.sh 256k mem need at least ${MEM_256K_MIN_NUM}"
}

function calu_num()
{
    val=$1
    num=$2
    let "res1=${val}*2**${num}" # 7*2**3 = 7*8 = 56
    echo $res1
}

# 获取256K连续内存的个数
function get_greater_256k_mem_num()
{
    MEM_256K_TOTAL_NUM=0
    node_num=$(cat /proc/buddyinfo | awk -F"Normal|DMA32" '{print $2}'|awk '{print NF}'|wc -l)
    max=$(cat /proc/buddyinfo | awk -F"Normal|DMA32" '{print $2}'|awk '{print NF}'|awk 'NR==1{print}')
    start=6 # 从256K的连续内存开始统计
    end=$(echo "${max}" - "${start}" | bc)
    buddy_values=$(cat /proc/buddyinfo | awk -F"Normal|DMA32" '{print $2}')
    OS_echo "$buddy_values"

    array2=(${buddy_values})
    for ((i=0; i<${node_num}; i++)); do
        row=$(echo "${array2[@]:$((start+i*$max)):${end}}")
        count=0
        final_vvv=0
        for value in $(echo "${row[@]}"); do
            vvv=$(calu_num ${value} ${count})
            count=$(echo "${count} +1 "|bc)
            final_vvv=$(echo "${final_vvv} + ${vvv}"|bc)
        done
        OS_echo "acc_mem_check.sh 256k mem part$i is ${final_vvv}"
        MEM_256K_TOTAL_NUM=$((${MEM_256K_TOTAL_NUM} + ${final_vvv}))
    done

    OS_echo "acc_mem_check.sh 256k mem total num is ${MEM_256K_TOTAL_NUM}"
}

function check_result()
{
    # 连续检测3次,每次间隔1s,三次都通过才认为通过
    for ((j=0; j<3; j++)); do
        get_greater_256k_mem_num
        if [ ${MEM_256K_MIN_NUM} -gt ${MEM_256K_TOTAL_NUM} ]; then
            echo "False"
            exit 0
        fi
        sleep 1
    done

    echo "True"
}

function check_version()
{
    local cur_version=$(readlink /startup_disk/image/pkg_cur | awk -F '/' '{print $1}')
    local versions=$(ls /startup_disk/image/ | grep -E "^[0-9]{10}$" | grep -v ${cur_version})
    OS_echo "acc_mem_check.sh upgrade version is ${versions}"
    # 目标升级版本是613才进行检测
    if [ "${versions}" != "7600509200" ]; then
        echo "True"
        exit 0
    fi
    # 目标升级版本是613先做一次内存规则，如果是补丁版本为SPH3及以上则返回通过，否则继续检查
    OS_echo "to do compact_memory."
    echo 1 > /proc/sys/vm/compact_memory 2>/dev/null
    sleep 3
    if [ -f "/startup_disk/image/7600509200/hotpatch/patch_cur/patch.yml" ]; then
        sphver=$(cat /startup_disk/image/7600509200/hotpatch/patch_cur/patch.yml | grep "patch_version" | awk -F "SPH" '{print $2}')
        OS_echo "versions:${versions} sphver:$sphver"
        if [ -n "${sphver}" ]; then
            if [ ${sphver} -ge 3 ]; then
                echo "True"
                exit 0
            fi
        fi
    fi
}

check_version

get_256k_mem_min_num

check_result
exit 0
