#!/bin/bash

check1823Card()
{
	# 判断是否有hinicadm3工具
	hinicadm3 info > /dev/null 2>&1
	if [ $? -ne 0 ]; then
		return 0
	fi

	# 获取有多少张1823网卡
	card_nums=$(hinicadm3 info | grep "Card num" | awk -F ':' '{print $2}')
	if [[ -z ${card_nums} ]];then
		return 0
	fi

	# 每张网卡分别获取版本号
	for ((i=0;i<${card_nums};i++))
	do
		card_version=$(hinicadm3 version -i hinic${i} | grep 'mpu' | grep '14.6.28.')
		if [[ -n ${card_version} ]];then
			return 1
		fi
	done

	return 0
}

checkDestPatchVersion()
{
	if [ ! -e "/tmp/check_extend_param" ]; then
		return 0
	fi

	pktVer=$(cat /tmp/check_extend_param | grep "6.1.5.SPH36")
	if [[ -n ${pktVer} ]]; then
		return 1
	else
		return 0
	fi
}

checkCurrPatchVerion()
{
	# 获取当前大包版本号与补丁版本号
	if [ ! -e "/OSM/conf/patch.yml" ]; then
		return 0
	fi

	patchVer=$(grep "patch_version:" /OSM/conf/patch.yml | awk '{print $2}')
	spcVer=$(grep "SpcVersion:" /OSM/conf/patch.yml | awk '{print $2}')
	if [ $spcVer == "6.1.5" ] && [ $patchVer == "SPH30" -o $patchVer == "SPH31" -o $patchVer == "SPH33" ]; then
		return 1 
	else
		return 0
	fi
}

checkDestPatchVersion
isDestVer=$?
if [ $isDestVer -eq 0 ]; then
	echo "True"
	exit 0
fi

checkCurrPatchVerion
isSrcVer=$?
if [ $isSrcVer -eq 0 ]; then
	echo "True"
	exit 0
fi

check1823Card
is1823Card=$?
if [ $is1823Card -eq 0 ]; then
	echo "True"
else
	echo "False"
fi
